/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.ui.gui;

import de.foellix.aql.Log;
import de.foellix.aql.ui.gui.BottomEditor;
import de.foellix.aql.ui.gui.GUI;
import de.foellix.aql.ui.gui.MenubarEditor;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.StackPane;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import org.fxmisc.flowless.VirtualizedScrollPane;
import org.fxmisc.richtext.CodeArea;
import org.fxmisc.richtext.LineNumberFactory;
import org.fxmisc.richtext.model.StyleSpans;
import org.fxmisc.richtext.model.StyleSpansBuilder;
import org.fxmisc.richtext.model.StyledDocument;

public class Editor
extends BorderPane {
    private final GUI parent;
    private boolean stop;
    private final FileChooser openDialog;
    private File currentDir;
    private final CodeArea codeArea;
    private static final String[] KEYWORDS1 = new String[]{"IN", "FROM", "TO", "FEATURING"};
    private static final String[] KEYWORDS2 = new String[]{"UNIFY", "CONNECT", "FILTER"};
    private static final String[] KEYWORDS3 = new String[]{"Permissions", "Flows", "IntentSources", "IntentSinks", "Intents", "IntentFilters", "Statement", "Class", "Method", "App"};
    private static final String KEYWORD1_PATTERN = "\\b(" + String.join((CharSequence)"|", KEYWORDS1) + ")\\b";
    private static final String KEYWORD2_PATTERN = "\\b(" + String.join((CharSequence)"|", KEYWORDS2) + ")\\b";
    private static final String KEYWORD3_PATTERN = "\\b(" + String.join((CharSequence)"|", KEYWORDS3) + ")\\b";
    private static final String PAREN1_PATTERN = "\\(|\\)";
    private static final String PAREN2_PATTERN = "\\[|\\]";
    private static final String QUESTION_PATTERN = "\\?|\\!";
    private static final String ARROW_PATTERN = "\\->";
    private static final String COMMA_PATTERN = "\\,|\\|";
    private static final String STRING_PATTERN = "'([^'\\\\]|\\\\.)*'";
    private static final Pattern PATTERN = Pattern.compile("(?<KEYWORD1>" + KEYWORD1_PATTERN + ")|(?<KEYWORD2>" + KEYWORD2_PATTERN + ")|(?<KEYWORD3>" + KEYWORD3_PATTERN + ")|(?<PAREN1>" + "\\(|\\)" + ")|(?<PAREN2>" + "\\[|\\]" + ")|(?<QUESTION>" + "\\?|\\!" + ")|(?<ARROW>" + "\\->" + ")|(?<COMMA>" + "\\,|\\|" + ")|(?<STRING>" + "'([^'\\\\]|\\\\.)*'" + ")");
    private final MenubarEditor menuBar;

    public Editor(GUI parent) {
        this.parent = parent;
        this.openDialog = new FileChooser();
        this.openDialog.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{new FileChooser.ExtensionFilter("*.* All files", new String[]{"*.*"})});
        this.codeArea = new CodeArea();
        this.codeArea.setWrapText(true);
        this.codeArea.setParagraphGraphicFactory(LineNumberFactory.get(this.codeArea));
        this.codeArea.richChanges().filter(ch -> !((StyledDocument)ch.getInserted()).equals(ch.getRemoved())).subscribe(change -> this.codeArea.setStyleSpans(0, Editor.computeHighlighting(this.codeArea.getText())));
        this.codeArea.setStyle("-fx-font-family: Consolas;");
        StackPane codePane = new StackPane(new Node[]{new VirtualizedScrollPane<CodeArea>(this.codeArea)});
        codePane.setPrefWidth(2.147483647E9);
        this.menuBar = new MenubarEditor(this);
        parent.system.getProgressListener().add(this.menuBar);
        this.setTop((Node)this.menuBar);
        this.setBottom((Node)new BottomEditor());
        this.setCenter((Node)codePane);
    }

    private static StyleSpans<Collection<String>> computeHighlighting(String text) {
        Matcher matcher = PATTERN.matcher(text);
        int lastKwEnd = 0;
        StyleSpansBuilder<Collection<Object>> spansBuilder = new StyleSpansBuilder<Collection<Object>>();
        while (matcher.find()) {
            String styleClass;
            String string = matcher.group("KEYWORD1") != null ? "keyword1" : (matcher.group("KEYWORD2") != null ? "keyword2" : (matcher.group("KEYWORD3") != null ? "keyword3" : (matcher.group("PAREN1") != null ? "paren1" : (matcher.group("PAREN2") != null ? "paren2" : (matcher.group("QUESTION") != null ? "question" : (matcher.group("ARROW") != null ? "arrow" : (matcher.group("COMMA") != null ? "comma" : (styleClass = matcher.group("STRING") != null ? "string" : null))))))));
            assert (styleClass != null);
            spansBuilder.add(Collections.emptyList(), matcher.start() - lastKwEnd);
            spansBuilder.add(Collections.singleton(styleClass), matcher.end() - matcher.start());
            lastKwEnd = matcher.end();
        }
        spansBuilder.add(Collections.emptyList(), text.length() - lastKwEnd);
        return spansBuilder.create();
    }

    public void undo() {
        this.codeArea.undo();
    }

    public void redo() {
        this.codeArea.redo();
    }

    public void autoformat() {
        Platform.runLater(() -> {
            String content = this.codeArea.getText();
            content = content.replaceAll("\n", "");
            content = content.replaceAll("\t", "");
            content = content.replaceAll("\\[", "%PLACEHOLDER_OPENING_BRACKET%");
            content = content.replaceAll("\\]", "%PLACEHOLDER_CLOSING_BRACKET%");
            content = content.replaceAll(", ", "%PLACEHOLDER_COMMA%");
            content = content.replaceAll(",", "%PLACEHOLDER_COMMA%");
            int tab = 0;
            while (content.contains("%PLACEHOLDER_OPENING_BRACKET%") || content.contains("%PLACEHOLDER_CLOSING_BRACKET%") || content.contains("%PLACEHOLDER_COMMA%")) {
                int i;
                String tabStr;
                int i1 = content.indexOf("%PLACEHOLDER_OPENING_BRACKET%", 0);
                int i2 = content.indexOf("%PLACEHOLDER_CLOSING_BRACKET%", 0);
                int i3 = content.indexOf("%PLACEHOLDER_COMMA%", 0);
                if (!(i1 < 0 || i2 >= 0 && i1 >= i2 || i3 >= 0 && i1 >= i3)) {
                    ++tab;
                    tabStr = "";
                    for (i = 0; i < tab; ++i) {
                        tabStr = tabStr + "\t";
                    }
                    content = content.replaceFirst("%PLACEHOLDER_OPENING_BRACKET%", "[\n" + tabStr);
                    continue;
                }
                if (!(i2 < 0 || i1 >= 0 && i2 >= i1 || i3 >= 0 && i2 >= i3)) {
                    --tab;
                    tabStr = "";
                    for (i = 0; i < tab; ++i) {
                        tabStr = tabStr + "\t";
                    }
                    content = content.replaceFirst("%PLACEHOLDER_CLOSING_BRACKET%", "\n" + tabStr + "]");
                    continue;
                }
                if (i3 < 0 || i1 >= 0 && i3 >= i1 || i2 >= 0 && i3 >= i2) continue;
                tabStr = "";
                for (i = 0; i < tab; ++i) {
                    tabStr = tabStr + "\t";
                }
                content = content.replaceFirst("%PLACEHOLDER_COMMA%", ",\n" + tabStr);
            }
            this.codeArea.replaceText(content);
        });
    }

    public void ask() {
        if (!this.stop) {
            this.parent.system.query(this.codeArea.getText());
        } else {
            this.parent.system.cancel();
        }
    }

    public void setContent(String content) {
        Platform.runLater(() -> this.codeArea.replaceText(content));
        this.autoformat();
    }

    public void openFile(File file) throws IOException {
        byte[] encoded = Files.readAllBytes(Paths.get(file.toURI()));
        this.setContent(new String(encoded, StandardCharsets.UTF_8));
    }

    public GUI getParentGUI() {
        return this.parent;
    }

    public String getContent() {
        return this.codeArea.getText();
    }

    public void resetContent() {
        Platform.runLater(() -> this.codeArea.clear());
    }

    public void insertFilename() {
        Platform.runLater(() -> {
            String before;
            int caret;
            String filename = "";
            if (this.currentDir != null) {
                this.openDialog.setInitialDirectory(this.currentDir);
            } else {
                this.openDialog.setInitialDirectory(new File("."));
            }
            this.getParentGUI();
            File file = this.openDialog.showOpenDialog((Window)GUI.stage);
            if (file != null) {
                try {
                    filename = file.getAbsolutePath();
                    this.currentDir = file.getParentFile();
                }
                catch (Exception e) {
                    Log.msg("File not found: " + file.toString(), 1);
                }
            }
            String after = (caret = this.codeArea.getCaretPosition()) >= (before = this.codeArea.getText()).length() ? before.substring(0) + filename : before.substring(0, caret) + filename + before.substring(caret);
            this.codeArea.replaceText(after);
            this.codeArea.requestFocus();
        });
    }

    public boolean isStop() {
        return this.stop;
    }

    public void setStop(boolean stop) {
        this.stop = stop;
    }
}

