/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.ui.gui;

import java.io.File;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;

public class FileChooserUIElement
extends BorderPane {
    private static File lastDirectory;
    private final Stage stage;
    private final FileChooser.ExtensionFilter allFilter = new FileChooser.ExtensionFilter("*.* All files", new String[]{"*.*"});
    private final FileChooser.ExtensionFilter jarFilter = new FileChooser.ExtensionFilter("*.jar Java executable", new String[]{"*.jar"});
    private final FileChooser.ExtensionFilter shFilter = new FileChooser.ExtensionFilter("*.sh Bash script", new String[]{"*.sh"});
    private final FileChooser.ExtensionFilter batFilter = new FileChooser.ExtensionFilter("*.bat Batch script", new String[]{"*.bat"});
    private Button browseBtn;
    private final TextField textField;
    private boolean folder = false;

    public FileChooserUIElement(Stage stage, String btnText) {
        this.stage = stage;
        this.textField = new TextField();
        this.textField.setMaxWidth(Double.MAX_VALUE);
        HBox.setHgrow((Node)this.textField, (Priority)Priority.ALWAYS);
        this.setCenter((Node)this.textField);
        if (btnText != null) {
            this.textField.setStyle("-fx-background-radius: 2.5 0 0 2.5;");
            this.browseBtn = new Button(btnText);
            this.browseBtn.setStyle("-fx-background-radius: 0 2.5 2.5 0;");
            this.browseBtn.setOnAction(eh -> this.buttonClicked());
            BorderPane.setAlignment((Node)this.browseBtn, (Pos)Pos.CENTER);
            this.setRight((Node)this.browseBtn);
        }
    }

    public void setNumeric() {
        this.textField.textProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (!newValue.matches("\\d*")) {
                    FileChooserUIElement.this.textField.setText(newValue.replaceAll("[^\\d]", ""));
                }
            }
        });
    }

    public void setFolder() {
        this.folder = true;
    }

    public TextField getTextField() {
        return this.textField;
    }

    Button getButton() {
        return this.browseBtn;
    }

    void buttonClicked() {
        File file;
        if (this.folder) {
            DirectoryChooser chooser = new DirectoryChooser();
            if (lastDirectory != null) {
                chooser.setInitialDirectory(lastDirectory);
            }
            file = chooser.showDialog((Window)this.stage);
        } else {
            FileChooser chooser = new FileChooser();
            chooser.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{this.allFilter, this.jarFilter, this.shFilter, this.batFilter});
            chooser.setSelectedExtensionFilter(this.allFilter);
            if (lastDirectory != null) {
                chooser.setInitialDirectory(lastDirectory);
            }
            file = chooser.showOpenDialog((Window)this.stage);
        }
        if (file != null) {
            this.textField.setText(file.getAbsolutePath());
            lastDirectory = file.isDirectory() ? file : file.getParentFile();
        }
    }
}

