/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.ui.gui;

import de.foellix.aql.system.IProgressChanged;
import de.foellix.aql.ui.gui.Editor;
import de.foellix.aql.ui.gui.FontAwesome;
import de.foellix.aql.ui.gui.MenuFile;
import de.foellix.aql.ui.gui.MenuHelp;
import de.foellix.aql.ui.gui.ToolsetFile;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.Separator;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;

public class MenubarEditor
extends VBox
implements IProgressChanged {
    private final Editor parent;
    private final ProgressIndicator progressIndicator;
    private final Text progressText;
    private final ProgressBar progressBar;
    private final Button btnAsk;
    private final MenuItem menuItemAsk;

    MenubarEditor(final Editor parent) {
        this.parent = parent;
        MenuBar menuBar = new MenuBar();
        Menu menuEdit = new Menu("Edit");
        MenuItem menuItemUndo = FontAwesome.getInstance().createMenuItem("\uf0e2", "Undo");
        menuItemUndo.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.Z, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}));
        menuItemUndo.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                parent.undo();
            }
        });
        MenuItem menuItemRedo = FontAwesome.getInstance().createMenuItem("\uf01e", "Redo");
        menuItemRedo.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.Y, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}));
        menuItemRedo.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                parent.redo();
            }
        });
        SeparatorMenuItem sep1 = new SeparatorMenuItem();
        MenuItem menuItemAutoFormat = FontAwesome.getInstance().createMenuItem("\uf03c", "Auto Format");
        menuItemAutoFormat.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                parent.autoformat();
            }
        });
        MenuItem menuItemInsertFilename = FontAwesome.getInstance().createMenuItem("\uf0f6", "Insert Filename");
        menuItemInsertFilename.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                parent.insertFilename();
            }
        });
        SeparatorMenuItem sep2 = new SeparatorMenuItem();
        this.menuItemAsk = FontAwesome.getInstance().createMenuItem("\uf04b", "Ask Query");
        this.menuItemAsk.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.R, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}));
        this.menuItemAsk.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                parent.ask();
            }
        });
        menuEdit.getItems().addAll((Object[])new MenuItem[]{menuItemUndo, menuItemRedo, sep1, menuItemAutoFormat, menuItemInsertFilename, sep2, this.menuItemAsk});
        menuBar.getMenus().addAll((Object[])new Menu[]{new MenuFile(parent.getParentGUI()), menuEdit, new MenuHelp(parent.getParentGUI().getStage())});
        ToolBar toolBar = new ToolBar();
        Separator sep3 = new Separator();
        Button btnAutoFormat = FontAwesome.getInstance().createButton("\uf03c");
        btnAutoFormat.setTooltip(new Tooltip("Auto Format"));
        btnAutoFormat.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                parent.autoformat();
            }
        });
        Button btnInsertFilename = FontAwesome.getInstance().createButton("\uf0f6");
        btnInsertFilename.setTooltip(new Tooltip("Insert Filename"));
        btnInsertFilename.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                parent.insertFilename();
            }
        });
        Separator sep4 = new Separator();
        HBox progressBox = new HBox(10.0);
        HBox.setHgrow((Node)progressBox, (Priority)Priority.ALWAYS);
        HBox indicatorBox = new HBox(0.0);
        indicatorBox.setAlignment(Pos.CENTER_LEFT);
        this.progressIndicator = new ProgressIndicator(-1.0);
        this.progressIndicator.setMaxWidth(25.0);
        this.progressIndicator.setMaxHeight(25.0);
        this.progressIndicator.setVisible(false);
        indicatorBox.getChildren().add((Object)this.progressIndicator);
        VBox innerProgressBox = new VBox(0.0);
        this.progressText = new Text("0% (0 of 0)");
        this.progressBar = new ProgressBar(0.0);
        this.progressBar.setPrefWidth(300.0);
        innerProgressBox.getChildren().addAll((Object[])new Node[]{this.progressText, this.progressBar});
        progressBox.getChildren().addAll((Object[])new Node[]{innerProgressBox});
        this.btnAsk = FontAwesome.getInstance().createButton("\uf04b");
        this.btnAsk.setTooltip(new Tooltip("Ask Query"));
        FontAwesome.getInstance().setGreen(this.btnAsk);
        this.btnAsk.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                parent.ask();
            }
        });
        toolBar.getItems().addAll((Object[])new Node[]{new ToolsetFile(parent.getParentGUI()), sep3, btnAutoFormat, btnInsertFilename, sep4, progressBox, indicatorBox, this.btnAsk});
        this.getChildren().addAll((Object[])new Node[]{menuBar, toolBar});
    }

    @Override
    public void onProgressChanged(String step, int inProgress, int done, int max) {
        Platform.runLater(() -> {
            float percentage = max == 0 ? 0.0f : (float)done / (float)max;
            this.progressText.setText(step + " " + Math.round(percentage * 100.0f) + "% (In Progress: " + inProgress + ", Finished: " + done + " of " + max + ")");
            this.progressBar.setProgress((double)percentage);
            if (done < max) {
                this.menuItemAsk.setDisable(true);
                FontAwesome.getInstance().setRed(this.btnAsk);
                this.btnAsk.setText("\uf04d");
                this.parent.setStop(true);
                this.progressIndicator.setVisible(true);
            } else {
                this.menuItemAsk.setDisable(false);
                FontAwesome.getInstance().setGreen(this.btnAsk);
                this.btnAsk.setText("\uf04b");
                this.parent.setStop(false);
                this.progressIndicator.setVisible(false);
            }
        });
    }
}

