/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.ui.gui;

import de.foellix.aql.Log;
import de.foellix.aql.datastructure.Answer;
import de.foellix.aql.datastructure.Attribute;
import de.foellix.aql.datastructure.Flow;
import de.foellix.aql.datastructure.Intentsink;
import de.foellix.aql.datastructure.Intentsource;
import de.foellix.aql.datastructure.Permission;
import de.foellix.aql.datastructure.Reference;
import de.foellix.aql.helper.EqualsHelper;
import de.foellix.aql.system.IAnswerAvailable;
import de.foellix.aql.ui.gui.Edge;
import de.foellix.aql.ui.gui.Node;
import de.foellix.aql.ui.gui.Viewer;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.application.Platform;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.EventHandler;
import javafx.scene.Cursor;
import javafx.scene.SnapshotParameters;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javax.imageio.ImageIO;

public class ViewerGraph
extends HBox
implements IAnswerAvailable {
    private final Viewer parent;
    private Answer answer;
    private final GraphicsContext gc;
    private final Canvas canvas;
    private Tooltip tp;
    private final int horizontalOffset = 10;
    private final int verticalOffset = 10;
    private final int edgeOffset = 30;
    private float y1;
    private float y2;
    private float y3;
    private float y4;
    private float x1;
    private float x2;
    private float x3;
    private final float py1 = 10.0f;
    private final float py2 = 25.0f;
    private final float py3 = 40.0f;
    private final float py4 = 71.0f;
    private final float px1 = 25.0f;
    private final float px2 = 50.0f;
    private final float px3 = 75.0f;
    private int currentSizeY;
    private int currentSizeX;
    private boolean rotated = false;
    private final float zoomFactor = 1.15f;
    private List<Node> intentSinks;
    private List<Node> intentSources;
    private List<Node> permissions;
    private List<Node> references;
    private List<Edge> intentSourceToRef;
    private List<Edge> intentSinkToRef;
    private List<Edge> permissionToRef;
    private List<Edge> refToRef;
    private Map<Object, Node> nodeMap;
    private final File tempGraphFile;
    final ScrollPane scrollPane;

    public ViewerGraph(final Viewer parent) {
        this.parent = parent;
        this.currentSizeX = Math.max(1024, Double.valueOf(this.parent.getParentGUI().getStage().getWidth()).intValue());
        this.currentSizeY = Math.max(768, Double.valueOf(this.parent.getParentGUI().getStage().getHeight()).intValue());
        this.canvas = new Canvas((double)this.currentSizeX, (double)this.currentSizeY);
        this.canvas.addEventHandler(MouseEvent.MOUSE_MOVED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent t) {
                if (ViewerGraph.this.checkForToolTip(t)) {
                    parent.getParentGUI().getStage().getScene().setCursor(Cursor.HAND);
                } else {
                    parent.getParentGUI().getStage().getScene().setCursor(Cursor.DEFAULT);
                    if (ViewerGraph.this.tp != null && ViewerGraph.this.tp.isShowing()) {
                        ViewerGraph.this.tp.hide();
                    }
                }
            }
        });
        this.canvas.addEventHandler(MouseEvent.MOUSE_CLICKED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent t) {
                ViewerGraph.this.showToolTip(t);
            }
        });
        this.gc = this.canvas.getGraphicsContext2D();
        this.scrollPane = new ScrollPane((javafx.scene.Node)this.canvas);
        this.scrollPane.setPrefSize(2.147483647E9, 2.147483647E9);
        this.scrollPane.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        this.scrollPane.setStyle("-fx-focus-color: transparent;");
        this.getChildren().add((Object)this.scrollPane);
        this.tempGraphFile = new File("data/gui/temp.png");
    }

    public void refresh() {
        this.refreshSizes();
        if (this.answer != null) {
            this.initShapes();
        }
        if (!this.rotated) {
            this.scrollPane.setContent((javafx.scene.Node)this.canvas);
        } else {
            this.canvas.setRotate(270.0);
            try {
                WritableImage writableImage = new WritableImage(this.currentSizeY, this.currentSizeX);
                this.canvas.snapshot(new SnapshotParameters(), writableImage);
                BufferedImage renderedImage = SwingFXUtils.fromFXImage((Image)writableImage, null);
                ImageIO.write((RenderedImage)renderedImage, "png", this.tempGraphFile);
                ImageView iv = new ImageView(this.tempGraphFile.toURI().toURL().toString());
                this.scrollPane.setContent((javafx.scene.Node)iv);
            }
            catch (IOException e) {
                Log.error("Could not rotate graph.");
                e.printStackTrace();
            }
            this.canvas.setRotate(0.0);
        }
    }

    private void refreshSizes() {
        if (this.rotated) {
            this.currentSizeX = Math.max(768, Double.valueOf(this.parent.getParentGUI().getStage().getHeight()).intValue()) - 23;
            this.currentSizeY = Math.max(1024, Double.valueOf(this.parent.getParentGUI().getStage().getWidth()).intValue()) - 23;
        } else {
            this.currentSizeX = Math.max(1024, Double.valueOf(this.parent.getParentGUI().getStage().getWidth()).intValue()) - 23;
            this.currentSizeY = Math.max(768, Double.valueOf(this.parent.getParentGUI().getStage().getHeight()).intValue()) - 23;
        }
        if (this.currentSizeX % 2 == 1) {
            --this.currentSizeX;
        }
        if (this.currentSizeY % 2 == 1) {
            --this.currentSizeY;
        }
        this.canvas.setWidth((double)this.currentSizeX);
        this.canvas.setHeight((double)this.currentSizeY);
        this.y1 = this.py1 / 100.0f * (float)this.currentSizeY;
        this.getClass();
        this.y2 = 25.0f / 100.0f * (float)this.currentSizeY;
        this.y3 = this.py3 / 100.0f * (float)this.currentSizeY;
        this.y4 = this.py4 / 100.0f * (float)this.currentSizeY;
        this.getClass();
        this.x1 = 25.0f / 100.0f * (float)this.currentSizeX;
        this.x2 = this.px2 / 100.0f * (float)this.currentSizeX;
        this.x3 = this.px3 / 100.0f * (float)this.currentSizeX;
    }

    private void initShapes() {
        float y;
        float height;
        float x;
        Serializable item;
        int i;
        float count;
        this.nodeMap = new HashMap<Object, Node>();
        this.intentSinks = new ArrayList<Node>();
        if (this.answer.getIntentsinks() != null) {
            count = this.answer.getIntentsinks().getIntentsink().size();
            i = 0;
            while ((float)i < count) {
                item = this.answer.getIntentsinks().getIntentsink().get(i);
                int maxWidth = 500;
                int maxHeight = 50;
                int minWidth = 150;
                int minHeight = 30;
                this.getClass();
                float width = this.x1 - 0.0f - (float)(2 * 10);
                this.getClass();
                x = 0 + 10;
                height = 1.0f / count * (this.y2 - this.y1 - (count - 1.0f) * this.py1);
                y = this.y2 - (float)(i + 1) * (Math.max(Math.min(height, 50.0f), 30.0f) + this.py1) + this.py1;
                Node temp = new Node(x, y, width, height, 500.0f, 50, 150.0f, 30, item);
                this.intentSinks.add(temp);
                this.nodeMap.put(item, temp);
                ++i;
            }
        }
        this.intentSources = new ArrayList<Node>();
        if (this.answer.getIntentsources() != null) {
            count = this.answer.getIntentsources().getIntentsource().size();
            i = 0;
            while ((float)i < count) {
                item = this.answer.getIntentsources().getIntentsource().get(i);
                Node temp = null;
                for (Node existingNode : this.intentSources) {
                    Intentsource existingItem;
                    if (!(existingNode.getReference() instanceof Intentsource) || !EqualsHelper.equals((existingItem = (Intentsource)existingNode.getReference()).getTarget(), ((Intentsource)item).getTarget(), true)) continue;
                    temp = existingNode;
                    break;
                }
                if (temp == null) {
                    int maxWidth = 500;
                    int maxHeight = 50;
                    int minWidth = 150;
                    int minHeight = 30;
                    float f = (float)this.currentSizeX - this.x3;
                    this.getClass();
                    float width = f - (float)(2 * 10);
                    float x2 = (float)this.currentSizeX - Math.max(Math.min(width, 500.0f), 150.0f) - this.py1;
                    float height2 = 1.0f / count * (this.y2 - this.y1 - (count - 1.0f) * this.py1);
                    float y2 = this.y2 + (float)i * (Math.max(Math.min(height2, 50.0f), 30.0f) + this.py1);
                    temp = new Node(x2, y2, width, height2, 500.0f, 50, 150.0f, 30, item);
                    this.intentSources.add(temp);
                }
                this.nodeMap.put(item, temp);
                ++i;
            }
        }
        this.permissions = new ArrayList<Node>();
        if (this.answer.getPermissions() != null) {
            count = this.answer.getPermissions().getPermission().size();
            i = 0;
            while ((float)i < count) {
                item = this.answer.getPermissions().getPermission().get(i);
                int maxWidth = 500;
                int maxHeight = 30;
                int minWidth = 150;
                int minHeight = 15;
                float width = 1.0f / count * (this.x3 - this.x1 - (count - 1.0f) * this.py1);
                x = this.x1 + (float)i * (Math.max(Math.min(width, 500.0f), 150.0f) + this.py1);
                height = this.y1 - 0.0f - this.py1;
                this.getClass();
                y = 0 + 10;
                Node temp = new Node(x, y, width, height, 500.0f, 30, 150.0f, 15, item);
                this.permissions.add(temp);
                this.nodeMap.put(item, temp);
                ++i;
            }
        }
        this.references = new ArrayList<Node>();
        ArrayList<Reference> uniqueReferences = new ArrayList<Reference>();
        if (this.answer.getFlows() != null) {
            for (Flow path : this.answer.getFlows().getFlow()) {
                for (Reference reference : path.getReference()) {
                    boolean alreadyIn = false;
                    for (Reference inReference : uniqueReferences) {
                        if (!EqualsHelper.equals(reference, inReference)) continue;
                        alreadyIn = true;
                        break;
                    }
                    if (alreadyIn) continue;
                    uniqueReferences.add(reference);
                }
            }
            float count2 = uniqueReferences.size();
            int i2 = 0;
            for (Reference item2 : uniqueReferences) {
                int maxWidth = 300;
                int maxHeight = 300;
                int minWidth = 60;
                int minHeight = 250;
                float width = 1.0f / count2 * (this.x3 - this.x1 - (count2 - 1.0f) * this.py1);
                float x3 = this.x1 + (float)i2 * (Math.max(Math.min(width, 300.0f), 60.0f) + this.py1);
                float height3 = this.y4 - this.y3;
                float y3 = this.y3;
                Node temp = new Node(x3, y3, width, height3, 300.0f, 300, 60.0f, 250, item2);
                this.references.add(temp);
                this.nodeMap.put(item2, temp);
                ++i2;
            }
        }
        this.intentSourceToRef = new ArrayList<Edge>();
        if (this.answer.getIntentsources() != null) {
            block8: for (int i3 = 0; i3 < this.answer.getIntentsources().getIntentsource().size(); ++i3) {
                Intentsource item3 = this.answer.getIntentsources().getIntentsource().get(i3);
                Reference r1 = item3.getReference();
                for (Reference r2 : uniqueReferences) {
                    if (!EqualsHelper.equals(r1, r2)) continue;
                    Node start = this.nodeMap.get(item3);
                    Node end = this.nodeMap.get(r2);
                    this.intentSourceToRef.add(new Edge(start, end, -1.0f));
                    continue block8;
                }
            }
        }
        this.intentSinkToRef = new ArrayList<Edge>();
        if (this.answer.getIntentsinks() != null) {
            block10: for (int i4 = 0; i4 < this.answer.getIntentsinks().getIntentsink().size(); ++i4) {
                Intentsink item4 = this.answer.getIntentsinks().getIntentsink().get(i4);
                Reference r1 = item4.getReference();
                for (Reference r2 : uniqueReferences) {
                    if (!EqualsHelper.equals(r1, r2)) continue;
                    Node start = this.nodeMap.get(item4);
                    Node end = this.nodeMap.get(r2);
                    this.intentSinkToRef.add(new Edge(start, end, -1.0f));
                    continue block10;
                }
            }
        }
        this.permissionToRef = new ArrayList<Edge>();
        if (this.answer.getPermissions() != null) {
            block12: for (Permission item5 : this.answer.getPermissions().getPermission()) {
                Reference r1 = item5.getReference();
                for (Reference r2 : uniqueReferences) {
                    if (!EqualsHelper.equals(r1, r2)) continue;
                    Node start = this.nodeMap.get(item5);
                    Node end = this.nodeMap.get(r2);
                    this.permissionToRef.add(new Edge(start, end));
                    continue block12;
                }
            }
        }
        this.refToRef = new ArrayList<Edge>();
        if (this.answer.getFlows() != null) {
            for (Flow p : this.answer.getFlows().getFlow()) {
                Reference r2;
                Reference r1;
                if (p.getReference().get(0).getType().equals("from")) {
                    r1 = p.getReference().get(0);
                    r2 = p.getReference().get(1);
                } else {
                    r1 = p.getReference().get(1);
                    r2 = p.getReference().get(0);
                }
                for (Reference rt : uniqueReferences) {
                    if (!EqualsHelper.equals(rt, r1)) continue;
                    r1 = rt;
                    break;
                }
                for (Reference rt : uniqueReferences) {
                    if (!EqualsHelper.equals(rt, r2)) continue;
                    r2 = rt;
                    break;
                }
                Node start = this.nodeMap.get(r1);
                Node end = this.nodeMap.get(r2);
                Edge temp = new Edge(start, end);
                if (p.getAttributes() != null) {
                    for (Attribute attr : p.getAttributes().getAttribute()) {
                        if (!attr.getName().equals("complete") || !attr.getValue().equals("true")) continue;
                        temp.setSize(4);
                        break;
                    }
                }
                temp.setLength(Math.abs(end.getPosX() - start.getPosX()));
                this.refToRef.add(temp);
            }
            Collections.sort(this.refToRef, new Comparator<Edge>(){

                @Override
                public int compare(Edge e1, Edge e2) {
                    if (e1.getLength() == e2.getLength()) {
                        if (e1.getStart().getPosX() + e1.getEnd().getPosX() > e2.getStart().getPosX() + e2.getEnd().getPosX()) {
                            return 1;
                        }
                        return -1;
                    }
                    if (e1.getLength() > e2.getLength()) {
                        return 1;
                    }
                    return -1;
                }
            });
            int i5 = 0;
            int j = 0;
            float lastLength = 0.0f;
            for (Edge edge : this.refToRef) {
                if (edge.getLength() > lastLength) {
                    ++i5;
                    --j;
                    lastLength = edge.getLength();
                } else {
                    ++j;
                }
                edge.setCornerY(this.y4 + (float)(i5 * this.edgeOffset) + (float)(j * (this.edgeOffset / 5)));
            }
        }
        this.drawShapes();
    }

    private void drawShapes() {
        this.gc.setFill((Paint)Color.WHITE);
        this.gc.fillRect(0.0, 0.0, (double)this.currentSizeX, (double)this.currentSizeY);
        this.gc.setStroke((Paint)Color.BLACK);
        if (Log.logIt(6)) {
            this.gc.setLineWidth(1.0);
            this.gc.strokeLine(0.0, (double)this.y1, (double)this.currentSizeX, (double)this.y1);
            this.gc.strokeLine(0.0, (double)this.y2, (double)this.currentSizeX, (double)this.y2);
            this.gc.strokeLine(0.0, (double)this.y3, (double)this.currentSizeX, (double)this.y3);
            this.gc.strokeLine(0.0, (double)this.y4, (double)this.currentSizeX, (double)this.y4);
            this.gc.strokeLine((double)this.x1, 0.0, (double)this.x1, (double)this.currentSizeY);
            this.gc.strokeLine((double)this.x2, 0.0, (double)this.x2, (double)this.currentSizeY);
            this.gc.strokeLine((double)this.x3, 0.0, (double)this.x3, (double)this.currentSizeY);
        }
        this.gc.setLineWidth(2.0);
        HashMap<Node, Integer> countDocksFromTop = new HashMap<Node, Integer>();
        HashMap<Node, Integer> countDocksFromBottom = new HashMap<Node, Integer>();
        for (Edge edge : this.permissionToRef) {
            if (countDocksFromTop.get(edge.getEnd()) == null) {
                countDocksFromTop.put(edge.getEnd(), new Integer(2));
                continue;
            }
            countDocksFromTop.replace(edge.getEnd(), new Integer((Integer)countDocksFromTop.get(edge.getEnd()) + 1));
        }
        for (Edge edge : this.intentSourceToRef) {
            if (countDocksFromTop.get(edge.getEnd()) == null) {
                countDocksFromTop.put(edge.getEnd(), new Integer(2));
                continue;
            }
            countDocksFromTop.replace(edge.getEnd(), new Integer((Integer)countDocksFromTop.get(edge.getEnd()) + 1));
        }
        for (Edge edge : this.intentSinkToRef) {
            if (countDocksFromTop.get(edge.getEnd()) == null) {
                countDocksFromTop.put(edge.getEnd(), new Integer(2));
                continue;
            }
            countDocksFromTop.replace(edge.getEnd(), new Integer((Integer)countDocksFromTop.get(edge.getEnd()) + 1));
        }
        for (Edge edge : this.refToRef) {
            if (countDocksFromBottom.get(edge.getStart()) == null) {
                countDocksFromBottom.put(edge.getStart(), new Integer(2));
            } else {
                countDocksFromBottom.replace(edge.getStart(), new Integer((Integer)countDocksFromBottom.get(edge.getStart()) + 1));
            }
            if (countDocksFromBottom.get(edge.getEnd()) == null) {
                countDocksFromBottom.put(edge.getEnd(), new Integer(2));
                continue;
            }
            countDocksFromBottom.replace(edge.getEnd(), new Integer((Integer)countDocksFromBottom.get(edge.getEnd()) + 1));
        }
        this.gc.setFill((Paint)Color.web((String)"#d6ace4"));
        this.gc.setStroke((Paint)Color.web((String)"#d6ace4"));
        for (Edge edge : this.permissionToRef) {
            edge.draw(this.gc, countDocksFromTop);
        }
        this.gc.setFill((Paint)Color.web((String)"#f29c9c"));
        this.gc.setStroke((Paint)Color.web((String)"#f29c9c"));
        for (Edge edge : this.intentSourceToRef) {
            edge.draw(this.gc, countDocksFromTop);
        }
        this.gc.setFill((Paint)Color.web((String)"#c0d6a3"));
        this.gc.setStroke((Paint)Color.web((String)"#c0d6a3"));
        for (Edge edge : this.intentSinkToRef) {
            edge.draw(this.gc, countDocksFromTop);
        }
        this.gc.setFill((Paint)Color.web((String)"#a3c3d6"));
        this.gc.setStroke((Paint)Color.web((String)"#a3c3d6"));
        for (Edge edge : this.refToRef) {
            edge.draw(this.gc, countDocksFromBottom);
        }
        this.gc.setFill((Paint)Color.web((String)"#c0d6a3"));
        this.gc.setStroke((Paint)Color.web((String)"#c0d6a3"));
        for (Node node : this.intentSinks) {
            node.draw(this.gc);
        }
        this.gc.setFill((Paint)Color.web((String)"#f29c9c"));
        this.gc.setStroke((Paint)Color.web((String)"#f29c9c"));
        for (Node node : this.intentSources) {
            node.draw(this.gc);
        }
        this.gc.setFill((Paint)Color.web((String)"#d6ace4"));
        this.gc.setStroke((Paint)Color.web((String)"#d6ace4"));
        for (Node node : this.permissions) {
            node.draw(this.gc);
        }
        this.gc.setFill((Paint)Color.web((String)"#a3c3d6"));
        this.gc.setStroke((Paint)Color.web((String)"#a3c3d6"));
        for (Node node : this.references) {
            node.draw(this.gc, true);
        }
    }

    private boolean checkForToolTip(MouseEvent t) {
        try {
            for (Node node : this.intentSinks) {
                if (!this.checkForToolTip(t, node)) continue;
                return true;
            }
            for (Node node : this.intentSources) {
                if (!this.checkForToolTip(t, node)) continue;
                return true;
            }
            for (Node node : this.permissions) {
                if (!this.checkForToolTip(t, node)) continue;
                return true;
            }
            for (Node node : this.references) {
                if (!this.checkForToolTip(t, node)) continue;
                return true;
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean checkForToolTip(MouseEvent t, Node node) {
        double x = t.getX();
        double y = t.getY();
        return x >= (double)node.getPosX() && x <= (double)(node.getPosX() + node.getWidth()) && y >= (double)node.getPosY() && y <= (double)(node.getPosY() + node.getHeight());
    }

    private void showToolTip(MouseEvent t) {
        try {
            if (this.tp != null) {
                this.tp.hide();
            }
            for (Node node : this.intentSinks) {
                this.showToolTip(t, node);
            }
            for (Node node : this.intentSources) {
                this.showToolTip(t, node);
            }
            for (Node node : this.permissions) {
                this.showToolTip(t, node);
            }
            for (Node node : this.references) {
                this.showToolTip(t, node);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void showToolTip(MouseEvent t, Node node) {
        double x = t.getX();
        double y = t.getY();
        if (x >= (double)node.getPosX() && x <= (double)(node.getPosX() + node.getWidth()) && y >= (double)node.getPosY() && y <= (double)(node.getPosY() + node.getHeight())) {
            this.tp = t.getButton() == MouseButton.PRIMARY ? new Tooltip(node.tooltip()) : new Tooltip(node.tooltip2());
            this.tp.show((javafx.scene.Node)t.getSource(), this.parent.getParentGUI().getStage().getX() + t.getSceneX() + 20.0, this.parent.getParentGUI().getStage().getY() + t.getSceneY());
        }
    }

    @Override
    public void answerAvailable(Answer answer, int status) {
        this.answer = answer;
        Platform.runLater(() -> {
            this.refresh();
            this.initShapes();
        });
    }

    public void exportGraph(File file) {
        try {
            WritableImage writableImage = new WritableImage(this.currentSizeX, this.currentSizeY);
            this.canvas.snapshot(new SnapshotParameters(), writableImage);
            BufferedImage renderedImage = SwingFXUtils.fromFXImage((Image)writableImage, null);
            ImageIO.write((RenderedImage)renderedImage, "png", file);
        }
        catch (IOException ex) {
            Log.error("Could not export image.");
        }
    }

    public void rotate() {
        this.rotated = !this.rotated;
        this.refresh();
    }

    public void zoomReset() {
        this.canvas.setScaleX(1.0);
        this.canvas.setScaleY(1.0);
        this.refresh();
    }

    public void zoomIn() {
        double d = this.canvas.getScaleX();
        this.getClass();
        this.canvas.setScaleX(d * (double)1.15f);
        double d2 = this.canvas.getScaleY();
        this.getClass();
        this.canvas.setScaleY(d2 * (double)1.15f);
        this.refresh();
    }

    public void zoomOut() {
        double d = this.canvas.getScaleX();
        this.getClass();
        this.canvas.setScaleX(d / (double)1.15f);
        double d2 = this.canvas.getScaleY();
        this.getClass();
        this.canvas.setScaleY(d2 / (double)1.15f);
        this.refresh();
    }
}

