/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.config.wizard;

import de.foellix.aql.Log;
import de.foellix.aql.config.Tool;
import de.foellix.aql.config.wizard.ConfigWizard;
import de.foellix.aql.config.wizard.EditorOverview;
import de.foellix.aql.config.wizard.ToolTableView;
import javafx.scene.Node;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.VBox;

public class Overview
extends BorderPane {
    public static final int TYPE_TOOL = 0;
    public static final int TYPE_PREPROCESSOR = 1;
    public static final int TYPE_OPERATOR = 2;
    public static final int TYPE_CONVERTER = 3;
    private final ConfigWizard parent;
    EditorOverview editorOverview;
    private final ToolTableView tools;
    private final ToolTableView preprocessors;
    private final ToolTableView operators;
    private final ToolTableView converters;

    Overview(ConfigWizard parent) {
        this.parent = parent;
        VBox toolBox = new VBox();
        this.tools = new ToolTableView(this, 0);
        TitledPane toolPane = new TitledPane("Analysis Tools", (Node)this.tools);
        this.preprocessors = new ToolTableView(this, 1);
        TitledPane preprocessorPane = new TitledPane("Preprocessors", (Node)this.preprocessors);
        preprocessorPane.setExpanded(false);
        this.operators = new ToolTableView(this, 2);
        TitledPane operatorPane = new TitledPane("Operators", (Node)this.operators);
        operatorPane.setExpanded(false);
        this.converters = new ToolTableView(this, 3);
        TitledPane converterPane = new TitledPane("Converters", (Node)this.converters);
        converterPane.setExpanded(false);
        toolBox.getChildren().addAll((Object[])new Node[]{toolPane, preprocessorPane, operatorPane, converterPane});
        this.editorOverview = new EditorOverview(this);
        this.setCenter((Node)this.editorOverview);
        this.setLeft((Node)toolBox);
        this.sync();
    }

    public void sync() {
        try {
            if (this.parent.getConfig().getTools() == null || this.parent.getConfig().getTools().getTool() == null) {
                this.tools.sync(null);
            } else {
                this.tools.sync(this.parent.getConfig().getTools().getTool());
            }
            if (this.parent.getConfig().getPreprocessors() == null || this.parent.getConfig().getPreprocessors().getTool() == null) {
                this.preprocessors.sync(null);
            } else {
                this.preprocessors.sync(this.parent.getConfig().getPreprocessors().getTool());
            }
            if (this.parent.getConfig().getOperators() == null || this.parent.getConfig().getOperators().getTool() == null) {
                this.operators.sync(null);
            } else {
                this.operators.sync(this.parent.getConfig().getOperators().getTool());
            }
            if (this.parent.getConfig().getConverters() == null || this.parent.getConfig().getConverters().getTool() == null) {
                this.converters.sync(null);
            } else {
                this.converters.sync(this.parent.getConfig().getConverters().getTool());
            }
        }
        catch (Exception e) {
            Log.error("Configuration invalid! Please fix you xml code or create a new configuration.");
        }
    }

    public void edit(Tool tool, int type) {
        this.editorOverview.load(tool, type);
    }

    public void apply() {
        this.sync();
        this.parent.syncEditorXML();
    }

    public ConfigWizard getParentGUI() {
        return this.parent;
    }

    public static String typeToString(int type) {
        if (type == 0) {
            return "Questions";
        }
        if (type == 1) {
            return "Keywords";
        }
        if (type == 2) {
            return "Operator";
        }
        if (type == 3) {
            return "Analysis Tool";
        }
        return "UNKNOWN TYPE";
    }
}

