/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.config.wizard;

import de.foellix.aql.config.Tool;
import de.foellix.aql.config.wizard.Overview;
import java.util.List;
import java.util.Optional;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.image.Image;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.stage.Stage;
import javafx.util.Callback;

public class ToolTableView
extends ScrollPane {
    private final Overview parent;
    private final ObservableList<Tool> tools;

    public ToolTableView(final Overview parent, final int type) {
        this.setVbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        final TableView root = new TableView();
        super.setContent((Node)root);
        this.parent = parent;
        this.tools = FXCollections.observableArrayList();
        root.setItems(this.tools);
        TableColumn colName = new TableColumn("Name");
        colName.setCellValueFactory((Callback)new PropertyValueFactory("name"));
        colName.setPrefWidth(150.0);
        TableColumn colVersion = new TableColumn("Version");
        colVersion.setCellValueFactory((Callback)new PropertyValueFactory("version"));
        colVersion.setPrefWidth(150.0);
        TableColumn colQuestion = new TableColumn(Overview.typeToString(type));
        colQuestion.setCellValueFactory((Callback)new PropertyValueFactory("questions"));
        colQuestion.setPrefWidth(150.0);
        root.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        root.setEditable(true);
        root.getColumns().addAll((Object[])new TableColumn[]{colName, colVersion, colQuestion});
        this.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.DELETE) {
                this.delete((Tool)root.getSelectionModel().getSelectedItem());
            }
            if (event.getCode() != KeyCode.UP && event.getCode() != KeyCode.DOWN) {
                event.consume();
            }
        });
        this.addEventFilter(MouseEvent.MOUSE_RELEASED, (EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                if (event.getButton() == MouseButton.SECONDARY) {
                    event.consume();
                    ToolTableView.this.delete((Tool)root.getSelectionModel().getSelectedItem());
                } else if (event.getButton() == MouseButton.PRIMARY) {
                    parent.edit((Tool)root.getSelectionModel().getSelectedItem(), type);
                }
            }
        });
        root.getSelectionModel().selectedItemProperty().addListener((obs, oldSelection, newSelection) -> {
            if (newSelection != null) {
                this.parent.edit((Tool)newSelection, type);
            }
        });
    }

    private void delete(Tool tool) {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        Stage alertStage = (Stage)alert.getDialogPane().getScene().getWindow();
        alertStage.getIcons().add((Object)new Image("file:data/gui/images/icon_16.png", 16.0, 16.0, false, true));
        alertStage.getIcons().add((Object)new Image("file:data/gui/images/icon_32.png", 32.0, 32.0, false, true));
        alertStage.getIcons().add((Object)new Image("file:data/gui/images/icon_64.png", 64.0, 64.0, false, true));
        alert.setTitle("Remove");
        alert.setHeaderText("The following tool will be removed:\n" + tool.getName() + " (" + tool.getVersion() + ")");
        alert.setContentText("Proceed?");
        Optional result = alert.showAndWait();
        if (result.get() == ButtonType.OK) {
            this.tools.remove((Object)tool);
        } else {
            alert.hide();
        }
    }

    public void sync(List<Tool> tools) {
        this.tools.clear();
        if (tools != null) {
            this.tools.addAll(tools);
        }
    }
}

