/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.converter.amandroid;

import de.foellix.aql.Log;
import de.foellix.aql.converter.IConverter;
import de.foellix.aql.datastructure.Answer;
import de.foellix.aql.datastructure.Flow;
import de.foellix.aql.datastructure.Flows;
import de.foellix.aql.datastructure.QuestionPart;
import de.foellix.aql.datastructure.Reference;
import de.foellix.aql.datastructure.Statement;
import de.foellix.aql.helper.EqualsHelper;
import de.foellix.aql.helper.Helper;
import de.foellix.aql.system.task.ToolTaskInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ConverterAmandroid
implements IConverter {
    private File resultFile;
    private List<File> sourceFiles;
    private QuestionPart question;
    private List<String> sourceNeedles;
    private List<String> sinkNeedles;
    private Map<String, Reference> mapSources;
    private Map<String, Reference> mapSinks;

    @Override
    public Answer parse(File resultFile, ToolTaskInfo taskInfo) {
        this.question = taskInfo.getQuestion();
        this.resultFile = resultFile;
        this.sourceFiles = this.searchRecursively(new File(resultFile.getParentFile().getParentFile(), "src"));
        this.sourceNeedles = new ArrayList<String>();
        this.sinkNeedles = new ArrayList<String>();
        this.extractNeedles();
        this.mapSources = new HashMap<String, Reference>();
        this.mapSinks = new HashMap<String, Reference>();
        this.createReferences();
        Answer answer = new Answer();
        answer.setFlows(this.computeFlows());
        return answer;
    }

    private List<File> searchRecursively(File resultFolder) {
        ArrayList<File> returnList = new ArrayList<File>();
        for (File file : resultFolder.listFiles()) {
            if (file.isDirectory()) {
                returnList.addAll(this.searchRecursively(file));
                continue;
            }
            if (!file.getAbsolutePath().endsWith(".jawa")) continue;
            returnList.add(file);
        }
        return returnList;
    }

    private void extractNeedles() {
        try {
            FileReader fr = new FileReader(this.resultFile);
            BufferedReader br = new BufferedReader(fr);
            String line = "";
            while ((line = br.readLine()) != null) {
                if (line.contains("<Descriptors: api_source: L")) {
                    this.sourceNeedles.add(Helper.cutFromFirstToLast(line, "<Descriptors: api_source: L", ">").replace("?", ""));
                    continue;
                }
                if (!line.contains("<Descriptors: api_sink: L")) continue;
                this.sinkNeedles.add(Helper.cutFromFirstToLast(line, "<Descriptors: api_sink: L", " ").replace("?", ""));
            }
            br.close();
            fr.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            Log.error("Error while reading file: " + this.resultFile.getAbsolutePath());
        }
    }

    private void createReferences() {
        for (File sourceFile : this.sourceFiles) {
            try {
                FileReader fr = new FileReader(sourceFile);
                BufferedReader br = new BufferedReader(fr);
                String line = br.readLine();
                if (line == null) {
                    br.close();
                    throw new NullPointerException();
                }
                String classname = Helper.cut(line, "record `", "` @kind ");
                String method = "";
                while ((line = br.readLine()) != null) {
                    if (line.startsWith("procedure `")) {
                        method = Helper.cut(line, "@signature `L", "` @");
                        continue;
                    }
                    if (!line.startsWith("  #")) continue;
                    for (String needle : this.sourceNeedles) {
                        if (!line.contains(needle)) continue;
                        this.mapSources.put(Helper.cut(line, "  #", ".  "), this.createReference(needle, method, classname));
                    }
                    for (String needle : this.sinkNeedles) {
                        if (!line.contains(needle)) continue;
                        this.mapSinks.put(Helper.cut(line, "  #", ".  "), this.createReference(needle, method, classname));
                    }
                }
                br.close();
                fr.close();
            }
            catch (IOException e) {
                Log.error("Error while reading file: " + this.resultFile.getAbsolutePath());
            }
        }
    }

    private Reference createReference(String needle, String method, String classname) {
        Reference reference = new Reference();
        reference.setStatement(this.toStatement(needle));
        reference.setMethod(this.toMethod(method));
        reference.setClassname(classname);
        reference.setApp(this.question.getReferences().get(0).getApp());
        return reference;
    }

    private Statement toStatement(String amandroidString) {
        String stmClass = amandroidString.substring(0, amandroidString.indexOf(";"));
        stmClass = stmClass.replace("/", ".");
        String stmReturntype = amandroidString.substring(amandroidString.indexOf(")") + 1);
        if (stmReturntype.contains(";")) {
            stmReturntype = stmReturntype.substring(0, stmReturntype.indexOf(";"));
        }
        if ((stmReturntype = stmReturntype.replace("/", ".")).startsWith("L")) {
            stmReturntype = stmReturntype.substring(1);
        } else if (stmReturntype.startsWith("I")) {
            stmReturntype = "int";
        } else if (stmReturntype.startsWith("V")) {
            stmReturntype = "void";
        }
        String stmParameters = Helper.cut(amandroidString, "(", ")");
        if (!stmParameters.equals("")) {
            String temp = "";
            for (String parameter : stmParameters.split(";")) {
                if (!temp.equals("")) {
                    temp = temp + ",";
                }
                if (parameter.startsWith("L")) {
                    temp = temp + parameter.substring(1);
                    continue;
                }
                if (stmReturntype.startsWith("I")) {
                    temp = temp + "int";
                    continue;
                }
                if (!stmReturntype.startsWith("V")) continue;
                temp = temp + "void";
            }
            stmParameters = temp.replace("/", ".");
        }
        String stmName = Helper.cut(amandroidString, ";.", ":(");
        String jimpleString = stmClass + ": " + stmReturntype + " " + stmName + "(" + stmParameters + ")";
        Statement statement = Helper.fromStatementString(jimpleString);
        return statement;
    }

    private String toMethod(String amandroidString) {
        String jimpleString = "<" + this.toStatement(amandroidString).getStatementgeneric() + ">";
        return jimpleString;
    }

    private Flows computeFlows() {
        Flows flows = new Flows();
        try {
            FileReader fr = new FileReader(this.resultFile);
            BufferedReader br = new BufferedReader(fr);
            Flow flow = null;
            Reference from = null;
            Reference to = null;
            String line = "";
            while ((line = br.readLine()) != null) {
                if (line.startsWith("      The path consists of the following edges (\"->\"). The nodes have the context information (p1 to pn means which parameter). The source is at the top :")) {
                    flow = new Flow();
                    from = null;
                    to = null;
                    continue;
                }
                if (flow == null) continue;
                boolean newOne = false;
                for (String label : this.mapSources.keySet()) {
                    if (!line.contains(label)) continue;
                    from = this.mapSources.get(label);
                    from.setType("from");
                    newOne = true;
                }
                for (String label : this.mapSinks.keySet()) {
                    if (!line.contains(label)) continue;
                    to = this.mapSinks.get(label);
                    to.setType("to");
                    newOne = true;
                }
                if (!newOne || from == null || to == null) continue;
                flow.getReference().add(from);
                flow.getReference().add(to);
                boolean add = true;
                for (Flow temp : flows.getFlow()) {
                    if (!EqualsHelper.equals(temp, flow)) continue;
                    add = false;
                    break;
                }
                if (!add) continue;
                flows.getFlow().add(flow);
            }
            br.close();
            fr.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            Log.error("Error while reading file: " + this.resultFile.getAbsolutePath());
        }
        return flows;
    }
}

