/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.converter.panda2;

import de.foellix.aql.Log;
import de.foellix.aql.converter.IConverter;
import de.foellix.aql.datastructure.Answer;
import de.foellix.aql.datastructure.Attribute;
import de.foellix.aql.datastructure.Attributes;
import de.foellix.aql.datastructure.Permission;
import de.foellix.aql.datastructure.Permissions;
import de.foellix.aql.datastructure.Reference;
import de.foellix.aql.helper.Helper;
import de.foellix.aql.system.task.ToolTaskInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class ConverterPAndA2
implements IConverter {
    @Override
    public Answer parse(File resultFile, ToolTaskInfo taskInfo) {
        Answer answer = new Answer();
        answer.setPermissions(new Permissions());
        try {
            Reference currentRef = null;
            FileReader fr = new FileReader(resultFile);
            BufferedReader br = new BufferedReader(fr);
            String zeile = "";
            boolean startReading = false;
            while ((zeile = br.readLine()) != null) {
                if (!startReading) {
                    if (!zeile.contains("Textual result - Intra-App Permission Usage Analysis")) continue;
                    startReading = true;
                    continue;
                }
                if (zeile.equals("")) continue;
                if (zeile.startsWith("-----")) {
                    if (!zeile.contains("<") || !zeile.contains(":") || zeile.contains(":=") || zeile.contains("return")) continue;
                    String statement = Helper.cut(zeile, "-----", " in method ");
                    String method = Helper.cut(zeile, " in method ", "-----");
                    String classname = Helper.cut(method, "<", ": ");
                    currentRef = new Reference();
                    currentRef.setApp(taskInfo.getQuestion().getReferences().get(0).getApp());
                    currentRef.setClassname(classname);
                    currentRef.setMethod(method);
                    try {
                        currentRef.setStatement(Helper.fromStatementString(statement));
                    }
                    catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {}
                    continue;
                }
                if (zeile.startsWith("INFO") || zeile.startsWith("DEBUG") || zeile.startsWith("Textual result")) continue;
                String permissionStr = Helper.cut(zeile, null, " ");
                Permission permission = new Permission();
                permission.setName(permissionStr);
                permission.setReference(currentRef);
                String permissionGroupStr = Helper.cut(zeile, "(", ")");
                Attributes attributes = new Attributes();
                Attribute attribute = new Attribute();
                attribute.setName("PermissionGroup");
                attribute.setValue(permissionGroupStr);
                attributes.getAttribute().add(attribute);
                permission.setAttributes(attributes);
                answer.getPermissions().getPermission().add(permission);
                currentRef = Helper.copy(currentRef);
            }
            br.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            Log.error("Error while reading file: " + resultFile.getAbsolutePath());
            return null;
        }
        return answer;
    }
}

