/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.datastructure;

import de.foellix.aql.datastructure.IQuestionNode;
import de.foellix.aql.datastructure.PreviousQuestion;
import de.foellix.aql.datastructure.QuestionPart;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Question
implements IQuestionNode,
Serializable {
    private static final long serialVersionUID = 4453131349077342896L;
    private String operator;
    private final List<IQuestionNode> children;

    public Question(String operator) {
        this.operator = operator;
        this.children = new ArrayList<IQuestionNode>();
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public void addChild(IQuestionNode child) {
        this.children.add(child);
    }

    @Override
    public List<IQuestionNode> getChildren() {
        return this.children;
    }

    @Override
    public List<QuestionPart> getAllQuestionParts() {
        ArrayList<QuestionPart> list = new ArrayList<QuestionPart>();
        for (IQuestionNode node : this.children) {
            if (node instanceof QuestionPart) {
                list.add((QuestionPart)node);
                continue;
            }
            if (!(node instanceof Question)) continue;
            list.addAll(((Question)node).getAllQuestionParts());
        }
        return list;
    }

    @Override
    public List<PreviousQuestion> getAllPreviousQuestions() {
        ArrayList<PreviousQuestion> list = new ArrayList<PreviousQuestion>();
        for (IQuestionNode node : this.children) {
            if (node instanceof PreviousQuestion) {
                list.add((PreviousQuestion)node);
                continue;
            }
            if (!(node instanceof Question)) continue;
            list.addAll(((Question)node).getAllPreviousQuestions());
        }
        return list;
    }

    public String toString() {
        return this.toString(0);
    }

    @Override
    public String toString(int level) {
        StringBuilder sb = new StringBuilder();
        String indent = "";
        for (int i = 0; i < level; ++i) {
            indent = indent + "\t";
        }
        sb.append(indent + this.operator + " [\n");
        for (IQuestionNode node : this.getChildren()) {
            sb.append(node.toString(level + 1));
        }
        sb.append(indent + "]\n");
        return sb.toString();
    }

    @Override
    public String toRAW() {
        StringBuilder sb = new StringBuilder();
        for (IQuestionNode child : this.getChildren()) {
            sb.append(child.toRAW());
        }
        return sb.toString();
    }
}

