/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.helper;

import com.sun.management.OperatingSystemMXBean;
import de.foellix.aql.Log;
import de.foellix.aql.config.ConfigHandler;
import java.lang.management.ManagementFactory;

public class MemoryHelper {
    private static final long PUFFER = 250000000L;
    private final java.lang.management.OperatingSystemMXBean operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
    private final long max = ((OperatingSystemMXBean)this.operatingSystemMXBean).getFreePhysicalMemorySize() - Runtime.getRuntime().maxMemory() - 250000000L;
    private final int adapted = Math.max(1, (int)Math.floor((double)this.max / 1.0E9));
    private static MemoryHelper instance = new MemoryHelper();

    private MemoryHelper() {
        if (this.adapted < ConfigHandler.getInstance().getConfig().getMaxMemory()) {
            Log.warning("Maximum memory (" + ConfigHandler.getInstance().getConfig().getMaxMemory() + " GB) specified in config file will never become available. Using maximal available memory instead: " + this.adapted + " GB");
            ConfigHandler.getInstance().getConfig().setMaxMemory(this.adapted);
        }
    }

    public static MemoryHelper getInstance() {
        return instance;
    }

    public boolean checkMemoryAvailable(int required, boolean ever) {
        if (ever) {
            return this.max >= (long)required * 1000000000L;
        }
        return ((OperatingSystemMXBean)this.operatingSystemMXBean).getFreePhysicalMemorySize() >= (long)required * 1000000000L + 250000000L;
    }

    public int getPossibleMemory(int want) {
        if (this.max < (long)want * 1000000000L) {
            return this.adapted;
        }
        return want;
    }
}

