/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.system;

import de.foellix.aql.Log;
import de.foellix.aql.helper.ZipHelper;
import de.foellix.aql.system.Storage;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class BackupAndReset {
    public static boolean backup() {
        SimpleDateFormat formatter = new SimpleDateFormat("dd_MM_yyyy-HH_mm_ss");
        Date currentTime = new Date();
        try {
            File zipFile = new File("data/storage_backup_" + formatter.format(currentTime) + ".zip");
            ZipHelper.zip(new File("data/storage"), zipFile);
            Log.msg("Successfully backuped storage to: " + zipFile.getAbsolutePath(), 4);
            return true;
        }
        catch (IOException e) {
            Log.error("Something went wrong while backing up the storage: " + e.getMessage());
            return false;
        }
    }

    public static void reset() {
        boolean failed = false;
        File storageFolder = new File("data/storage");
        for (File file : storageFolder.listFiles()) {
            if (!file.getName().endsWith(".xml") || !file.exists() || file.delete()) continue;
            failed = true;
        }
        File storageFile = new File(storageFolder, "storageParts.ser");
        if (storageFile.exists() && !storageFile.delete()) {
            failed = true;
        }
        if ((storageFile = new File(storageFolder, "storagePreprocessors.ser")).exists() && !storageFile.delete()) {
            failed = true;
        }
        Storage.getInstance().reset();
        if (failed) {
            Log.warning("Could not completely reset storage!");
        } else {
            Log.msg("Successfully reset storage!", 4);
        }
    }
}

