/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.system;

import de.foellix.aql.Log;
import de.foellix.aql.config.Tool;
import de.foellix.aql.datastructure.Answer;
import de.foellix.aql.datastructure.IQuestionNode;
import de.foellix.aql.datastructure.Question;
import de.foellix.aql.datastructure.QuestionPart;
import de.foellix.aql.datastructure.Reference;
import de.foellix.aql.helper.HashHelper;
import de.foellix.aql.helper.Helper;
import de.foellix.aql.system.Storage;
import de.foellix.aql.system.System;
import de.foellix.aql.system.ToolSelector;
import de.foellix.aql.system.task.PreprocessorTaskInfo;
import de.foellix.aql.system.task.ToolTaskInfo;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class QueryProcessor {
    private final System parent;
    private List<PreprocessorTaskInfo> preprocessTasks;

    QueryProcessor(System parent) {
        this.parent = parent;
    }

    void preprocess() {
        Log.msg("***** Initial Query *****\n" + this.parent.getCurrentQuery().toString(), 5);
        int size = 0;
        this.preprocessTasks = new ArrayList<PreprocessorTaskInfo>();
        if (this.parent.getCurrentQuery().getAllQuestionParts() != null) {
            for (QuestionPart questionPart : this.parent.getCurrentQuery().getAllQuestionParts()) {
                for (Reference reference : questionPart.getReferences()) {
                    if (this.addPreprocessorTask(questionPart, reference) == null) continue;
                    size += questionPart.getPreprocessor(reference).size();
                }
            }
            this.parent.getScheduler().setWaiting(size);
            this.parent.setMax(this.parent.getScheduler().getWaiting());
            this.parent.progress("Step 1 of 3: Preprocessing");
            if (this.parent.getScheduler().getWaiting() > 0) {
                for (PreprocessorTaskInfo task : this.preprocessTasks) {
                    this.parent.getScheduler().schedulePreprocessor(task);
                }
                this.parent.getScheduler().runSchedule();
            } else {
                this.ask(this.parent.getCurrentQuery());
            }
        } else {
            return;
        }
    }

    PreprocessorTaskInfo addPreprocessorTask(QuestionPart questionPart, Reference reference) {
        if (questionPart.getPreprocessor(reference) != null && !questionPart.getPreprocessor(reference).isEmpty()) {
            String keyword = questionPart.getPreprocessor(reference).get(0);
            Tool preprocessor = ToolSelector.getInstance().selectPreprocessor(questionPart, keyword);
            if (preprocessor != null) {
                boolean running = false;
                for (PreprocessorTaskInfo task : this.preprocessTasks) {
                    if (task.getTool() == null || !task.getHash().equals(HashHelper.createHash(preprocessor, reference.getApp()))) continue;
                    running = true;
                }
                if (!running) {
                    PreprocessorTaskInfo newTaskInfo = new PreprocessorTaskInfo(preprocessor, reference.getApp(), questionPart, keyword);
                    this.preprocessTasks.add(newTaskInfo);
                    return newTaskInfo;
                }
            } else {
                Log.error("No applicable preprocessor found for keyword: " + keyword);
                return null;
            }
        }
        return null;
    }

    void ask(IQuestionNode question) {
        Log.msg("***** Preprocessed Query *****\n" + question.toString(), 5);
        this.parent.setTempStorage(new HashMap<QuestionPart, Answer>());
        if (question.getAllQuestionParts() != null) {
            boolean fixpoint = false;
            block0: while (!fixpoint) {
                fixpoint = true;
                for (QuestionPart questionPart : question.getAllQuestionParts()) {
                    Tool tool = ToolSelector.getInstance().selectTool(questionPart);
                    if (tool == null) {
                        Log.warning("No applicable tool could be found. Trying to transform the question.");
                        IQuestionNode transformedQuestion = this.transformQuestion(questionPart);
                        if (transformedQuestion == null) {
                            if (Storage.getInstance().load(null, questionPart, true) != null) {
                                Log.warning("No applicable tool could be found. However, there is a previously computed answer available.");
                                continue;
                            }
                            Log.error("No applicable tool could be found.");
                            return;
                        }
                        if (question == questionPart) {
                            this.parent.setCurrentQuery(transformedQuestion);
                            this.ask(transformedQuestion);
                            return;
                        }
                        Helper.replaceQuestionPart(question, questionPart, transformedQuestion);
                        fixpoint = false;
                        continue block0;
                    }
                    if (questionPart.getReferences().size() == 1) {
                        File folder = new File(questionPart.getReferences().get(0).getApp().getFile());
                        if (!folder.isDirectory()) continue;
                        ArrayList<File> apks = new ArrayList<File>();
                        for (File file : folder.listFiles()) {
                            if (!file.getAbsolutePath().endsWith(".apk")) continue;
                            apks.add(file);
                        }
                        if (apks.size() < 1) continue;
                        Question expandedQuestion = new Question("COLLECTION");
                        for (File apk : apks) {
                            QuestionPart newPart = Helper.copy(questionPart);
                            newPart.getReferences().get(0).setApp(Helper.createApp(apk.getAbsolutePath()));
                            expandedQuestion.addChild(newPart);
                        }
                        if (question == questionPart) {
                            this.parent.setCurrentQuery(expandedQuestion);
                            this.ask(expandedQuestion);
                            return;
                        }
                        Helper.replaceQuestionPart(question, questionPart, expandedQuestion);
                        fixpoint = false;
                        continue block0;
                    }
                    if (questionPart.getReferences().size() != 2) continue;
                    File folder1 = new File(questionPart.getReferences().get(0).getApp().getFile());
                    File folder2 = new File(questionPart.getReferences().get(0).getApp().getFile());
                    ArrayList<File> apks1 = new ArrayList<File>();
                    ArrayList<File> apks2 = new ArrayList<File>();
                    if (folder1.isDirectory()) {
                        for (File file : folder1.listFiles()) {
                            if (!file.getAbsolutePath().endsWith(".apk")) continue;
                            apks1.add(file);
                        }
                    } else {
                        apks1.add(folder1);
                    }
                    if (folder2.isDirectory()) {
                        for (File file : folder2.listFiles()) {
                            if (!file.getAbsolutePath().endsWith(".apk")) continue;
                            apks2.add(file);
                        }
                    } else {
                        apks2.add(folder2);
                    }
                    if (apks1.size() <= 1 && apks2.size() <= 1) continue;
                    Question expandedQuestion = new Question("COLLECTION");
                    for (File apk1 : apks1) {
                        for (File apk2 : apks2) {
                            QuestionPart newPart = Helper.copy(questionPart);
                            newPart.getReferences().get(0).setApp(Helper.createApp(apk1.getAbsolutePath()));
                            newPart.getReferences().get(1).setApp(Helper.createApp(apk2.getAbsolutePath()));
                            expandedQuestion.addChild(newPart);
                        }
                    }
                    if (question == questionPart) {
                        this.parent.setCurrentQuery(expandedQuestion);
                        this.ask(expandedQuestion);
                        return;
                    }
                    Helper.replaceQuestionPart(question, questionPart, expandedQuestion);
                    fixpoint = false;
                    continue block0;
                }
            }
            Log.msg("***** Final Query *****\n" + question.toString(), 5);
            this.parent.getScheduler().setWaiting(question.getAllQuestionParts().size());
            this.parent.setMax(this.parent.getScheduler().getWaiting());
            if (this.parent.getMax() != 0) {
                this.parent.progress("Step 2 of 3: Analyzing");
                for (QuestionPart questionPart : question.getAllQuestionParts()) {
                    ToolTaskInfo taskInfo = new ToolTaskInfo(ToolSelector.getInstance().selectTool(questionPart), questionPart);
                    this.parent.getScheduler().scheduleTool(taskInfo);
                }
                this.parent.getScheduler().runSchedule();
            } else {
                this.parent.localAnswerAvailable(null, null);
            }
        } else {
            return;
        }
    }

    private IQuestionNode transformQuestion(QuestionPart question) {
        if (question.getMode() == 0 && ToolSelector.getInstance().detectInterApp(question)) {
            Reference to;
            Reference from;
            if (question.getReferences().get(0).getType().equals("from")) {
                from = question.getReferences().get(0);
                to = question.getReferences().get(1);
            } else {
                from = question.getReferences().get(1);
                to = question.getReferences().get(0);
            }
            QuestionPart q1 = new QuestionPart();
            q1.setMode(0);
            q1.addReference(from);
            QuestionPart q2 = new QuestionPart();
            q2.setMode(0);
            q2.addReference(to);
            QuestionPart q3 = new QuestionPart();
            q3.setMode(5);
            q3.addReference(from);
            QuestionPart q4 = new QuestionPart();
            q4.setMode(4);
            q4.addReference(to);
            Question connectNode = new Question("CONNECT");
            connectNode.addChild(q1);
            connectNode.addChild(q2);
            connectNode.addChild(q3);
            connectNode.addChild(q4);
            Question newQuestion = new Question("FILTER");
            newQuestion.addChild(connectNode);
            return newQuestion;
        }
        return null;
    }
}

