/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.system;

import de.foellix.aql.Log;
import de.foellix.aql.config.ConfigHandler;
import de.foellix.aql.config.Tool;
import de.foellix.aql.datastructure.Answer;
import de.foellix.aql.datastructure.App;
import de.foellix.aql.datastructure.WaitingAnswer;
import de.foellix.aql.helper.Helper;
import de.foellix.aql.helper.MemoryHelper;
import de.foellix.aql.system.Storage;
import de.foellix.aql.system.System;
import de.foellix.aql.system.ToolSelector;
import de.foellix.aql.system.task.ExtraTask;
import de.foellix.aql.system.task.OperatorTaskInfo;
import de.foellix.aql.system.task.PreprocessorTaskInfo;
import de.foellix.aql.system.task.Task;
import de.foellix.aql.system.task.TaskInfo;
import de.foellix.aql.system.task.TaskStatus;
import de.foellix.aql.system.task.ToolTaskInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class Scheduler {
    private final System parent;
    private boolean alwaysPreferLoading = true;
    private long timeout = -1L;
    private long waittime;
    private TaskInfo lastOnExitTask;
    private final Lock lock;
    private final List<Task> schedule;
    private final Map<Tool, Integer> runningInstances;
    private final List<Task> currentlyRunningThreads;
    private int memoryInUse;
    private int status;
    private int waiting;

    Scheduler(System parent) {
        this.parent = parent;
        this.lock = new ReentrantLock();
        this.schedule = new ArrayList<Task>();
        this.runningInstances = new HashMap<Tool, Integer>();
        this.currentlyRunningThreads = new ArrayList<Task>();
        this.memoryInUse = 0;
        this.status = 0;
        this.waiting = 0;
    }

    void scheduleTool(ToolTaskInfo taskInfo) {
        Answer storedAnswer = Storage.getInstance().load(taskInfo.getTool(), taskInfo.getQuestion());
        if (storedAnswer == null && this.alwaysPreferLoading) {
            storedAnswer = Storage.getInstance().load(null, taskInfo.getQuestion(), true);
        }
        if (storedAnswer == null) {
            this.schedule.add(new Task(this.parent, taskInfo, this.timeout));
        } else {
            this.parent.localAnswerAvailable(taskInfo.getQuestion(), storedAnswer);
        }
    }

    void schedulePreprocessor(PreprocessorTaskInfo taskInfo) {
        App storedPreprocessedVersion = Storage.getInstance().load(taskInfo.getTool(), taskInfo.getApp());
        if (storedPreprocessedVersion == null) {
            this.schedule.add(new Task(this.parent, taskInfo, this.timeout));
        } else {
            this.parent.preprocessingFinished(taskInfo, storedPreprocessedVersion);
        }
    }

    void scheduleOperator(OperatorTaskInfo taskInfo) {
        Answer storedAnswer = Storage.getInstance().load(taskInfo.getTool(), taskInfo.getQuestion());
        if (storedAnswer == null) {
            this.schedule.add(new Task(this.parent, taskInfo, this.timeout));
        } else {
            this.parent.operatorExecuted(taskInfo.getWaitingAnswer(), storedAnswer);
        }
    }

    void runSchedule() {
        if (this.timeout > 0L) {
            this.waittime = this.timeout * 1000L;
        }
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                while (Scheduler.this.waiting > 0) {
                    int i2 = 0;
                    while (true) {
                        try {
                            Scheduler.this.lock.lock();
                            if (i2 >= Scheduler.this.schedule.size() || Scheduler.this.schedule.size() <= 0) break;
                            Task task = (Task)Scheduler.this.schedule.get(i2);
                            if (!MemoryHelper.getInstance().checkMemoryAvailable(task.getTaskinfo().getMemoryUsage(), true)) {
                                int temp = task.getTaskinfo().getMemoryUsage();
                                task.getTaskinfo().setMemoryUsage(MemoryHelper.getInstance().getPossibleMemory(task.getTaskinfo().getMemoryUsage()));
                                Log.warning("Insufficient memory for task " + task.getId() + ": " + temp + " GB memory will never become available. Decreasing demand to " + task.getTaskinfo().getMemoryUsage() + " GB.");
                            }
                            if (task.getTaskinfo().getMemoryUsage() <= ConfigHandler.getInstance().getConfig().getMaxMemory() - Scheduler.this.memoryInUse && MemoryHelper.getInstance().checkMemoryAvailable(task.getTaskinfo().getMemoryUsage(), false) && (Scheduler.this.runningInstances.get(task.getTaskinfo().getTool()) == null || (Integer)Scheduler.this.runningInstances.get(task.getTaskinfo().getTool()) < task.getTaskinfo().getTool().getInstances() || task.getTaskinfo().getTool().getInstances() <= 0)) {
                                boolean ready = true;
                                if (task.getTaskinfo() instanceof OperatorTaskInfo) {
                                    for (Answer answerPart : ((OperatorTaskInfo)task.getTaskinfo()).getWaitingAnswer().getAnswers()) {
                                        if (!(answerPart instanceof WaitingAnswer) || ((WaitingAnswer)answerPart).hasBeenExecuted()) continue;
                                        ready = false;
                                    }
                                }
                                if (ready) {
                                    Answer[] answerArray = Scheduler.this;
                                    ((Scheduler)answerArray).memoryInUse = ((Scheduler)answerArray).memoryInUse + task.getTaskinfo().getMemoryUsage();
                                    if (Scheduler.this.runningInstances.get(task.getTaskinfo().getTool()) == null) {
                                        Scheduler.this.runningInstances.put(task.getTaskinfo().getTool(), 1);
                                    } else {
                                        Scheduler.this.runningInstances.replace(task.getTaskinfo().getTool(), (Integer)Scheduler.this.runningInstances.get(task.getTaskinfo().getTool()) + 1);
                                    }
                                    Scheduler.this.currentlyRunningThreads.add(task);
                                    task.start();
                                    if (Scheduler.this.timeout > 0L) {
                                        Scheduler.this.waittime = Scheduler.this.timeout * 1000L;
                                    }
                                    Scheduler.this.schedule.remove(i2);
                                    --i2;
                                }
                            }
                        }
                        finally {
                            Scheduler.this.lock.unlock();
                            Scheduler.this.parent.progress();
                        }
                        ++i2;
                    }
                    try {
                        Thread.sleep(100L);
                        if (Scheduler.this.timeout <= 0L || Scheduler.this.currentlyRunningThreads.size() != 0) continue;
                        Scheduler i2 = Scheduler.this;
                        i2.waittime = i2.waittime - 100L;
                        if (Scheduler.this.lastOnExitTask == null || Scheduler.this.waittime > 0L) continue;
                        Log.warning("System seems to be stuck. Reexecuting last onExit task! (" + Helper.replaceVariables(Scheduler.this.lastOnExitTask.getTool().getRunOnExit(), Scheduler.this.lastOnExitTask) + ")");
                        try {
                            new ExtraTask(Scheduler.this.lastOnExitTask, null).runAndWait();
                        }
                        catch (Exception e) {
                            Log.warning("Could not execute last onExit task: " + e.getMessage());
                        }
                    }
                    catch (InterruptedException e) {
                        Log.error("Interrupted while reexecuting last onExit task.");
                    }
                }
            }
        }).start();
        if (Log.logIt(5)) {
            new Thread(new Runnable(){
                private int localStatus;

                @Override
                public void run() {
                    Scheduler.this.status++;
                    this.localStatus = Scheduler.this.status;
                    boolean first = true;
                    while (Scheduler.this.status == this.localStatus && Scheduler.this.waiting > 0) {
                        if (!first) {
                            StringBuilder sb = new StringBuilder("Running processes:\n");
                            for (Task outTask : Scheduler.this.currentlyRunningThreads) {
                                if (outTask.getTaskinfo() instanceof ToolTaskInfo) {
                                    sb.append("# " + outTask.getTaskinfo().getTool().getName() + ": " + ((ToolTaskInfo)outTask.getTaskinfo()).getQuestion().toString() + "\n");
                                    continue;
                                }
                                if (outTask.getTaskinfo() instanceof PreprocessorTaskInfo) {
                                    sb.append("# " + outTask.getTaskinfo().getTool().getName() + ": " + ((PreprocessorTaskInfo)outTask.getTaskinfo()).getApp().getFile() + " | " + ((PreprocessorTaskInfo)outTask.getTaskinfo()).getKeyword() + "\n");
                                    continue;
                                }
                                if (!(outTask.getTaskinfo() instanceof OperatorTaskInfo)) continue;
                                sb.append("# " + outTask.getTaskinfo().getTool().getName() + ": " + ((OperatorTaskInfo)outTask.getTaskinfo()).getQuestion().getOperator() + "\n");
                            }
                            Log.msg(sb.toString().substring(0, sb.toString().lastIndexOf("\n")), 5);
                        } else {
                            first = false;
                        }
                        for (int i = 0; i < 300000; i += 500) {
                            try {
                                Thread.sleep(500L);
                                if (Scheduler.this.waiting > 0) continue;
                                return;
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                }
            }).start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishedTask(Task from, TaskInfo taskInfo, TaskStatus status) {
        this.lastOnExitTask = taskInfo;
        new ExtraTask(taskInfo, null).runAndWait();
        try {
            this.lock.lock();
            this.currentlyRunningThreads.remove(from);
            this.memoryInUse -= taskInfo.getMemoryUsage();
            this.runningInstances.replace(taskInfo.getTool(), this.runningInstances.get(taskInfo.getTool()) - 1);
            if (status != TaskStatus.STATUS_SUCCESS) {
                if (taskInfo instanceof ToolTaskInfo) {
                    taskInfo.setTool(ToolSelector.getInstance().selectTool(((ToolTaskInfo)taskInfo).getQuestion(), ToolSelector.getInstance().getPriority(taskInfo.getTool(), ((ToolTaskInfo)taskInfo).getQuestion().getFeatures())));
                } else if (taskInfo instanceof PreprocessorTaskInfo) {
                    taskInfo.setTool(ToolSelector.getInstance().selectPreprocessor(((PreprocessorTaskInfo)taskInfo).getQuestion(), ((PreprocessorTaskInfo)taskInfo).getKeyword(), ToolSelector.getInstance().getPriority(taskInfo.getTool(), ((PreprocessorTaskInfo)taskInfo).getQuestion().getFeatures())));
                } else {
                    taskInfo.setTool(ToolSelector.getInstance().selectOperator(((OperatorTaskInfo)taskInfo).getQuestion(), ToolSelector.getInstance().getPriority(taskInfo.getTool())));
                }
                if (taskInfo.getTool() != null) {
                    this.schedule.add(new Task(this.parent, taskInfo, this.timeout));
                } else if (taskInfo instanceof ToolTaskInfo) {
                    this.parent.localAnswerAvailable(((ToolTaskInfo)taskInfo).getQuestion(), null);
                } else if (taskInfo instanceof PreprocessorTaskInfo) {
                    this.parent.preprocessingFinished((PreprocessorTaskInfo)taskInfo, null);
                } else {
                    this.parent.operatorExecuted(((OperatorTaskInfo)taskInfo).getWaitingAnswer(), null);
                }
            }
        }
        catch (NullPointerException e) {
            Log.msg("Task finished after abort: " + e.getMessage(), 6);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void decreaseWaiting() {
        --this.waiting;
    }

    public boolean isAlwaysPreferLoading() {
        return this.alwaysPreferLoading;
    }

    public List<Task> getSchedule() {
        return this.schedule;
    }

    public Map<Tool, Integer> getRunningInstances() {
        return this.runningInstances;
    }

    public List<Task> getCurrentlyRunningThreads() {
        return this.currentlyRunningThreads;
    }

    public int getWaiting() {
        return this.waiting;
    }

    public void setAlwaysPreferLoading(boolean alwaysPreferLoading) {
        this.alwaysPreferLoading = alwaysPreferLoading;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    public void setWaiting(int waiting) {
        this.waiting = waiting;
    }
}

