/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.system;

import de.foellix.aql.Log;
import de.foellix.aql.config.Tool;
import de.foellix.aql.datastructure.Answer;
import de.foellix.aql.datastructure.App;
import de.foellix.aql.datastructure.IQuestionNode;
import de.foellix.aql.datastructure.QuestionPart;
import de.foellix.aql.datastructure.handler.AnswerHandler;
import de.foellix.aql.helper.HashHelper;
import de.foellix.aql.helper.Helper;
import de.foellix.aql.system.Data;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class Storage
implements Serializable {
    private static final long serialVersionUID = -8412816715518012412L;
    private final String storageFolder = "data/storage/";
    private final String storageFileParts = "storageParts.ser";
    private final String storageFilePreprocessors = "storagePreprocessors.ser";
    private Data data;
    private Map<String, App> dataPreprocessors;
    private static Storage instance = new Storage();

    private Storage() {
        this.loadData();
        if (this.data == null) {
            this.data = new Data();
        }
        if (this.dataPreprocessors == null) {
            this.dataPreprocessors = new HashMap<String, App>();
        }
    }

    public static Storage getInstance() {
        return instance;
    }

    public void store(Tool tool, IQuestionNode question, Answer answer) {
        String hash = HashHelper.createHash(tool, question);
        Log.msg("Storing part with associated hash: " + hash, 6);
        File xmlFile = new File("data/storage/" + hash + ".xml");
        AnswerHandler.createXML(answer, xmlFile);
        List<IQuestionNode> tempList = this.data.getData().get(hash);
        if (tempList == null) {
            tempList = new ArrayList<IQuestionNode>();
            if (question instanceof QuestionPart) {
                QuestionPart tempQuestionPart;
                if (tool.getQuestions().contains("IntraAppFlows") || tool.getQuestions().contains("InterAppFlows")) {
                    tempQuestionPart = Helper.copy((QuestionPart)question);
                    tempQuestionPart.setMode(0);
                    tempList.add(tempQuestionPart);
                }
                if (tool.getQuestions().contains("Permissions")) {
                    tempQuestionPart = Helper.copy((QuestionPart)question);
                    tempQuestionPart.setMode(1);
                    tempList.add(tempQuestionPart);
                }
                if (tool.getQuestions().contains("IntentFilters")) {
                    tempQuestionPart = Helper.copy((QuestionPart)question);
                    tempQuestionPart.setMode(3);
                    tempList.add(tempQuestionPart);
                }
                if (tool.getQuestions().contains("Intents")) {
                    tempQuestionPart = Helper.copy((QuestionPart)question);
                    tempQuestionPart.setMode(2);
                    tempList.add(tempQuestionPart);
                }
                if (tool.getQuestions().contains("IntentSources")) {
                    tempQuestionPart = Helper.copy((QuestionPart)question);
                    tempQuestionPart.setMode(4);
                    tempList.add(tempQuestionPart);
                }
                if (tool.getQuestions().contains("IntentSinks")) {
                    tempQuestionPart = Helper.copy((QuestionPart)question);
                    tempQuestionPart.setMode(5);
                    tempList.add(tempQuestionPart);
                }
            } else if (!tempList.contains(question)) {
                tempList.add(question);
            }
            this.data.getData().put(hash, tempList);
            this.data.getMayFitHashes().put(HashHelper.createGenericHash(question), hash);
            this.data.getMayFitTool().put(HashHelper.createGenericHash(question), tool.getQuestions());
        } else if (!tempList.contains(question)) {
            tempList.add(question);
        }
        this.saveData();
    }

    public void store(Tool preprocessor, App app, App preprocessedApp) {
        String hash = HashHelper.createHash(preprocessor, app);
        Log.msg("Storing preprocessor with associated hash: " + hash, 6);
        this.dataPreprocessors.put(hash, preprocessedApp);
        this.saveData();
    }

    public Answer load(Tool tool, IQuestionNode question) {
        return this.load(tool, question, false);
    }

    public Answer load(Tool tool, IQuestionNode question, boolean loadSimilar) {
        String hash;
        Object file;
        if (tool != null && ((File)(file = this.getFile(hash = HashHelper.createHash(tool, question)))).exists()) {
            return AnswerHandler.parseXML(this.getFile(hash));
        }
        if (question instanceof QuestionPart) {
            QuestionPart p1 = (QuestionPart)question;
            file = this.data.getData().values().iterator();
            while (file.hasNext()) {
                List list = (List)file.next();
                for (IQuestionNode storedQuestion : list) {
                    if (!(storedQuestion instanceof QuestionPart)) continue;
                    QuestionPart p2 = (QuestionPart)storedQuestion;
                    if (p1.getMode() != p2.getMode() || !p1.toRAW().equals(p2.toRAW())) continue;
                    return AnswerHandler.parseXML(this.getFile(this.data.getData().getKey(list)));
                }
            }
        }
        if (loadSimilar && ((File)(file = this.getFile(hash = this.data.getMayFitHashes().get(HashHelper.createGenericHash(question))))).exists() && question instanceof QuestionPart && this.data.getMayFitTool().get(HashHelper.createGenericHash(question)).contains(Helper.modeToString(((QuestionPart)question).getMode()))) {
            Log.warning("Previously computed answer may not be accurate, because it only fits on App detail-level.");
            return AnswerHandler.parseXML(this.getFile(hash));
        }
        return null;
    }

    public App load(Tool preprocessor, App app) {
        String hash;
        App preprocessedApp;
        if (preprocessor != null && (preprocessedApp = this.dataPreprocessors.get(hash = HashHelper.createHash(preprocessor, app))) != null && this.getFile(preprocessedApp).exists()) {
            return preprocessedApp;
        }
        return null;
    }

    private void loadData() {
        ArrayList<String> removeKeys;
        ObjectInputStream in;
        FileInputStream fileIn;
        try {
            fileIn = new FileInputStream(this.storageFolder + this.storageFileParts);
            in = new ObjectInputStream(fileIn);
            this.data = (Data)in.readObject();
            in.close();
            fileIn.close();
        }
        catch (IOException | ClassNotFoundException e) {
            Log.warning("Could not load part-storage.");
        }
        try {
            fileIn = new FileInputStream(this.storageFolder + this.storageFilePreprocessors);
            in = new ObjectInputStream(fileIn);
            this.dataPreprocessors = (HashMap)in.readObject();
            in.close();
            fileIn.close();
        }
        catch (IOException | ClassNotFoundException e) {
            Log.warning("Could not load preprocessor-storage.");
        }
        if (this.data != null) {
            boolean changed = false;
            removeKeys = new ArrayList<String>();
            for (String hash : this.data.getData().keySet()) {
                if (this.getFile(hash).exists()) continue;
                removeKeys.add(hash);
                changed = true;
            }
            if (changed) {
                for (String removeKey : removeKeys) {
                    this.data.getData().remove(removeKey);
                }
                this.saveData();
            }
        }
        if (this.dataPreprocessors != null) {
            boolean changed = false;
            removeKeys = new ArrayList();
            for (String hash : this.dataPreprocessors.keySet()) {
                if (this.getFile(this.dataPreprocessors.get(hash)).exists()) continue;
                removeKeys.add(hash);
                changed = true;
            }
            if (changed) {
                for (String removeKey : removeKeys) {
                    this.dataPreprocessors.remove(removeKey);
                }
                this.saveData();
            }
        }
    }

    private void saveData() {
        ObjectOutputStream out;
        FileOutputStream fileOut;
        try {
            fileOut = new FileOutputStream(this.storageFolder + this.storageFileParts);
            out = new ObjectOutputStream(fileOut);
            out.writeObject(this.data);
            out.close();
            fileOut.close();
        }
        catch (IOException e) {
            Log.error("Could not save part-storage.");
        }
        try {
            fileOut = new FileOutputStream(this.storageFolder + this.storageFilePreprocessors);
            out = new ObjectOutputStream(fileOut);
            out.writeObject(this.dataPreprocessors);
            out.close();
            fileOut.close();
        }
        catch (IOException e) {
            Log.error("Could not save preprocessor-storage.");
        }
    }

    private File getFile(String hash) {
        return new File(this.storageFolder + hash + ".xml");
    }

    private File getFile(App app) {
        return new File(app.getFile());
    }

    public Data getData() {
        return this.data;
    }

    public void reset() {
        instance = new Storage();
    }
}

