/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.ui.gui;

import de.foellix.aql.datastructure.Answer;
import de.foellix.aql.system.IAnswerAvailable;
import de.foellix.aql.ui.gui.Storage;
import de.foellix.aql.ui.gui.Viewer;
import java.io.File;
import java.io.FileFilter;
import java.util.HashMap;
import java.util.Map;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.TitledPane;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.input.MouseEvent;

public class BottomViewer
extends TitledPane
implements IAnswerAvailable {
    private final Map<TreeItem<String>, File> map = new HashMap<TreeItem<String>, File>();
    private static final TreeView<String> treeView = new TreeView();
    private final TreeItem<String> child1;
    private final TreeItem<String> child2;
    private final TreeItem<String> child3;

    BottomViewer(final Viewer parent) {
        super("Answer-Explorer", treeView);
        treeView.setOnMouseClicked((EventHandler)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent e) {
                if (e.getClickCount() == 2 && BottomViewer.this.map.get(treeView.getSelectionModel().getSelectedItem()) != null) {
                    parent.openFile((File)BottomViewer.this.map.get(treeView.getSelectionModel().getSelectedItem()));
                }
            }
        });
        TreeItem root = new TreeItem((Object)"Answers");
        root.setExpanded(true);
        this.child1 = new TreeItem((Object)"Last saved Answers");
        root.getChildren().add(this.child1);
        this.child2 = new TreeItem((Object)"Automatically saved Answers");
        root.getChildren().add(this.child2);
        this.child3 = new TreeItem((Object)"Partial Answers in Storage");
        root.getChildren().add(this.child3);
        treeView.setRoot(root);
        treeView.setShowRoot(false);
        this.setExpanded(false);
        this.setContent((Node)treeView);
        this.refresh();
    }

    public void refresh() {
        this.map.clear();
        this.child1.getChildren().clear();
        this.child2.getChildren().clear();
        this.child3.getChildren().clear();
        FileFilter xmlFilter = new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().length() > 4 && file.getName().substring(file.getName().length() - 4).equals(".xml");
            }
        };
        for (File file : Storage.getInstance().getLastFiles(true)) {
            TreeItem child = new TreeItem((Object)file.getName());
            this.map.put((TreeItem<String>)child, file);
            this.child1.getChildren().add((Object)child);
        }
        File answerFolder = new File("answers/");
        answerFolder.mkdirs();
        for (File answer : answerFolder.listFiles(xmlFilter)) {
            TreeItem child = new TreeItem((Object)answer.getName());
            this.map.put((TreeItem<String>)child, answer);
            this.child2.getChildren().add((Object)child);
        }
        File file = new File("data/storage/");
        file.mkdirs();
        for (File answer : file.listFiles(xmlFilter)) {
            TreeItem child = new TreeItem((Object)answer.getName());
            this.map.put((TreeItem<String>)child, answer);
            this.child3.getChildren().add((Object)child);
        }
    }

    @Override
    public void answerAvailable(Answer answer, int status) {
        this.refresh();
    }
}

