/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.ui.gui;

import de.foellix.aql.datastructure.Flow;
import de.foellix.aql.ui.gui.Node;
import java.util.Map;
import javafx.scene.canvas.GraphicsContext;

public class Edge {
    private Node start;
    private Node end;
    private float cornerY;
    private Flow reference;
    private float length;
    private int size = 2;

    public Edge(Node start, Node end) {
        this.create(start, end, 0.0f, null);
    }

    public Edge(Node start, Node end, float cornerY) {
        this.create(start, end, cornerY, null);
    }

    public Edge(Node start, Node end, float cornerY, Flow reference) {
        this.create(start, end, cornerY, reference);
    }

    private void create(Node start, Node end, float cornerY, Flow reference) {
        this.start = start;
        this.end = end;
        this.cornerY = cornerY;
        this.reference = reference;
    }

    public void draw(GraphicsContext gc, Map<Node, Integer> countDocks) {
        gc.setLineWidth((double)this.size);
        boolean fromTop = false;
        if (this.cornerY > 0.0f) {
            fromTop = true;
        }
        float startX = countDocks.get(this.start) != null ? this.start.getPosX() + (float)this.start.getDockX(fromTop) * (this.start.getWidth() / (float)countDocks.get(this.start).intValue()) : this.start.getPosX() + (float)this.start.getDockX(fromTop) * (this.start.getWidth() / 2.0f);
        float endX = countDocks.get(this.end) != null ? this.end.getPosX() + (float)this.end.getDockX(fromTop) * (this.end.getWidth() / (float)countDocks.get(this.end).intValue()) : this.end.getPosX() + (float)this.end.getDockX(fromTop) * (this.end.getWidth() / 2.0f);
        float startY = this.start.getPosY() + 0.5f * this.start.getHeight();
        float endY = this.end.getPosY();
        if (this.cornerY == 0.0f) {
            gc.strokeLine((double)startX, (double)startY, (double)endX, (double)endY);
            gc.fillPolygon(new double[]{endX - 5.0f, endX, endX + 5.0f}, new double[]{endY - 10.0f, endY, endY - 10.0f}, 3);
        } else if (this.cornerY < 0.0f) {
            gc.strokeLine((double)startX, (double)startY, (double)endX, (double)startY);
            gc.strokeLine((double)endX, (double)startY, (double)endX, (double)endY);
            gc.fillPolygon(new double[]{endX - 5.0f, endX, endX + 5.0f}, new double[]{endY - 10.0f, endY, endY - 10.0f}, 3);
        } else {
            gc.strokeLine((double)startX, (double)startY, (double)startX, (double)this.cornerY);
            gc.strokeLine((double)startX, (double)this.cornerY, (double)endX, (double)this.cornerY);
            gc.strokeLine((double)endX, (double)this.cornerY, (double)endX, (double)endY);
            gc.fillPolygon(new double[]{endX - 5.0f, endX, endX + 5.0f}, new double[]{endY + 10.0f + this.end.getHeight(), endY + this.end.getHeight(), endY + 10.0f + this.end.getHeight()}, 3);
        }
    }

    public String tooltip() {
        return "Test";
    }

    public Node getStart() {
        return this.start;
    }

    public Node getEnd() {
        return this.end;
    }

    public float getCornerY() {
        return this.cornerY;
    }

    public Flow getReference() {
        return this.reference;
    }

    public float getLength() {
        return this.length;
    }

    public int getSize() {
        return this.size;
    }

    public void setStart(Node start) {
        this.start = start;
    }

    public void setEnd(Node end) {
        this.end = end;
    }

    public void setCornerY(float cornerY) {
        this.cornerY = cornerY;
    }

    public void setReference(Flow reference) {
        this.reference = reference;
    }

    public void setLength(float length) {
        this.length = length;
    }

    public void setSize(int size) {
        this.size = size;
    }
}

