/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.ui.gui;

import de.foellix.aql.ui.gui.FontAwesome;
import de.foellix.aql.ui.gui.GUI;
import de.foellix.aql.ui.gui.MenuFile;
import de.foellix.aql.ui.gui.MenuHelp;
import de.foellix.aql.ui.gui.ToolsetFile;
import de.foellix.aql.ui.gui.Viewer;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Separator;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;

public class MenubarViewer
extends VBox {
    MenubarViewer(final Viewer parent) {
        MenuBar menuBar = new MenuBar();
        Menu menuEdit = new Menu("Edit");
        MenuItem menuItemUndo = FontAwesome.getInstance().createMenuItem("\uf0e2", "Undo");
        menuItemUndo.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.Z, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}));
        menuItemUndo.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                parent.viewerXML.undo();
            }
        });
        MenuItem menuItemRedo = FontAwesome.getInstance().createMenuItem("\uf01e", "Redo");
        menuItemRedo.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.Y, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}));
        menuItemRedo.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                parent.viewerXML.redo();
            }
        });
        menuEdit.getItems().addAll((Object[])new MenuItem[]{menuItemUndo, menuItemRedo});
        Menu menuView = new Menu("View");
        MenuItem menuItemRefreshGraph = FontAwesome.getInstance().createMenuItem("\uf021", "Refresh Graph");
        menuItemRefreshGraph.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                parent.refreshGraph();
            }
        });
        MenuItem menuItemExportGraph = FontAwesome.getInstance().createMenuItem("\uf080", "Export Graph");
        menuItemExportGraph.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (parent.getParentGUI() instanceof GUI) {
                    ((GUI)parent.getParentGUI()).exportGraph();
                }
            }
        });
        SeparatorMenuItem seperator4 = new SeparatorMenuItem();
        MenuItem menuItemRotate = FontAwesome.getInstance().createMenuItem("\uf079", "Rotate Graph");
        menuItemRotate.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.R, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}));
        menuItemRotate.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                parent.rotate();
            }
        });
        SeparatorMenuItem seperator5 = new SeparatorMenuItem();
        MenuItem menuItemZoomReset = FontAwesome.getInstance().createMenuItem("\uf002", "Reset zoom");
        menuItemZoomReset.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.DIGIT0, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}));
        menuItemZoomReset.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                parent.zoomReset();
            }
        });
        MenuItem menuItemZoomIn = FontAwesome.getInstance().createMenuItem("\uf00e", "Zoom in");
        menuItemZoomIn.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.PLUS, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}));
        menuItemZoomIn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                parent.zoomIn();
            }
        });
        MenuItem menuItemZoomOut = FontAwesome.getInstance().createMenuItem("\uf010", "Zoom out");
        menuItemZoomOut.setAccelerator((KeyCombination)new KeyCodeCombination(KeyCode.MINUS, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN}));
        menuItemZoomOut.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                parent.zoomOut();
            }
        });
        menuView.getItems().addAll((Object[])new MenuItem[]{menuItemRefreshGraph, menuItemExportGraph, seperator4, menuItemRotate, seperator5, menuItemZoomReset, menuItemZoomIn, menuItemZoomOut});
        menuBar.getMenus().addAll((Object[])new Menu[]{new MenuFile(parent.getParentGUI()), menuEdit, menuView, new MenuHelp(parent.getParentGUI().getStage())});
        ToolBar toolBar = new ToolBar();
        Separator seperator6 = new Separator();
        Button btnRefreshGraph = FontAwesome.getInstance().createButton("\uf021");
        btnRefreshGraph.setTooltip(new Tooltip("Refresh Graph"));
        btnRefreshGraph.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                parent.refreshGraph();
            }
        });
        Button btnExportGraph = FontAwesome.getInstance().createButton("\uf080");
        btnExportGraph.setTooltip(new Tooltip("Export Graph"));
        btnExportGraph.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (parent.getParentGUI() instanceof GUI) {
                    ((GUI)parent.getParentGUI()).exportGraph();
                }
            }
        });
        HBox spacer = new HBox();
        HBox.setHgrow((Node)spacer, (Priority)Priority.ALWAYS);
        Button btnResetZoom = FontAwesome.getInstance().createButton("\uf002");
        btnResetZoom.setTooltip(new Tooltip("Reset zoom"));
        btnResetZoom.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                parent.zoomReset();
            }
        });
        Button btnRotate = FontAwesome.getInstance().createButton("\uf079");
        btnRotate.setTooltip(new Tooltip("Rotate Graph"));
        btnRotate.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                parent.rotate();
            }
        });
        Separator seperator7 = new Separator();
        Button btnZoomIn = FontAwesome.getInstance().createButton("\uf00e");
        btnZoomIn.setTooltip(new Tooltip("Zoom in"));
        btnZoomIn.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                parent.zoomIn();
            }
        });
        Button btnZoomOut = FontAwesome.getInstance().createButton("\uf010");
        btnZoomOut.setTooltip(new Tooltip("Zoom out"));
        btnZoomOut.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                parent.zoomOut();
            }
        });
        toolBar.getItems().addAll((Object[])new Node[]{new ToolsetFile(parent.getParentGUI()), seperator6, btnRefreshGraph, btnExportGraph, spacer, btnRotate, seperator7, btnResetZoom, btnZoomIn, btnZoomOut});
        if (parent.getParentGUI() instanceof GUI) {
            this.getChildren().addAll((Object[])new Node[]{menuBar, toolBar});
        } else {
            toolBar.getItems().remove((Object)seperator6);
            toolBar.getItems().remove((Object)btnExportGraph);
            this.getChildren().addAll((Object[])new Node[]{toolBar});
        }
    }
}

