/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.ui.gui;

import de.foellix.aql.datastructure.Answer;
import de.foellix.aql.datastructure.handler.AnswerHandler;
import de.foellix.aql.system.IAnswerAvailable;
import java.util.Collection;
import java.util.Collections;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.StackPane;
import org.fxmisc.flowless.VirtualizedScrollPane;
import org.fxmisc.richtext.CodeArea;
import org.fxmisc.richtext.LineNumberFactory;
import org.fxmisc.richtext.model.StyleSpans;
import org.fxmisc.richtext.model.StyleSpansBuilder;

public class ViewerXML
extends BorderPane
implements IAnswerAvailable {
    protected final CodeArea codeArea = new CodeArea();
    private static final Pattern XML_TAG = Pattern.compile("(?<ELEMENT>(</?\\h*)(\\w+)([^<>]*)(\\h*/?>))|(?<COMMENT><!--[^<>]+-->)");
    private static final Pattern ATTRIBUTES = Pattern.compile("(\\w+\\h*)(=)(\\h*\"[^\"]+\")");
    private static final int GROUP_OPEN_BRACKET = 2;
    private static final int GROUP_ELEMENT_NAME = 3;
    private static final int GROUP_ATTRIBUTES_SECTION = 4;
    private static final int GROUP_CLOSE_BRACKET = 5;
    private static final int GROUP_ATTRIBUTE_NAME = 1;
    private static final int GROUP_EQUAL_SYMBOL = 2;
    private static final int GROUP_ATTRIBUTE_VALUE = 3;

    public ViewerXML() {
        this.codeArea.setWrapText(true);
        this.codeArea.setParagraphGraphicFactory(LineNumberFactory.get(this.codeArea));
        this.codeArea.textProperty().addListener((obs, oldText, newText) -> this.codeArea.setStyleSpans(0, ViewerXML.computeHighlighting(newText)));
        this.codeArea.setStyle("-fx-font-family: Consolas;");
        StackPane codePane = new StackPane(new Node[]{new VirtualizedScrollPane<CodeArea>(this.codeArea)});
        codePane.setPrefWidth(2.147483647E9);
        this.setCenter((Node)codePane);
    }

    private static StyleSpans<Collection<String>> computeHighlighting(String text) {
        Matcher matcher = XML_TAG.matcher(text);
        int lastKwEnd = 0;
        StyleSpansBuilder<Collection<Object>> spansBuilder = new StyleSpansBuilder<Collection<Object>>();
        while (matcher.find()) {
            spansBuilder.add(Collections.emptyList(), matcher.start() - lastKwEnd);
            if (matcher.group("COMMENT") != null) {
                spansBuilder.add(Collections.singleton("comment"), matcher.end() - matcher.start());
            } else if (matcher.group("ELEMENT") != null) {
                String attributesText = matcher.group(4);
                spansBuilder.add(Collections.singleton("tagmark"), matcher.end(2) - matcher.start(2));
                spansBuilder.add(Collections.singleton("anytag"), matcher.end(3) - matcher.end(2));
                if (!attributesText.isEmpty()) {
                    lastKwEnd = 0;
                    Matcher amatcher = ATTRIBUTES.matcher(attributesText);
                    while (amatcher.find()) {
                        spansBuilder.add(Collections.emptyList(), amatcher.start() - lastKwEnd);
                        spansBuilder.add(Collections.singleton("attribute"), amatcher.end(1) - amatcher.start(1));
                        spansBuilder.add(Collections.singleton("tagmark"), amatcher.end(2) - amatcher.end(1));
                        spansBuilder.add(Collections.singleton("avalue"), amatcher.end(3) - amatcher.end(2));
                        lastKwEnd = amatcher.end();
                    }
                    if (attributesText.length() > lastKwEnd) {
                        spansBuilder.add(Collections.emptyList(), attributesText.length() - lastKwEnd);
                    }
                }
                lastKwEnd = matcher.end(4);
                spansBuilder.add(Collections.singleton("tagmark"), matcher.end(5) - lastKwEnd);
            }
            lastKwEnd = matcher.end();
        }
        spansBuilder.add(Collections.emptyList(), text.length() - lastKwEnd);
        return spansBuilder.create();
    }

    @Override
    public void answerAvailable(Answer answer, int status) {
        Platform.runLater(() -> {
            this.codeArea.replaceText(AnswerHandler.createXMLString(answer));
            this.codeArea.scrollYBy(0.0);
        });
    }

    public String getContent() {
        return this.codeArea.getText();
    }

    public void resetContent() {
        this.codeArea.clear();
    }

    public void undo() {
        this.codeArea.undo();
    }

    public void redo() {
        this.codeArea.redo();
    }
}

