/*
 * Decompiled with CFR 0.152.
 */
package net.dongliu.apk.parser.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.dongliu.apk.parser.bean.ApkMeta;
import net.dongliu.apk.parser.bean.GlEsVersion;
import net.dongliu.apk.parser.bean.IconPath;
import net.dongliu.apk.parser.bean.Permission;
import net.dongliu.apk.parser.bean.UseFeature;
import net.dongliu.apk.parser.parser.XmlStreamer;
import net.dongliu.apk.parser.struct.ResourceValue;
import net.dongliu.apk.parser.struct.resource.ResourceEntry;
import net.dongliu.apk.parser.struct.resource.ResourceTable;
import net.dongliu.apk.parser.struct.resource.Type;
import net.dongliu.apk.parser.struct.xml.Attribute;
import net.dongliu.apk.parser.struct.xml.Attributes;
import net.dongliu.apk.parser.struct.xml.XmlCData;
import net.dongliu.apk.parser.struct.xml.XmlNamespaceEndTag;
import net.dongliu.apk.parser.struct.xml.XmlNamespaceStartTag;
import net.dongliu.apk.parser.struct.xml.XmlNodeEndTag;
import net.dongliu.apk.parser.struct.xml.XmlNodeStartTag;

public class ApkMetaTranslator
implements XmlStreamer {
    private String[] tagStack = new String[100];
    private int depth = 0;
    private ApkMeta apkMeta = new ApkMeta();
    private List<IconPath> iconPaths = Collections.emptyList();
    @Nonnull
    private ResourceTable resourceTable;
    @Nullable
    private Locale locale;

    public ApkMetaTranslator(@Nonnull ResourceTable resourceTable, @Nullable Locale locale) {
        this.resourceTable = Objects.requireNonNull(resourceTable);
        this.locale = locale;
    }

    @Override
    public void onStartTag(XmlNodeStartTag xmlNodeStartTag) {
        Attributes attributes = xmlNodeStartTag.getAttributes();
        switch (xmlNodeStartTag.getName()) {
            case "application": {
                Attribute iconAttr;
                String label = attributes.getString("label");
                if (label != null) {
                    this.apkMeta.setLabel(label);
                }
                if ((iconAttr = attributes.get("icon")) == null) break;
                ResourceValue resourceValue = iconAttr.getTypedValue();
                if (resourceValue != null && resourceValue instanceof ResourceValue.ReferenceResourceValue) {
                    long resourceId = ((ResourceValue.ReferenceResourceValue)resourceValue).getReferenceResourceId();
                    List<ResourceTable.Resource> resources = this.resourceTable.getResourcesById(resourceId);
                    if (resources.isEmpty()) break;
                    ArrayList<IconPath> icons = new ArrayList<IconPath>();
                    boolean hasDefault = false;
                    for (ResourceTable.Resource resource : resources) {
                        Type type = resource.getType();
                        ResourceEntry resourceEntry = resource.getResourceEntry();
                        String path = resourceEntry.toStringValue(this.resourceTable, this.locale);
                        if (type.getDensity() == 0) {
                            hasDefault = true;
                            this.apkMeta.setIcon(path);
                        }
                        IconPath iconPath = new IconPath(path, type.getDensity());
                        icons.add(iconPath);
                    }
                    if (!hasDefault) {
                        this.apkMeta.setIcon(((IconPath)icons.get(0)).getPath());
                    }
                    this.iconPaths = icons;
                    break;
                }
                String value = iconAttr.getValue();
                if (value == null) break;
                this.apkMeta.setIcon(value);
                IconPath iconPath = new IconPath(value, 0);
                this.iconPaths = Collections.singletonList(iconPath);
                break;
            }
            case "manifest": {
                this.apkMeta.setPackageName(attributes.getString("package"));
                this.apkMeta.setVersionName(attributes.getString("versionName"));
                this.apkMeta.setVersionCode(attributes.getLong("versionCode"));
                String installLocation = attributes.getString("installLocation");
                if (installLocation == null) break;
                this.apkMeta.setInstallLocation(installLocation);
                break;
            }
            case "uses-sdk": {
                this.apkMeta.setMinSdkVersion(attributes.getString("minSdkVersion"));
                this.apkMeta.setTargetSdkVersion(attributes.getString("targetSdkVersion"));
                this.apkMeta.setMaxSdkVersion(attributes.getString("maxSdkVersion"));
                break;
            }
            case "supports-screens": {
                this.apkMeta.setAnyDensity(attributes.getBoolean("anyDensity", false));
                this.apkMeta.setSmallScreens(attributes.getBoolean("smallScreens", false));
                this.apkMeta.setNormalScreens(attributes.getBoolean("normalScreens", false));
                this.apkMeta.setLargeScreens(attributes.getBoolean("largeScreens", false));
                break;
            }
            case "uses-feature": {
                String name = attributes.getString("name");
                boolean required = attributes.getBoolean("required", false);
                if (name != null) {
                    UseFeature useFeature = new UseFeature();
                    useFeature.setName(name);
                    useFeature.setRequired(required);
                    this.apkMeta.addUseFeatures(useFeature);
                    break;
                }
                Integer gl = attributes.getInt("glEsVersion");
                if (gl == null) break;
                int v = gl;
                GlEsVersion glEsVersion = new GlEsVersion();
                glEsVersion.setMajor(v >> 16);
                glEsVersion.setMinor(v & 0xFFFF);
                glEsVersion.setRequired(required);
                this.apkMeta.setGlEsVersion(glEsVersion);
                break;
            }
            case "uses-permission": {
                this.apkMeta.addUsesPermission(attributes.getString("name"));
                break;
            }
            case "permission": {
                Permission permission = new Permission();
                permission.setName(attributes.getString("name"));
                permission.setLabel(attributes.getString("label"));
                permission.setIcon(attributes.getString("icon"));
                permission.setGroup(attributes.getString("group"));
                permission.setDescription(attributes.getString("description"));
                String protectionLevel = attributes.getString("android:protectionLevel");
                if (protectionLevel != null) {
                    permission.setProtectionLevel(protectionLevel);
                }
                this.apkMeta.addPermission(permission);
            }
        }
        this.tagStack[this.depth++] = xmlNodeStartTag.getName();
    }

    @Override
    public void onEndTag(XmlNodeEndTag xmlNodeEndTag) {
        --this.depth;
    }

    @Override
    public void onCData(XmlCData xmlCData) {
    }

    @Override
    public void onNamespaceStart(XmlNamespaceStartTag tag) {
    }

    @Override
    public void onNamespaceEnd(XmlNamespaceEndTag tag) {
    }

    @Nonnull
    public ApkMeta getApkMeta() {
        return this.apkMeta;
    }

    @Nonnull
    public List<IconPath> getIconPaths() {
        return this.iconPaths;
    }

    private boolean matchTagPath(String ... tags) {
        if (this.depth != tags.length + 1) {
            return false;
        }
        for (int i = 1; i < this.depth; ++i) {
            if (this.tagStack[i].equals(tags[i - 1])) continue;
            return false;
        }
        return true;
    }

    private boolean matchLastTag(String tag) {
        return this.tagStack[this.depth - 1].endsWith(tag);
    }
}

