/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx.collection;

import java.util.Collections;
import java.util.List;
import org.reactfx.collection.QuasiListModification;

class QuasiListModificationImpl<E>
implements QuasiListModification<E> {
    private final int position;
    private final List<? extends E> removed;
    private final int addedSize;

    QuasiListModificationImpl(int position, List<? extends E> removed, int addedSize) {
        this.position = position;
        this.removed = Collections.unmodifiableList(removed);
        this.addedSize = addedSize;
    }

    @Override
    public int getFrom() {
        return this.position;
    }

    @Override
    public int getAddedSize() {
        return this.addedSize;
    }

    @Override
    public List<? extends E> getRemoved() {
        return this.removed;
    }

    public String toString() {
        return "[modification at: " + this.getFrom() + ", removed: " + this.getRemoved() + ", added size: " + this.getAddedSize() + "]";
    }
}

