/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.config;

import de.foellix.aql.Log;
import de.foellix.aql.config.Config;
import de.foellix.aql.config.Priority;
import de.foellix.aql.config.Tool;
import de.foellix.aql.config.wizard.ConfigWizard;
import de.foellix.aql.ui.gui.GUI;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonType;
import javafx.scene.image.Image;
import javafx.stage.Stage;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class ConfigHandler {
    private File configFile = new File("config.xml");
    private Config config = null;
    private static ConfigHandler instance = new ConfigHandler();
    private boolean offeredWizard = false;

    private ConfigHandler() {
    }

    public static ConfigHandler getInstance() {
        return instance;
    }

    public Config getConfig() {
        return this.getConfig(false);
    }

    public Config getConfig(boolean reload) {
        if (this.config == null || reload) {
            if (this.configFile.exists()) {
                this.config = ConfigHandler.parseXML(this.configFile);
                if (this.config.getAndroidPlatforms().contains("\\")) {
                    this.config.setAndroidPlatforms(this.config.getAndroidPlatforms().replaceAll("\\", "/"));
                }
            } else if (!this.offeredWizard) {
                this.offeredWizard = true;
                if (!GUI.showConfigWizard) {
                    this.offerConfigWizard(GUI.stage);
                }
            }
        }
        return this.config;
    }

    public void offerConfigWizard(Stage stage) {
        if (GUI.started) {
            Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
            Stage alertStage = (Stage)alert.getDialogPane().getScene().getWindow();
            alertStage.getIcons().add((Object)new Image("file:data/gui/images/icon_16.png", 16.0, 16.0, false, true));
            alertStage.getIcons().add((Object)new Image("file:data/gui/images/icon_32.png", 32.0, 32.0, false, true));
            alertStage.getIcons().add((Object)new Image("file:data/gui/images/icon_64.png", 64.0, 64.0, false, true));
            alert.setTitle("Missing configuration");
            alert.setHeaderText("Configuration file could not be found.");
            alert.setContentText("Do you want to start the configuration wizard?");
            Optional result = alert.showAndWait();
            if (result.get() == ButtonType.OK) {
                new ConfigWizard(stage, ConfigHandler.getInstance().getConfigFile());
            } else {
                Log.warning("No configuration specified.");
            }
        } else {
            Log.error("Cannot find default configuration (config.xml) and no other configuration specified. Stopping execution.");
            System.exit(1);
        }
    }

    public static Config parseXML(File configFile) {
        if (configFile != null) {
            try {
                return ConfigHandler.parseXML(new FileReader(configFile));
            }
            catch (FileNotFoundException e) {
                Log.error("Cannot find config file: " + configFile.getAbsolutePath());
            }
        }
        return null;
    }

    public static Config parseXML(String configString) {
        if (configString != null) {
            return ConfigHandler.parseXML(new StringReader(configString));
        }
        return null;
    }

    private static Config parseXML(Reader reader) {
        if (reader != null) {
            try {
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Config.class});
                Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
                Config config = (Config)jaxbUnmarshaller.unmarshal(reader);
                reader.close();
                return config;
            }
            catch (IOException | JAXBException e) {
                Log.error("Cannot parse XML document currently. It must be corrupted: " + e.getMessage());
            }
        }
        return null;
    }

    public String toString() {
        return ConfigHandler.toXML(this.config);
    }

    public static String toXML(Config config) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Config.class});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
            jaxbMarshaller.setProperty("jaxb.encoding", (Object)"utf-8");
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            jaxbMarshaller.marshal((Object)config, (OutputStream)outputStream);
            String returnStr = ((Object)outputStream).toString();
            ((OutputStream)outputStream).close();
            return returnStr;
        }
        catch (IOException | JAXBException e) {
            Log.error("Something went wrong while creating the XML string (" + e.getMessage() + ").");
            return null;
        }
    }

    public void setConfig(File config) {
        this.configFile = config;
        this.getConfig(true);
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public Tool getToolByName(String name) {
        return this.getByName(name, null, this.config.getTools().getTool());
    }

    public Tool getToolByName(String name, String version) {
        return this.getByName(name, version, this.config.getTools().getTool());
    }

    public Tool getPreprocessorByName(String name) {
        return this.getByName(name, null, this.config.getPreprocessors().getTool());
    }

    public Tool getPreprocessorByName(String name, String version) {
        return this.getByName(name, version, this.config.getPreprocessors().getTool());
    }

    public Tool getOperatorByName(String name) {
        return this.getByName(name, null, this.config.getOperators().getTool());
    }

    public Tool getOperatorByName(String name, String version) {
        return this.getByName(name, version, this.config.getOperators().getTool());
    }

    public Tool getConverterByName(String name) {
        return this.getByName(name, null, this.config.getConverters().getTool());
    }

    public Tool getConverterByName(String name, String version) {
        return this.getByName(name, version, this.config.getConverters().getTool());
    }

    private Tool getByName(String name, String version, List<Tool> list) {
        for (Tool tool : list) {
            if (!tool.getName().equals(name) || version != null && !tool.getVersion().equals(version)) continue;
            return tool;
        }
        return null;
    }

    public List<Tool> getAllToolsOfAnyKind() {
        ArrayList<Tool> tempList = new ArrayList<Tool>();
        if (this.config.getTools() != null && !this.config.getTools().getTool().isEmpty()) {
            tempList.addAll(this.config.getTools().getTool());
        }
        if (this.config.getPreprocessors() != null && !this.config.getPreprocessors().getTool().isEmpty()) {
            tempList.addAll(this.config.getPreprocessors().getTool());
        }
        if (this.config.getOperators() != null && !this.config.getOperators().getTool().isEmpty()) {
            tempList.addAll(this.config.getOperators().getTool());
        }
        if (this.config.getConverters() != null && !this.config.getConverters().getTool().isEmpty()) {
            tempList.addAll(this.config.getConverters().getTool());
        }
        return tempList;
    }

    public int getMaxConfiguredPriority() {
        int returnValue = -1;
        for (Tool t : this.getAllToolsOfAnyKind()) {
            int temp = 0;
            for (Priority p : t.getPriority()) {
                temp += p.getValue();
            }
            if (temp <= returnValue) continue;
            returnValue = temp;
        }
        return returnValue;
    }
}

