/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.config.wizard;

import de.foellix.aql.Log;
import de.foellix.aql.config.Config;
import de.foellix.aql.config.ConfigHandler;
import de.foellix.aql.config.Converters;
import de.foellix.aql.config.Operators;
import de.foellix.aql.config.Preprocessors;
import de.foellix.aql.config.Tool;
import de.foellix.aql.config.Tools;
import de.foellix.aql.config.wizard.EditorXML;
import de.foellix.aql.config.wizard.Menubar;
import de.foellix.aql.config.wizard.Overview;
import de.foellix.aql.ui.gui.GUI;
import de.foellix.aql.ui.gui.IGUI;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.Optional;
import javafx.application.Platform;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.image.Image;
import javafx.scene.layout.BorderPane;
import javafx.stage.DirectoryChooser;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;

public class ConfigWizard
extends Stage
implements IGUI {
    private final Stage parent;
    private boolean overviewActive = true;
    private final Overview overview;
    private final EditorXML editor;
    private final DirectoryChooser openDialogFolder;
    private final FileChooser openDialogFile;
    private final FileChooser saveDialog;
    private final File lastDirectory = new File(".");
    private Config currentConfig = null;
    private File currentConfigFile = null;
    private int newToolCounter = 0;

    public ConfigWizard(Stage parent, File configFile) {
        this.parent = parent;
        this.currentConfig = configFile.exists() ? ConfigHandler.parseXML(configFile) : new Config();
        this.currentConfigFile = configFile;
        this.setTitle("AQL-ConfigWizard");
        this.getIcons().add((Object)new Image("file:data/gui/images/editor_icon_16.png", 16.0, 16.0, false, true));
        this.getIcons().add((Object)new Image("file:data/gui/images/editor_icon_32.png", 32.0, 32.0, false, true));
        this.getIcons().add((Object)new Image("file:data/gui/images/editor_icon_64.png", 64.0, 64.0, false, true));
        this.overview = new Overview(this);
        this.editor = new EditorXML(this);
        BorderPane root = new BorderPane();
        TabPane tabPane = new TabPane();
        tabPane.setSide(Side.BOTTOM);
        Tab tabEditor = new Tab("Overview");
        tabEditor.setOnSelectionChanged((EventHandler)new EventHandler<Event>(){

            public void handle(Event event) {
                ConfigWizard.this.overviewActive = false;
                ConfigWizard.this.adjustTitle();
            }
        });
        tabEditor.setContent((Node)this.overview);
        tabEditor.setClosable(false);
        Tab tabViewer = new Tab("XML");
        tabViewer.setOnSelectionChanged((EventHandler)new EventHandler<Event>(){

            public void handle(Event event) {
                ConfigWizard.this.overviewActive = true;
                ConfigWizard.this.adjustTitle();
            }
        });
        tabViewer.setContent((Node)this.editor);
        tabViewer.setClosable(false);
        tabPane.getTabs().addAll((Object[])new Tab[]{tabEditor, tabViewer});
        root.setTop((Node)new Menubar(this));
        root.setCenter((Node)tabPane);
        Scene scene = new Scene((Parent)root, parent.getScene().getWidth() - 32.0, parent.getScene().getHeight() - 32.0);
        scene.getStylesheets().add((Object)"file:data/gui/style.css");
        scene.getStylesheets().add((Object)"file:data/gui/xml_highlighting.css");
        this.setScene(scene);
        this.show();
        this.openDialogFolder = new DirectoryChooser();
        this.openDialogFile = new FileChooser();
        this.saveDialog = new FileChooser();
        FileChooser.ExtensionFilter allFilter = new FileChooser.ExtensionFilter("*.* All files", new String[]{"*.*"});
        FileChooser.ExtensionFilter xmlFilter = new FileChooser.ExtensionFilter("*.xml Config File", new String[]{"*.xml"});
        this.openDialogFile.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{allFilter, xmlFilter});
        this.openDialogFile.setSelectedExtensionFilter(xmlFilter);
        this.saveDialog.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{allFilter, xmlFilter});
        this.saveDialog.setSelectedExtensionFilter(xmlFilter);
    }

    @Override
    public void newFile() {
        this.currentConfig = new Config();
        this.syncEditorXML();
        this.syncOverview();
    }

    @Override
    public void open() {
        this.open(false);
    }

    public void open(boolean folder) {
        if (folder) {
            if (this.lastDirectory != null) {
                this.openDialogFolder.setInitialDirectory(this.lastDirectory);
            }
        } else if (this.lastDirectory != null) {
            this.openDialogFile.setInitialDirectory(this.lastDirectory);
        }
        this.currentConfigFile = this.openDialogFile.showOpenDialog((Window)this);
        if (this.currentConfigFile != null) {
            this.currentConfig = ConfigHandler.parseXML(this.currentConfigFile);
            this.editor.setContent(ConfigHandler.toXML(this.currentConfig));
        }
        this.adjustTitle();
    }

    @Override
    public void saveAs() {
        if (this.currentConfigFile != null) {
            this.saveDialog.setInitialDirectory(this.currentConfigFile.getParentFile());
        } else if (this.lastDirectory != null) {
            this.saveDialog.setInitialDirectory(this.lastDirectory);
        }
        this.currentConfigFile = this.saveDialog.showSaveDialog((Window)this);
        if (this.currentConfigFile != null) {
            this.save();
        }
    }

    @Override
    public void save() {
        try {
            this.currentConfigFile.delete();
            Files.write(Paths.get(this.currentConfigFile.toURI()), this.editor.getContent().getBytes(), StandardOpenOption.CREATE_NEW);
        }
        catch (IOException e) {
            Log.msg("Could not write file: " + this.currentConfigFile.getAbsolutePath() + " (" + e.getMessage() + ")", 1);
        }
        this.adjustTitle();
    }

    @Override
    public void exit() {
        if (GUI.showConfigWizard) {
            System.exit(0);
        } else {
            this.hide();
        }
    }

    @Override
    public Stage getStage() {
        return this;
    }

    @Override
    public de.foellix.aql.system.System getSystem() {
        return null;
    }

    public void undo() {
        this.editor.undo();
    }

    public void redo() {
        this.editor.redo();
    }

    public void autoformat() {
        this.syncOverview();
        this.syncEditorXML();
    }

    public void addTool() {
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION);
        Stage alertStage = (Stage)alert.getDialogPane().getScene().getWindow();
        alertStage.getIcons().add((Object)new Image("file:data/gui/images/icon_16.png", 16.0, 16.0, false, true));
        alertStage.getIcons().add((Object)new Image("file:data/gui/images/icon_32.png", 32.0, 32.0, false, true));
        alertStage.getIcons().add((Object)new Image("file:data/gui/images/icon_64.png", 64.0, 64.0, false, true));
        alert.setTitle("New Tool");
        alert.setHeaderText("What type of tool you want to add?");
        alert.setContentText("Choose your option!");
        Object[] btnType = new ButtonType[]{new ButtonType("Analysis Tool"), new ButtonType("Preprocessor"), new ButtonType("Operator"), new ButtonType("Converter"), new ButtonType("Cancel", ButtonBar.ButtonData.CANCEL_CLOSE)};
        alert.getButtonTypes().setAll(btnType);
        Optional result = alert.showAndWait();
        Tool temp = new Tool();
        temp.setName("New Tool #" + ++this.newToolCounter);
        if (result.get() == btnType[0]) {
            if (this.currentConfig.getTools() == null) {
                this.currentConfig.setTools(new Tools());
            }
            this.currentConfig.getTools().getTool().add(temp);
        } else if (result.get() == btnType[1]) {
            if (this.currentConfig.getPreprocessors() == null) {
                this.currentConfig.setPreprocessors(new Preprocessors());
            }
            this.currentConfig.getPreprocessors().getTool().add(temp);
        } else if (result.get() == btnType[2]) {
            if (this.currentConfig.getOperators() == null) {
                this.currentConfig.setOperators(new Operators());
            }
            this.currentConfig.getOperators().getTool().add(temp);
        } else if (result.get() == btnType[3]) {
            if (this.currentConfig.getConverters() == null) {
                this.currentConfig.setConverters(new Converters());
            }
            this.currentConfig.getConverters().getTool().add(temp);
        } else {
            return;
        }
        this.syncEditorXML();
        this.syncOverview();
    }

    private void adjustTitle() {
        Platform.runLater(() -> {
            if (this.overviewActive) {
                if (this.currentConfig == null) {
                    this.setTitle("AQL-ConfigWizard");
                } else {
                    this.setTitle("AQL-ConfigWizard (" + this.currentConfigFile.getAbsolutePath() + ")");
                }
            } else if (this.currentConfig == null) {
                this.setTitle("AQL-ConfigWizard");
            } else {
                this.setTitle("AQL-ConfigWizard (" + this.currentConfigFile.getAbsolutePath() + ")");
            }
        });
    }

    public Config getConfig() {
        return this.currentConfig;
    }

    public void syncOverview() {
        this.currentConfig = ConfigHandler.parseXML(this.editor.getContent());
        this.overview.sync();
    }

    public void syncEditorXML() {
        this.editor.setContent(ConfigHandler.toXML(this.currentConfig));
    }

    public void continueWithCurrentConfig() {
        ConfigHandler.getInstance().setConfig(this.currentConfigFile);
        this.hide();
        if (!this.parent.isShowing()) {
            this.parent.show();
        }
    }
}

