/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.converter.didfail;

import de.foellix.aql.Log;
import de.foellix.aql.converter.IConverter;
import de.foellix.aql.datastructure.Answer;
import de.foellix.aql.datastructure.Flow;
import de.foellix.aql.datastructure.Flows;
import de.foellix.aql.datastructure.QuestionPart;
import de.foellix.aql.datastructure.Reference;
import de.foellix.aql.helper.EqualsHelper;
import de.foellix.aql.helper.Helper;
import de.foellix.aql.system.task.ToolTaskInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ConverterDidFail
implements IConverter {
    private File resultFolder;
    private QuestionPart question;

    @Override
    public Answer parse(File resultFolder, ToolTaskInfo taskInfo) {
        this.resultFolder = resultFolder;
        this.question = taskInfo.getQuestion();
        Answer answer = new Answer();
        answer.setFlows(new Flows());
        try {
            List<Reference> to = null;
            File resultFile = new File(resultFolder, "flows.out");
            FileReader fr = new FileReader(resultFile);
            BufferedReader br = new BufferedReader(fr);
            String line = "";
            while ((line = br.readLine()) != null) {
                String statement;
                if (line.contains("### 'Sink: ") && line.contains("': ###")) {
                    statement = Helper.cut(line, "### 'Sink: ", "': ###");
                    to = this.generateCompleteReference(statement);
                    if (to.size() <= 1) continue;
                    Log.warning("Could not identify unique to-reference: " + statement + " (Taking all into account)");
                    continue;
                }
                if (to == null) continue;
                if (!line.contains("'Src: ")) break;
                statement = Helper.cut(line, "'Src: ", "'");
                List<Reference> from = this.generateCompleteReference(statement);
                if (from.size() > 1) {
                    Log.warning("Could not identify unique from-reference: " + statement + " (Taking all into account)");
                }
                for (Reference fromRef : from) {
                    for (Reference toRef : to) {
                        Flow flow = new Flow();
                        fromRef.setType("from");
                        flow.getReference().add(fromRef);
                        toRef.setType("to");
                        flow.getReference().add(toRef);
                        boolean add = true;
                        for (Flow temp : answer.getFlows().getFlow()) {
                            if (!EqualsHelper.equals(temp, flow)) continue;
                            add = false;
                            break;
                        }
                        if (!add) continue;
                        answer.getFlows().getFlow().add(flow);
                    }
                }
            }
            br.close();
            fr.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            Log.error("Error while reading files in directory: " + resultFolder.getAbsolutePath());
            return null;
        }
        return answer;
    }

    private List<Reference> generateCompleteReference(String statement) throws IOException {
        ArrayList<Reference> returnList = new ArrayList<Reference>();
        File logFolder = new File(this.resultFolder, "log");
        for (File file : logFolder.listFiles()) {
            if (!file.getName().endsWith("flowdroid.log")) continue;
            FileReader fr = new FileReader(file);
            BufferedReader br = new BufferedReader(fr);
            String line = "";
            while ((line = br.readLine()) != null) {
                if (!line.contains(statement) || !line.contains(" in method ")) continue;
                String method = Helper.cut(line, " in method ", ")>") + ")>";
                String classname = Helper.cut(method, "<", ": ");
                Reference reference = new Reference();
                for (Reference appCandidate : this.question.getAllReferences()) {
                    if (!appCandidate.getApp().getFile().toLowerCase().contains(file.getName().substring(0, file.getName().indexOf("flowdroid.log") - 1).toLowerCase())) continue;
                    reference.setApp(appCandidate.getApp());
                }
                if (reference.getApp() == null) {
                    br.close();
                    fr.close();
                    throw new FileNotFoundException("Could not find file that matches an app with the name: " + file.getName().substring(0, file.getName().indexOf("flowdroid.log") - 1));
                }
                reference.setClassname(classname);
                reference.setMethod(method);
                reference.setStatement(Helper.createStatement(statement));
                returnList.add(reference);
            }
            br.close();
            fr.close();
        }
        return returnList;
    }
}

