/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.converter.droidsafe;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.foellix.aql.Log;
import de.foellix.aql.converter.IConverter;
import de.foellix.aql.converter.droidsafe.Content;
import de.foellix.aql.converter.droidsafe.JSONReader;
import de.foellix.aql.datastructure.Answer;
import de.foellix.aql.datastructure.Flow;
import de.foellix.aql.datastructure.Flows;
import de.foellix.aql.datastructure.Reference;
import de.foellix.aql.helper.Helper;
import de.foellix.aql.system.task.ToolTaskInfo;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

public class ConverterDroidSafe
implements IConverter {
    private JSONReader json;

    @Override
    public Answer parse(File resultFolder, ToolTaskInfo taskInfo) {
        Answer answer = new Answer();
        Flows flows = new Flows();
        resultFolder = new File(resultFolder, "droidsafe-gen");
        File jsonFile = new File(resultFolder, "user_call_graph.json");
        File resultFile = new File(resultFolder, "info-flow-results.txt");
        try {
            ObjectMapper mapper = new ObjectMapper();
            this.json = mapper.readValue(jsonFile, JSONReader.class);
        }
        catch (IOException e) {
            Log.error("Error reading DroidSafe's .json result file: " + jsonFile);
            return null;
        }
        try {
            FileReader fr = new FileReader(resultFile);
            BufferedReader br = new BufferedReader(fr);
            Reference to = null;
            Reference from = null;
            boolean sources = false;
            String line = "";
            while ((line = br.readLine()) != null) {
                String method;
                if (line.startsWith("Sink: ")) {
                    to = new Reference();
                    to.setStatement(Helper.createStatement(Helper.cutFromFirstToLast(line, "<", ">")));
                    method = this.findMethodRecursively(to.getStatement().getStatementgeneric());
                    if (method != null) {
                        to.setMethod(method);
                        to.setClassname(Helper.cut(to.getMethod(), "<", ":"));
                        to.setApp(taskInfo.getQuestion().getAllReferences().get(0).getApp());
                        to.setType("to");
                        continue;
                    }
                    Log.error("Could not find method for the following statement: " + to.getStatement().getStatementgeneric());
                    to = null;
                    continue;
                }
                if (line.contains("Sources:") && to != null) {
                    sources = true;
                    continue;
                }
                if (line.equals("")) {
                    to = null;
                    sources = false;
                    continue;
                }
                if (!sources) continue;
                from = new Reference();
                from.setStatement(Helper.createStatement(Helper.cut(line, "\t", " (UNIQUE_IDENTIFIER)")));
                method = this.findMethodRecursively(from.getStatement().getStatementgeneric());
                if (method == null) continue;
                from.setMethod(method);
                from.setClassname(Helper.cut(from.getMethod(), "<", ":"));
                from.setApp(taskInfo.getQuestion().getAllReferences().get(0).getApp());
                from.setType("from");
                Flow flow = new Flow();
                flow.getReference().add(from);
                flow.getReference().add(to);
                flows.getFlow().add(flow);
            }
            fr.close();
            br.close();
        }
        catch (IOException e) {
            Log.error("Error reading DroidSafe's result file: " + resultFolder);
            return null;
        }
        if (!flows.getFlow().isEmpty()) {
            answer.setFlows(flows);
        }
        return answer;
    }

    private String findMethodRecursively(String statement) {
        for (Content c : this.json.getContents()) {
            Content temp;
            if (c.getContents() == null || c.getContents().isEmpty() || (temp = this.findMethodRecursively(statement, c)) == null) continue;
            return temp.getSignature();
        }
        return null;
    }

    private Content findMethodRecursively(String statement, Content parent) {
        for (Content c : parent.getContents()) {
            Content temp;
            if (c.getSignature().substring(1, c.getSignature().length() - 1).equals(statement)) {
                return parent;
            }
            if (c.getContents() == null || c.getContents().isEmpty() || (temp = this.findMethodRecursively(statement, c)) == null) continue;
            return temp;
        }
        return null;
    }
}

