/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.converter.horndroid;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.foellix.aql.Log;
import de.foellix.aql.converter.IConverter;
import de.foellix.aql.converter.horndroid.JSONReader;
import de.foellix.aql.converter.horndroid.ReportEntry;
import de.foellix.aql.datastructure.Answer;
import de.foellix.aql.datastructure.Flow;
import de.foellix.aql.datastructure.Flows;
import de.foellix.aql.datastructure.Permission;
import de.foellix.aql.datastructure.Permissions;
import de.foellix.aql.datastructure.Reference;
import de.foellix.aql.helper.Helper;
import de.foellix.aql.system.task.ToolTaskInfo;
import java.io.File;
import java.io.IOException;

public class ConverterHD
implements IConverter {
    @Override
    public Answer parse(File resultFile, ToolTaskInfo taskInfo) {
        JSONReader json;
        Answer answer = new Answer();
        answer.setFlows(new Flows());
        answer.setPermissions(new Permissions());
        Permission p = new Permission();
        p.setName("HORNDROID_SUCCESSFULLY_EXECUTED");
        answer.getPermissions().getPermission().add(p);
        try {
            ObjectMapper mapper = new ObjectMapper();
            json = mapper.readValue(resultFile, JSONReader.class);
        }
        catch (IOException e) {
            Log.error("Error reading HornDroid's .json result file: " + resultFile);
            return null;
        }
        for (ReportEntry re : json.getReportEntries()) {
            if (re.getResult().equals("NO LEAK")) continue;
            Reference sink = new Reference();
            sink.setType("to");
            sink.setApp(taskInfo.getQuestion().getAllReferences().iterator().next().getApp());
            sink.setClassname(Helper.cut(re.getDescription(), " of the class L", "; to the sink ").replaceAll("/", "."));
            sink.setMethod(Helper.cut(re.getDescription(), " in method ", "V of the class ").replaceAll("/", ".").replaceAll("\\(L", "(").replaceAll(";\\)", ")").replaceAll(";", ","));
            String statement = Helper.cut(re.getDescription(), "; to the sink ", ")V") + ")";
            statement = "<unknown.pkg.and.Class: unknown.return.Type " + statement.replaceAll("\\(L", "(").replaceAll(";L", ",").replaceAll(";", "").replaceAll("/", ".") + ">";
            sink.setStatement(Helper.createStatement(statement, false));
            Flow flow = new Flow();
            flow.getReference().add(sink);
            answer.getFlows().getFlow().add(flow);
        }
        return answer;
    }
}

