/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.datastructure;

import de.foellix.aql.datastructure.App;
import de.foellix.aql.datastructure.IQuestionNode;
import de.foellix.aql.datastructure.PreviousQuestion;
import de.foellix.aql.datastructure.QuestionPart;
import de.foellix.aql.datastructure.Reference;
import de.foellix.aql.helper.EqualsHelper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class Question
implements IQuestionNode,
Serializable {
    private static final long serialVersionUID = 4453131349077342896L;
    private String operator;
    private final List<IQuestionNode> children;

    public Question(String operator) {
        this.operator = operator;
        this.children = new ArrayList<IQuestionNode>();
    }

    public String getOperator() {
        return this.operator;
    }

    public void setOperator(String operator) {
        this.operator = operator;
    }

    public void addChild(IQuestionNode child) {
        this.children.add(child);
    }

    @Override
    public List<IQuestionNode> getChildren() {
        return this.children;
    }

    @Override
    public List<QuestionPart> getAllQuestionParts() {
        ArrayList<QuestionPart> list = new ArrayList<QuestionPart>();
        for (IQuestionNode node : this.children) {
            if (node instanceof QuestionPart) {
                list.add((QuestionPart)node);
                continue;
            }
            if (!(node instanceof Question)) continue;
            list.addAll(((Question)node).getAllQuestionParts());
        }
        return list;
    }

    @Override
    public List<PreviousQuestion> getAllPreviousQuestions() {
        ArrayList<PreviousQuestion> list = new ArrayList<PreviousQuestion>();
        for (IQuestionNode node : this.children) {
            if (node instanceof PreviousQuestion) {
                list.add((PreviousQuestion)node);
                continue;
            }
            if (!(node instanceof Question)) continue;
            list.addAll(((Question)node).getAllPreviousQuestions());
        }
        return list;
    }

    @Override
    public List<Reference> getAllReferences() {
        ArrayList<Reference> references = new ArrayList<Reference>();
        for (IQuestionNode child : this.children) {
            for (Reference reference : child.getAllReferences()) {
                boolean add = true;
                for (Reference check : references) {
                    if (!EqualsHelper.equals(reference, check)) continue;
                    add = false;
                    break;
                }
                if (!add) continue;
                references.add(reference);
            }
        }
        return references;
    }

    @Override
    public List<App> getAllApps(boolean equalsOnObjectLevel) {
        ArrayList<App> apps = new ArrayList<App>();
        for (IQuestionNode child : this.children) {
            for (App app : child.getAllApps(equalsOnObjectLevel)) {
                boolean add = true;
                for (App check : apps) {
                    if ((!equalsOnObjectLevel || !app.equals(check)) && (equalsOnObjectLevel || !EqualsHelper.equals(app, check))) continue;
                    add = false;
                    break;
                }
                if (!add) continue;
                apps.add(app);
            }
        }
        return apps;
    }

    public String toString() {
        return this.toString(0);
    }

    @Override
    public String toString(int level) {
        String indent = "";
        for (int i = 0; i < level; ++i) {
            indent = indent + "\t";
        }
        StringBuilder sb = new StringBuilder();
        if (!this.operator.equals("COLLECTION")) {
            sb.append(indent + this.operator + " [\n");
        } else {
            --level;
        }
        boolean first = true;
        for (IQuestionNode child : this.children) {
            if (first) {
                first = false;
                sb.append(child.toString(level + 1));
                continue;
            }
            if (this.operator.equals("COLLECTION")) {
                sb.append("\n" + child.toString(level + 1));
                continue;
            }
            sb.append(",\n" + child.toString(level + 1));
        }
        if (!this.operator.equals("COLLECTION")) {
            sb.append("\n" + indent + "]");
        }
        return sb.toString();
    }

    @Override
    public String toRAW(boolean external) {
        StringBuilder sb = new StringBuilder();
        for (IQuestionNode child : this.getChildren()) {
            sb.append(child.toRAW(external));
        }
        return sb.toString();
    }
}

