/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.datastructure;

import de.foellix.aql.datastructure.Question;
import de.foellix.aql.helper.Helper;

public class QuestionFilter
extends Question {
    private static final long serialVersionUID = -2855045660219419728L;
    String name = null;
    String value = null;
    int soi = -1;

    public QuestionFilter(String operator) {
        super(operator);
    }

    @Override
    public String toString(int level) {
        String indent = "";
        for (int i = 0; i < level; ++i) {
            indent = indent + "\t";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(indent + this.getOperator() + " [\n");
        sb.append(this.getChildren().get(0).toString(level + 1));
        if (this.name != null && !this.name.replaceAll(" ", "").equals("")) {
            sb.append("\n" + indent + "\t| " + this.name + " = ");
            if (this.value != null && !this.value.replaceAll(" ", "").equals("")) {
                sb.append(this.value);
            }
        }
        if (this.soi != -1) {
            sb.append("\n" + indent + "\t| " + Helper.typeToSoi(this.soi));
        }
        sb.append("\n" + indent + "]");
        return sb.toString();
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public int getSoi() {
        return this.soi;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setSoi(int soi) {
        this.soi = soi;
    }
}

