/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.datastructure;

import de.foellix.aql.datastructure.App;
import de.foellix.aql.datastructure.IQuestionNode;
import de.foellix.aql.datastructure.PreviousQuestion;
import de.foellix.aql.datastructure.Reference;
import de.foellix.aql.helper.EqualsHelper;
import de.foellix.aql.helper.Helper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class QuestionPart
implements IQuestionNode,
Serializable {
    private static final long serialVersionUID = -3835466478917897792L;
    private int mode = 0;
    private List<Reference> references = new ArrayList<Reference>();
    private final Map<Reference, List<String>> preprocessorMap = new HashMap<Reference, List<String>>();
    private final List<String> features = new ArrayList<String>();
    private final List<String> uses = new ArrayList<String>();

    public String toString() {
        return this.toString(0);
    }

    @Override
    public String toString(int level) {
        int o;
        String indent = "";
        for (int i = 0; i < level; ++i) {
            indent = indent + "\t";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(indent + Helper.typeToSoi(this.mode));
        if (this.references.size() == 2) {
            sb.append(" FROM ");
        } else {
            sb.append(" IN ");
        }
        for (int i = 0; i < this.references.size(); ++i) {
            if (i == 0) {
                sb.append(Helper.toString(this.references.get(i)));
            } else {
                sb.append(" TO " + Helper.toString(this.references.get(i)));
            }
            if (this.preprocessorMap.get(this.references.get(i)) == null) continue;
            sb.setLength(sb.length() - 1);
            for (String keyword : this.preprocessorMap.get(this.references.get(i))) {
                sb.append(" | " + keyword);
            }
            sb.append(")");
        }
        if (this.features != null && !this.features.isEmpty()) {
            sb.append(" FEATURING ");
            for (o = 0; o < this.features.size(); ++o) {
                sb.append("'" + this.features.get(o) + "'");
                if (o == this.features.size() - 1) continue;
                sb.append(", ");
            }
        }
        if (this.uses != null && !this.uses.isEmpty()) {
            sb.append(" USES ");
            for (o = 0; o < this.uses.size(); ++o) {
                sb.append("'" + this.uses.get(o) + "'");
                if (o == this.uses.size() - 1) continue;
                sb.append(", ");
            }
        }
        sb.append(" ?");
        return sb.toString();
    }

    @Override
    public String toRAW(boolean external) {
        StringBuilder sb = new StringBuilder();
        if (external) {
            sb.append(String.valueOf(this.mode));
        }
        for (Reference reference : this.references) {
            sb.append(Helper.toRAW(reference));
        }
        if (this.features != null) {
            ArrayList<String> sortedFeatures = new ArrayList<String>(this.features);
            sortedFeatures.sort(String::compareToIgnoreCase);
            for (String feature : sortedFeatures) {
                sb.append(feature);
            }
        }
        if (this.uses != null) {
            ArrayList<String> sortedUses = new ArrayList<String>(this.uses);
            sortedUses.sort(String::compareToIgnoreCase);
            for (String use : sortedUses) {
                sb.append(use);
            }
        }
        return sb.toString();
    }

    @Override
    public List<IQuestionNode> getChildren() {
        return null;
    }

    @Override
    public List<QuestionPart> getAllQuestionParts() {
        ArrayList<QuestionPart> temp = new ArrayList<QuestionPart>();
        temp.add(this);
        return temp;
    }

    @Override
    public List<PreviousQuestion> getAllPreviousQuestions() {
        return null;
    }

    @Override
    public List<Reference> getAllReferences() {
        return this.references;
    }

    @Override
    public List<App> getAllApps(boolean equalsOnObjectLevel) {
        ArrayList<App> apps = new ArrayList<App>();
        for (Reference reference : this.references) {
            boolean add = true;
            for (App check : apps) {
                if ((!equalsOnObjectLevel || !reference.getApp().equals(check)) && (equalsOnObjectLevel || !EqualsHelper.equals(reference.getApp(), check))) continue;
                add = false;
                break;
            }
            if (!add) continue;
            apps.add(reference.getApp());
        }
        return apps;
    }

    public void addReference(Reference reference) {
        this.references.add(reference);
    }

    public void addPreprocessor(Reference reference, List<String> preprocessors) {
        this.preprocessorMap.put(reference, preprocessors);
    }

    public void removePreprocessor(Reference reference, String preprocessorKeyword) {
        if (this.preprocessorMap.get(reference).size() == 1 || preprocessorKeyword == null) {
            this.preprocessorMap.remove(reference);
        } else {
            preprocessorKeyword = preprocessorKeyword.replaceAll("'", "");
            String remove = null;
            for (String keyword : this.preprocessorMap.get(reference)) {
                if (!keyword.replaceAll("'", "").equals(preprocessorKeyword)) continue;
                remove = keyword;
                break;
            }
            if (remove != null) {
                this.preprocessorMap.get(reference).remove(remove);
            }
        }
    }

    public List<String> getPreprocessor(Reference reference) {
        return this.preprocessorMap.get(reference);
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public void setReferences(List<Reference> references) {
        this.references = references;
    }

    public List<String> getFeatures() {
        return this.features;
    }

    public List<String> getUses() {
        return this.uses;
    }
}

