/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.datastructure.handler;

import de.foellix.aql.Log;
import de.foellix.aql.datastructure.Answer;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public class AnswerHandler {
    public static String createXMLString(Object answer) {
        if (answer instanceof Answer) {
            return AnswerHandler.createXMLString((Answer)answer);
        }
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{answer.getClass()});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
            jaxbMarshaller.setProperty("jaxb.encoding", (Object)"utf-8");
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            jaxbMarshaller.marshal(answer, (OutputStream)outputStream);
            String returnStr = ((Object)outputStream).toString();
            ((OutputStream)outputStream).close();
            return returnStr;
        }
        catch (IOException | JAXBException e) {
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String createXMLString(Answer answer) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Answer.class});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
            jaxbMarshaller.setProperty("jaxb.encoding", (Object)"utf-8");
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            jaxbMarshaller.marshal((Object)answer, (OutputStream)outputStream);
            String returnStr = ((Object)outputStream).toString();
            ((OutputStream)outputStream).close();
            return returnStr;
        }
        catch (IOException | JAXBException e) {
            Log.error("Something went wrong while creating the XML string.");
            return null;
        }
    }

    public static void createXML(Answer answer, File xmlFile) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Answer.class});
            Marshaller jaxbMarshaller = jaxbContext.createMarshaller();
            jaxbMarshaller.setProperty("jaxb.formatted.output", (Object)true);
            jaxbMarshaller.setProperty("jaxb.encoding", (Object)"utf-8");
            FileOutputStream outputStream = new FileOutputStream(xmlFile);
            jaxbMarshaller.marshal((Object)answer, (OutputStream)outputStream);
            ((OutputStream)outputStream).close();
        }
        catch (IOException | JAXBException e) {
            Log.error("Something went wrong while writing the following file: " + xmlFile.getAbsolutePath());
            return;
        }
    }

    public static Answer parseXML(File xmlFile) {
        try {
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Answer.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            Answer answer = (Answer)jaxbUnmarshaller.unmarshal(xmlFile);
            return answer;
        }
        catch (JAXBException e) {
            Log.error("Something went wrong while reading the following file: " + xmlFile.getAbsolutePath());
            return null;
        }
    }

    public static Answer parseXML(String xmlString) {
        try {
            StringReader reader = new StringReader(xmlString);
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{Answer.class});
            Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
            Answer answer = (Answer)jaxbUnmarshaller.unmarshal((Reader)reader);
            reader.close();
            return answer;
        }
        catch (JAXBException e) {
            if (xmlString.length() < 1000) {
                Log.error("There has to be an error in your AQL-Answer: " + e.getMessage() + "\n" + xmlString);
            } else {
                Log.error("There has to be an error in your AQL-Answer: " + e.getMessage() + "\n" + xmlString.substring(0, 1000));
            }
            return null;
        }
    }
}

