/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.datastructure.handler;

import de.foellix.aql.Log;
import de.foellix.aql.datastructure.App;
import de.foellix.aql.datastructure.IQuestionNode;
import de.foellix.aql.datastructure.handler.ParseException;
import de.foellix.aql.datastructure.handler.QuestionHandler;
import de.foellix.aql.datastructure.handler.QuestionParser;
import java.io.ByteArrayInputStream;
import java.io.File;

public class QueryHandler {
    public static IQuestionNode parseQuery(String query) {
        try {
            ByteArrayInputStream input = new ByteArrayInputStream(query.getBytes());
            QuestionParser parser = new QuestionParser(input);
            parser.query();
            QuestionHandler questionHandler = parser.getQuestionHandler();
            IQuestionNode currentQuery = questionHandler.getCollection();
            if (currentQuery.getChildren() != null && currentQuery.getChildren().size() == 1) {
                currentQuery = currentQuery.getChildren().get(0);
            }
            return currentQuery;
        }
        catch (ParseException e) {
            Log.error("The query is not valid.");
            e.printStackTrace();
            return null;
        }
    }

    public static IQuestionNode replaceWithAbsolutePaths(IQuestionNode query) {
        try {
            for (App app : query.getAllApps(true)) {
                File file = new File(app.getFile());
                app.setFile(file.getAbsolutePath().replaceAll("\\\\", "/"));
            }
        }
        catch (Exception e) {
            Log.error("Could not convert to absolute paths. Maybe one or more files do not exists.");
        }
        return query;
    }
}

