/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.helper;

import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinNT;
import de.foellix.aql.Log;
import de.foellix.aql.config.Config;
import de.foellix.aql.config.ConfigHandler;
import de.foellix.aql.config.Priority;
import de.foellix.aql.config.Tool;
import de.foellix.aql.datastructure.Answer;
import de.foellix.aql.datastructure.App;
import de.foellix.aql.datastructure.Attribute;
import de.foellix.aql.datastructure.Data;
import de.foellix.aql.datastructure.Flow;
import de.foellix.aql.datastructure.Flows;
import de.foellix.aql.datastructure.Hash;
import de.foellix.aql.datastructure.Hashes;
import de.foellix.aql.datastructure.IQuestionNode;
import de.foellix.aql.datastructure.Intent;
import de.foellix.aql.datastructure.Intentfilter;
import de.foellix.aql.datastructure.Intentfilters;
import de.foellix.aql.datastructure.Intents;
import de.foellix.aql.datastructure.Intentsink;
import de.foellix.aql.datastructure.Intentsinks;
import de.foellix.aql.datastructure.Intentsource;
import de.foellix.aql.datastructure.Intentsources;
import de.foellix.aql.datastructure.KeywordsAndConstants;
import de.foellix.aql.datastructure.Parameter;
import de.foellix.aql.datastructure.Parameters;
import de.foellix.aql.datastructure.Permission;
import de.foellix.aql.datastructure.Permissions;
import de.foellix.aql.datastructure.PreviousQuestion;
import de.foellix.aql.datastructure.Question;
import de.foellix.aql.datastructure.QuestionFilter;
import de.foellix.aql.datastructure.QuestionPart;
import de.foellix.aql.datastructure.Reference;
import de.foellix.aql.datastructure.Statement;
import de.foellix.aql.datastructure.Target;
import de.foellix.aql.helper.EqualsHelper;
import de.foellix.aql.helper.EqualsOptions;
import de.foellix.aql.helper.HashHelper;
import de.foellix.aql.helper.ManifestHelper;
import de.foellix.aql.helper.ManifestInfo;
import de.foellix.aql.system.DefaultOperator;
import de.foellix.aql.system.task.OperatorTaskInfo;
import de.foellix.aql.system.task.PreprocessorTaskInfo;
import de.foellix.aql.system.task.TaskInfo;
import de.foellix.aql.system.task.ToolTaskInfo;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Helper {
    public static final int OCCURENCE_LAST = -1;

    public static String cut(String input, String from, String to) {
        return Helper.cut(input, from, to, 1);
    }

    public static String cutFromFirstToLast(String input, String fromFirst, String toLast) {
        try {
            return input.substring(input.indexOf(fromFirst) + fromFirst.length(), input.lastIndexOf(toLast));
        }
        catch (StringIndexOutOfBoundsException e) {
            Log.msg("Non valid input: " + input, 6);
            return input;
        }
    }

    public static String cut(String input, String from) {
        return Helper.cut(input, from, 1);
    }

    public static String cut(String input, String from, String to, int occurence) {
        try {
            int pos1 = 0;
            int pos2 = 0;
            if (occurence == -1) {
                occurence = (input.length() - input.replace(from, "").length()) / from.length();
            }
            for (int i = 0; i < occurence; ++i) {
                if (from != null) {
                    pos1 = input.indexOf(from, pos1) + from.length();
                    pos2 = input.indexOf(to, pos1);
                    continue;
                }
                pos2 = input.indexOf(to, pos2);
            }
            return input.substring(pos1, pos2);
        }
        catch (StringIndexOutOfBoundsException e) {
            Log.msg("Non valid input: " + input, 6);
            return input;
        }
    }

    public static String cut(String input, String from, int occurence) {
        try {
            int pos1 = 0;
            if (occurence == -1) {
                occurence = (input.length() - input.replace(from, "").length()) / from.length();
            }
            for (int i = 0; i < occurence; ++i) {
                pos1 = input.indexOf(from, pos1) + from.length();
            }
            return input.substring(pos1);
        }
        catch (StringIndexOutOfBoundsException e) {
            Log.msg("Non valid input: " + input, 6);
            return input;
        }
    }

    public static String cutFromStart(String input, String to) {
        return Helper.cutFromStart(input, to, 1);
    }

    public static String cutFromStart(String input, String to, int occurence) {
        return Helper.cut(input, null, to, occurence);
    }

    public static int soiToType(String soi) {
        switch (soi) {
            case "Flows": {
                return 0;
            }
            case "IntentFilters": {
                return 3;
            }
            case "Intents": {
                return 2;
            }
            case "IntentSinks": {
                return 5;
            }
            case "IntentSources": {
                return 4;
            }
            case "Permissions": {
                return 1;
            }
        }
        return -1;
    }

    public static String typeToSoi(int type) {
        switch (type) {
            case 0: {
                return "Flows";
            }
            case 3: {
                return "IntentFilters";
            }
            case 2: {
                return "Intents";
            }
            case 5: {
                return "IntentSinks";
            }
            case 4: {
                return "IntentSources";
            }
            case 1: {
                return "Permissions";
            }
        }
        return "Unknown";
    }

    public static Answer copy(Answer answer) {
        Answer returnAnswer = new Answer();
        if (answer.getFlows() != null) {
            returnAnswer.setFlows(new Flows());
            if (!answer.getFlows().getFlow().isEmpty()) {
                returnAnswer.getFlows().getFlow().addAll(answer.getFlows().getFlow());
            }
        }
        if (answer.getIntentfilters() != null) {
            returnAnswer.setIntentfilters(new Intentfilters());
            if (!answer.getIntentfilters().getIntentfilter().isEmpty()) {
                returnAnswer.getIntentfilters().getIntentfilter().addAll(answer.getIntentfilters().getIntentfilter());
            }
        }
        if (answer.getIntents() != null) {
            returnAnswer.setIntents(new Intents());
            if (!answer.getIntents().getIntent().isEmpty()) {
                returnAnswer.getIntents().getIntent().addAll(answer.getIntents().getIntent());
            }
        }
        if (answer.getIntentsinks() != null) {
            returnAnswer.setIntentsinks(new Intentsinks());
            if (!answer.getIntentsinks().getIntentsink().isEmpty()) {
                returnAnswer.getIntentsinks().getIntentsink().addAll(answer.getIntentsinks().getIntentsink());
            }
        }
        if (answer.getIntentsources() != null) {
            returnAnswer.setIntentsources(new Intentsources());
            if (!answer.getIntentsources().getIntentsource().isEmpty()) {
                returnAnswer.getIntentsources().getIntentsource().addAll(answer.getIntentsources().getIntentsource());
            }
        }
        if (answer.getPermissions() != null) {
            returnAnswer.setPermissions(new Permissions());
            if (!answer.getPermissions().getPermission().isEmpty()) {
                returnAnswer.getPermissions().getPermission().addAll(answer.getPermissions().getPermission());
            }
        }
        return returnAnswer;
    }

    public static IQuestionNode copy(IQuestionNode question) {
        if (question instanceof Question || question instanceof QuestionFilter) {
            return Helper.copy((Question)question);
        }
        if (question instanceof PreviousQuestion) {
            return Helper.copy((PreviousQuestion)question);
        }
        return Helper.copy((QuestionPart)question);
    }

    public static Question copy(Question question) {
        Question newQuestion;
        if (question instanceof QuestionFilter) {
            newQuestion = new QuestionFilter(question.getOperator());
            ((QuestionFilter)newQuestion).setName(((QuestionFilter)question).getName());
            ((QuestionFilter)newQuestion).setValue(((QuestionFilter)question).getValue());
            ((QuestionFilter)newQuestion).setSoi(((QuestionFilter)question).getSoi());
        } else {
            newQuestion = new Question(question.getOperator());
        }
        for (IQuestionNode child : question.getChildren()) {
            newQuestion.getChildren().add(Helper.copy(child));
        }
        return newQuestion;
    }

    public static QuestionPart copy(QuestionPart questionPart) {
        QuestionPart newQuestionPart = new QuestionPart();
        newQuestionPart.setMode(questionPart.getMode());
        for (Reference ref : questionPart.getAllReferences()) {
            newQuestionPart.addReference(Helper.copy(ref));
        }
        return newQuestionPart;
    }

    public static PreviousQuestion copy(PreviousQuestion previousQuestion) {
        return new PreviousQuestion(previousQuestion.getFile());
    }

    public static Reference copy(Reference reference) {
        if (reference == null) {
            return null;
        }
        Reference newReference = new Reference();
        if (reference.getApp() != null) {
            newReference.setApp(reference.getApp());
        }
        if (reference.getClassname() != null) {
            newReference.setClassname(reference.getClassname());
        }
        if (reference.getMethod() != null) {
            newReference.setMethod(reference.getMethod());
        }
        if (reference.getStatement() != null) {
            newReference.setStatement(reference.getStatement());
        }
        return newReference;
    }

    public static Statement createStatement(String jimpleString) {
        return Helper.createStatement(jimpleString, true);
    }

    public static Statement createStatement(String jimpleString, boolean assignValues) {
        Statement newstatement = new Statement();
        newstatement.setStatementfull(jimpleString);
        newstatement.setStatementgeneric(Helper.cutFromFirstToLast(jimpleString, "<", ">"));
        String classes = Helper.cut(jimpleString, "(", ")", 1);
        if (!classes.equals("")) {
            String values = Helper.cut(jimpleString, "(", ")", 2);
            newstatement.setParameters(new Parameters());
            String[] parameterClasses = classes.split(",");
            String[] parameterValues = values.split(", ");
            for (int i = 0; !(i >= parameterClasses.length || i >= parameterValues.length && assignValues); ++i) {
                Parameter parameter = new Parameter();
                parameter.setType(parameterClasses[i]);
                if (assignValues) {
                    parameter.setValue(parameterValues[i]);
                }
                newstatement.getParameters().getParameter().add(parameter);
            }
        }
        return newstatement;
    }

    public static String toString(Object item) {
        if (item instanceof Answer) {
            return Helper.toString((Answer)item);
        }
        if (item instanceof Reference) {
            return Helper.toString((Reference)item);
        }
        if (item instanceof Permissions) {
            return Helper.toString((Permissions)item);
        }
        if (item instanceof Permission) {
            return Helper.toString((Permission)item);
        }
        if (item instanceof Flows) {
            return Helper.toString((Flows)item);
        }
        if (item instanceof Flow) {
            return Helper.toString((Flow)item);
        }
        if (item instanceof Intentsources) {
            return Helper.toString((Intentsources)item);
        }
        if (item instanceof Intentsource) {
            return Helper.toString((Intentsource)item);
        }
        if (item instanceof Intentsinks) {
            return Helper.toString((Intentsinks)item);
        }
        if (item instanceof Intentsink) {
            return Helper.toString((Intentsink)item);
        }
        if (item instanceof Target) {
            return Helper.toString((Target)item);
        }
        if (item instanceof Data) {
            return Helper.toString((Data)item);
        }
        if (item instanceof Tool) {
            return Helper.toString((Tool)item);
        }
        return item.toString();
    }

    public static String toString(Answer answer) {
        StringBuilder sb = new StringBuilder();
        if (answer.getPermissions() != null) {
            sb.append("*** Permissions ***\n" + Helper.toString(answer.getPermissions()) + "\n");
        }
        if (answer.getFlows() != null) {
            sb.append("*** Flows ***\n" + Helper.toString(answer.getFlows()) + "\n");
        }
        if (answer.getIntentsources() != null) {
            sb.append("*** IntentSources ***\n" + Helper.toString(answer.getIntentsources()) + "\n");
        }
        if (answer.getIntentsinks() != null) {
            sb.append("*** IntentSinks ***\n" + Helper.toString(answer.getIntentsinks()) + "\n");
        }
        return sb.toString();
    }

    public static String toString(Reference reference) {
        return Helper.toString(reference, "->");
    }

    public static String toString(Reference reference, String separator) {
        StringBuilder sb = new StringBuilder();
        if (reference != null) {
            if (reference.getStatement() != null && reference.getStatement().getStatementfull() != null) {
                sb.append("Statement('" + reference.getStatement().getStatementfull() + "')" + separator);
            }
            if (reference.getMethod() != null) {
                sb.append("Method('" + reference.getMethod() + "')" + separator);
            }
            if (reference.getClassname() != null) {
                sb.append("Class('" + reference.getClassname() + "')" + separator);
            }
            if (reference.getApp() != null && reference.getApp().getFile() != null) {
                sb.append("App('" + reference.getApp().getFile() + "')");
            } else {
                sb.append("No .apk defined (Not App specific)");
            }
        } else {
            sb.append("No Reference");
        }
        return sb.toString();
    }

    public static String toRAW(Reference reference) {
        return Helper.toRAW(reference, false);
    }

    public static String toRAW(Reference reference, boolean genericStatementOnly) {
        StringBuilder sb = new StringBuilder();
        if (reference.getStatement() != null) {
            if (!genericStatementOnly) {
                sb.append(reference.getStatement().getStatementfull());
            } else {
                sb.append(reference.getStatement().getStatementgeneric());
            }
        }
        if (reference.getMethod() != null) {
            sb.append(reference.getMethod());
        }
        if (reference.getClassname() != null) {
            sb.append(reference.getClassname());
        }
        if (reference.getApp() != null) {
            sb.append(Helper.toRAW(reference.getApp()));
        }
        return sb.toString();
    }

    public static String toRAW(Object item) {
        if (item instanceof Permission) {
            return Helper.toRAW((Permission)item);
        }
        if (item instanceof Intentsink) {
            return Helper.toRAW((Intentsink)item);
        }
        if (item instanceof Intentsource) {
            return Helper.toRAW((Intentsource)item);
        }
        if (item instanceof Reference) {
            return Helper.toRAW((Reference)item);
        }
        return null;
    }

    public static String toRAW(App app) {
        StringBuilder sb = new StringBuilder();
        if (app.getHashes() != null && !app.getHashes().getHash().isEmpty()) {
            for (Hash hash : app.getHashes().getHash()) {
                sb.append(hash.getType() + ": " + hash.getValue());
            }
        }
        return sb.toString();
    }

    public static String toRAW(Tool tool) {
        return tool.getName() + "-" + tool.getVersion();
    }

    public static String toRAW(Permission permission) {
        String temp = "Permission:" + permission.getName() + Helper.toRAW(permission.getReference());
        return temp.replaceAll("\\\n", "").replaceAll("\\\t", "");
    }

    public static String toRAW(Intentsink intentsink) {
        StringBuilder sb = new StringBuilder("Intentsink:");
        if (intentsink.getTarget() != null) {
            sb.append(Helper.toString(intentsink.getTarget(), true));
        }
        if (intentsink.getReference() != null) {
            sb.append(Helper.toRAW(intentsink.getReference()));
        }
        if (sb.length() <= 0) {
            sb.append(intentsink.hashCode());
        }
        return sb.toString().replaceAll("\\\n", "").replaceAll("\\\t", "");
    }

    public static String toRAW(Intentsource intentsource) {
        StringBuilder sb = new StringBuilder("Intentsource:");
        if (intentsource.getTarget() != null) {
            sb.append(Helper.toString(intentsource.getTarget(), true));
        }
        if (intentsource.getReference() != null) {
            sb.append(Helper.toRAW(intentsource.getReference()));
        }
        if (sb.length() <= 0) {
            sb.append(intentsource.hashCode());
        }
        return sb.toString().replaceAll("\\\n", "").replaceAll("\\\t", "");
    }

    public static String toString(Permissions permissions) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < permissions.getPermission().size(); ++i) {
            sb.append("#" + (i + 1) + ":\n" + Helper.toString(permissions.getPermission().get(i)));
            if (i >= permissions.getPermission().size() - 1) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String toString(Permission permission) {
        return permission.getName() + "\n-> " + Helper.toString(permission.getReference());
    }

    public static String toString(Flows flows) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < flows.getFlow().size(); ++i) {
            sb.append("#" + (i + 1) + ":\n");
            if (flows.getFlow().get(i).getAttributes() != null) {
                for (Attribute attr : flows.getFlow().get(i).getAttributes().getAttribute()) {
                    sb.append("(" + attr.getName() + " = " + attr.getValue() + ")\n");
                }
            }
            for (int j = 0; j < flows.getFlow().get(i).getReference().size(); ++j) {
                Reference reference = flows.getFlow().get(i).getReference().get(j);
                if (reference.getType().equals("from")) {
                    sb.append("From:\n" + Helper.toString(reference));
                } else if (reference.getType().equals("to")) {
                    sb.append("To:\n" + Helper.toString(reference));
                }
                if (j == flows.getFlow().get(i).getReference().size() - 1) continue;
                sb.append("\n");
            }
            if (i == flows.getFlow().size() - 1) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String toString(Flow flow) {
        return "From:\n" + Helper.toString(Helper.getFrom(flow.getReference())) + "\nTo:\n" + Helper.toString(Helper.getTo(flow.getReference()));
    }

    public static String toString(Intentsources intentsources) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < intentsources.getIntentsource().size(); ++i) {
            sb.append("#" + (i + 1) + ":\n");
            sb.append(Helper.toString(intentsources.getIntentsource().get(i)));
            if (i >= intentsources.getIntentsource().size() - 1) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String toString(Intentsource intentsource) {
        StringBuilder sb = new StringBuilder();
        sb.append(Helper.toString(intentsource.getTarget()));
        sb.append("Reference:\n" + Helper.toString(intentsource.getReference()));
        return sb.toString();
    }

    public static String toString(Intentsinks intentsinks) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < intentsinks.getIntentsink().size(); ++i) {
            sb.append("#" + (i + 1) + ":\n");
            sb.append(Helper.toString(intentsinks.getIntentsink().get(i)));
            if (i >= intentsinks.getIntentsink().size() - 1) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String toString(Intentsink intentsink) {
        StringBuilder sb = new StringBuilder();
        sb.append(Helper.toString(intentsink.getTarget()));
        sb.append("Reference:\n" + Helper.toString(intentsink.getReference()));
        return sb.toString();
    }

    public static String toString(Target target) {
        return Helper.toString(target, false);
    }

    public static String toString(Target target, boolean detailData) {
        StringBuilder sb = new StringBuilder();
        if (target.getAction() != null && !target.getAction().isEmpty()) {
            for (String action : target.getAction()) {
                sb.append("Action: " + action + "\n");
            }
        }
        if (target.getCategory() != null) {
            for (String category : target.getCategory()) {
                sb.append("Category: " + category + "\n");
            }
        }
        if (target.getData() != null) {
            for (Data data : target.getData()) {
                if (detailData) {
                    sb.append("Data: {\n\t" + Helper.toString(data) + "}\n");
                    continue;
                }
                sb.append("Data: is set" + (data.getType() != null ? " (Type: " + data.getType() + ")" : "") + "\n");
            }
        }
        if (target.getReference() != null) {
            sb.append("Class: " + target.getReference().getClassname() + "\n");
        }
        return sb.toString();
    }

    public static String toString(Data data) {
        StringBuilder sb = new StringBuilder();
        if (data.getHost() != null && data.getPort() != null) {
            sb.append("Host+Port: " + data.getHost() + ":" + data.getPort() + "\n");
        } else if (data.getHost() != null) {
            sb.append("Host: " + data.getHost() + "\n");
        } else if (data.getPort() != null) {
            sb.append("Port: " + data.getPort() + "\n");
        }
        if (data.getPath() != null) {
            sb.append("Path: " + data.getPath() + "\n");
        }
        if (data.getScheme() != null) {
            sb.append("Scheme: " + data.getScheme() + "\n");
        }
        if (data.getSsp() != null) {
            sb.append("SSP: " + data.getSsp() + "\n");
        }
        if (data.getType() != null) {
            sb.append("Type: " + data.getType() + "\n");
        }
        return sb.toString();
    }

    public static String toString(List<Tool> tools) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < tools.size(); ++i) {
            sb.append("#" + (i + 1) + ":\n");
            sb.append(Helper.toString(tools.get(i)));
            if (i >= tools.size() - 1) continue;
            sb.append("\n\n");
        }
        return sb.toString();
    }

    public static String toString(Tool tool) {
        StringBuilder sb = new StringBuilder();
        sb.append("Name: " + tool.getName() + " (" + tool.getVersion() + ")\n");
        if (tool.getPriority().size() <= 1) {
            sb.append("Priority: " + tool.getPriority().get(0).getValue() + (tool.getPriority().get(0).getFeature() != null && !tool.getPriority().get(0).getFeature().equals("") ? " (" + tool.getPriority().get(0).getFeature() + ")" : "") + "\n");
        } else {
            sb.append("Priorities:\n");
            for (Priority priority : tool.getPriority()) {
                sb.append(priority.getValue() + (priority.getFeature() != null && !priority.getFeature().equals("") ? " (" + priority.getFeature() + ")" : "") + "\n");
            }
        }
        sb.append("Questions: " + tool.getQuestions() + "\n");
        sb.append("Path: " + tool.getPath() + "\n");
        if (tool.isExternal()) {
            sb.append("URL: " + tool.getExecute().getUrl() + "\n");
            sb.append("Username: " + tool.getExecute().getUsername() + "\n");
            sb.append("Password: " + tool.getExecute().getPassword() + "\n");
        } else {
            sb.append("Run: " + tool.getExecute().getRun() + "\n");
            sb.append("Result: " + tool.getExecute().getResult() + "\n");
            sb.append("Instances: " + tool.getExecute().getInstances() + "\n");
            sb.append("MemoryPerInstance: " + tool.getExecute().getMemoryPerInstance() + "\n");
        }
        sb.append("\nRun on Event:\n\t- Entry: " + Helper.replaceNull(tool.getRunOnEntry(), "-") + "\n\t- Success: " + Helper.replaceNull(tool.getRunOnSuccess(), "-") + "\n\t- Fail: " + Helper.replaceNull(tool.getRunOnFail(), "-") + "\n\t- Abort: " + Helper.replaceNull(tool.getRunOnAbort(), "-") + "\n\t- Exit: " + Helper.replaceNull(tool.getRunOnExit(), "-"));
        return sb.toString();
    }

    public static String replaceVariables(String str, OperatorTaskInfo taskinfo, List<File> tempAnswerFiles) {
        if ((str.contains("%ANSWERS%") || str.contains("%ANSWERSHASH%")) && tempAnswerFiles != null && !tempAnswerFiles.isEmpty()) {
            String tempAnswerFilesStr = Helper.answerFilesAsString(tempAnswerFiles);
            str = str.replaceAll("%ANSWERS%", tempAnswerFilesStr);
            str = str.replaceAll("%ANSWERSHASH%", HashHelper.sha256Hash(tempAnswerFilesStr));
        } else {
            str = str.replaceAll("%ANSWERS%", "NOT_AVAILABLE");
            str = str.replaceAll("%ANSWERSHASH%", "NOT_AVAILABLE");
        }
        str = str.replaceAll("%ANDROID_PLATFORMS%", ConfigHandler.getInstance().getConfig().getAndroidPlatforms());
        str = Helper.replaceVariables(str, taskinfo);
        return str;
    }

    public static String answerFilesAsString(List<File> answerFiles) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < answerFiles.size(); ++i) {
            sb.append(answerFiles.get(i).getAbsolutePath().replaceAll("\\\\", "/") + (i != answerFiles.size() - 1 ? ", " : ""));
        }
        return sb.toString();
    }

    public static String replaceVariables(String str, TaskInfo taskinfo) {
        if (!taskinfo.getTool().isExternal()) {
            str = str.replaceAll("%MEMORY%", Integer.toString(taskinfo.getTool().getExecute().getMemoryPerInstance()));
            str = str.replaceAll("%PID%", Integer.toString(taskinfo.getPID()));
        }
        return str;
    }

    public static String replaceVariables(String str, TaskInfo taskinfo, App app) {
        Config cfg = ConfigHandler.getInstance().getConfig();
        File apkFile = new File(app.getFile());
        if (apkFile.exists()) {
            ManifestInfo manifestInfo = ManifestHelper.getInstance().getManifest(apkFile);
            return Helper.replaceVariables(str, taskinfo, cfg, apkFile, manifestInfo);
        }
        return Helper.replaceVariables(str, taskinfo, cfg, app.getFile());
    }

    public static String replaceVariables(String str, TaskInfo taskinfo, QuestionPart question) {
        Config cfg = ConfigHandler.getInstance().getConfig();
        if (question.getAllReferences().size() == 2) {
            return Helper.replaceVariables(str, taskinfo, cfg, question.getAllReferences().get(0).getApp().getFile() + " " + question.getAllReferences().get(1).getApp().getFile());
        }
        File apkFile = new File(question.getAllReferences().get(0).getApp().getFile());
        if (apkFile.exists()) {
            ManifestInfo manifestInfo = ManifestHelper.getInstance().getManifest(apkFile);
            return Helper.replaceVariables(str, taskinfo, cfg, apkFile, manifestInfo);
        }
        return Helper.replaceVariables(str, taskinfo, cfg, question.getAllReferences().get(0).getApp().getFile());
    }

    private static String replaceVariables(String str, TaskInfo taskinfo, Config cfg, File apkFile, ManifestInfo manifestInfo) {
        str = str.replaceAll("%APP_APK_FILENAME%", apkFile.getName().substring(0, apkFile.getName().length() - 4));
        str = str.replaceAll("%APP_APK%", apkFile.getAbsolutePath().replaceAll("\\\\", "/"));
        str = str.replaceAll("%APP_NAME%", manifestInfo.getAppName());
        str = str.replaceAll("%APP_PACKAGE%", manifestInfo.getPkgName());
        str = str.replaceAll("%ANDROID_PLATFORMS%", cfg.getAndroidPlatforms());
        str = Helper.replaceVariables(str, taskinfo);
        return str;
    }

    private static String replaceVariables(String str, TaskInfo taskinfo, Config cfg, String name) {
        String editedName = Helper.getMultipleApkName(name);
        str = str.replaceAll("%APP_APK_FILENAME%", editedName);
        String files = "";
        for (String oneFile : name.split(" ")) {
            File apkFile = new File(oneFile);
            if (!files.equals("")) {
                files = files + " ";
            }
            files = files + apkFile.getAbsolutePath().replaceAll("\\\\", "/");
        }
        str = str.replaceAll("%APP_APK%", files);
        str = str.replaceAll("%APP_NAME%", editedName + "_name");
        str = str.replaceAll("%APP_PACKAGE%", editedName + "_pkg");
        str = str.replaceAll("%ANDROID_PLATFORMS%", cfg.getAndroidPlatforms());
        str = Helper.replaceVariables(str, taskinfo);
        return str;
    }

    public static String getMultipleApkName(String name) {
        StringBuilder full = new StringBuilder("");
        for (String onePart : name.split(" ")) {
            if (!(onePart = onePart.replaceAll("\\\\", "/")).contains("/")) continue;
            if (full.length() != 0) {
                full.append(" ");
            }
            full.append(Helper.cut(onePart, "/", -1));
        }
        return full.toString().replaceAll(",", "").replaceAll(" ", "_").replaceAll(".apk", "");
    }

    public static String replaceVariables(String str, ToolTaskInfo taskinfo, File resultFile) {
        str = Helper.replaceVariables(str, (TaskInfo)taskinfo, taskinfo.getQuestion());
        return str.replaceAll("%RESULT_FILE%", resultFile.getAbsolutePath().replaceAll("\\\\", "/"));
    }

    public static boolean replaceQuestionPart(IQuestionNode question, QuestionPart needle, IQuestionNode replacement) {
        for (int i = 0; i < question.getChildren().size(); ++i) {
            if (question.getChildren().get(i) instanceof Question) {
                if (!Helper.replaceQuestionPart(question.getChildren().get(i), needle, replacement)) continue;
                return true;
            }
            if (question.getChildren().get(i) != needle) continue;
            question.getChildren().add(i, replacement);
            question.getChildren().remove(needle);
            return true;
        }
        return false;
    }

    public static boolean replaceAllQuestionPart(IQuestionNode question, QuestionPart needle, IQuestionNode replacement) {
        boolean goOn = true;
        while (goOn) {
            goOn = Helper.replaceQuestionPart(question, needle, replacement);
        }
        return true;
    }

    public static String getDate() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd_MM_yyyy-HH_mm");
        Date date = new Date();
        return dateFormat.format(date);
    }

    public static App createApp(File file) {
        return Helper.createApp(file.toString());
    }

    public static App createApp(String value) {
        App app = new App();
        app.setFile(value);
        Hashes hashes = new Hashes();
        File file = new File(value);
        Hash hashMD5 = new Hash();
        hashMD5.setType("MD5");
        Hash hashSHA1 = new Hash();
        hashSHA1.setType("SHA-1");
        Hash hashSHA256 = new Hash();
        hashSHA256.setType("SHA-256");
        if (file.exists()) {
            hashMD5.setValue(HashHelper.md5Hash(file));
            hashSHA1.setValue(HashHelper.sha1Hash(file));
            hashSHA256.setValue(HashHelper.sha256Hash(file));
        } else {
            Log.msg("Could not find file for hash creation: " + value, 5);
            hashMD5.setValue(HashHelper.md5Hash(value));
            hashSHA1.setValue(HashHelper.sha1Hash(value));
            hashSHA256.setValue(HashHelper.sha256Hash(value));
        }
        hashes.getHash().add(hashMD5);
        hashes.getHash().add(hashSHA1);
        hashes.getHash().add(hashSHA256);
        app.setHashes(hashes);
        return app;
    }

    public static File makeUnique(File file) {
        String extension = "";
        if (file.getName().contains(".")) {
            extension = file.getName().substring(file.getName().lastIndexOf("."));
        }
        int i = 0;
        while (file.exists()) {
            file = new File(file.getAbsolutePath().substring(0, file.getAbsolutePath().length() - (4 + String.valueOf(++i).length())) + i + extension);
        }
        return file;
    }

    public static File findFileWithAsterisk(File file) {
        if (!file.getAbsolutePath().contains("*")) {
            return file;
        }
        String[] needles = file.getName().split("\\*");
        file = new File(file.getAbsolutePath().replaceAll("\\*", "_"));
        boolean didNotExist = false;
        if (!file.exists()) {
            didNotExist = true;
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                Log.error("Analysis result could not be found or written: " + file.getAbsolutePath());
            }
        }
        for (File candidate : file.getParentFile().listFiles()) {
            if (didNotExist && candidate.equals(file)) continue;
            boolean valid = true;
            for (String needle : needles) {
                if (candidate.getName().contains(needle)) continue;
                valid = false;
            }
            if (!valid) continue;
            if (didNotExist) {
                file.delete();
            }
            return candidate;
        }
        if (didNotExist) {
            file.delete();
        }
        return file;
    }

    public static int getPid(Process p) {
        if (Platform.isWindows()) {
            try {
                Field f = p.getClass().getDeclaredField("handle");
                f.setAccessible(true);
                WinNT.HANDLE handle = new WinNT.HANDLE();
                handle.setPointer(Pointer.createConstant(f.getLong(p)));
                int pid = Kernel32.INSTANCE.GetProcessId(handle);
                return pid;
            }
            catch (Exception ex) {
                Log.error("Could not identify process ID on this Windows operating system.");
            }
        } else if (Platform.isLinux()) {
            try {
                Field f = p.getClass().getDeclaredField("pid");
                f.setAccessible(true);
                int pid = (Integer)f.get(p);
                return pid;
            }
            catch (Exception ex) {
                Log.error("Could not identify process ID on this Linux operating system.");
            }
        } else {
            Log.error("Could not identify operating system.");
        }
        return -1;
    }

    public static Reference getFrom(Flow flow) {
        return Helper.getFrom(flow.getReference());
    }

    public static Reference getFrom(List<Reference> references) {
        for (Reference ref : references) {
            if (!ref.getType().equals("from")) continue;
            return ref;
        }
        return null;
    }

    public static Reference getTo(Flow flow) {
        return Helper.getTo(flow.getReference());
    }

    public static Reference getTo(List<Reference> references) {
        for (Reference ref : references) {
            if (!ref.getType().equals("to")) continue;
            return ref;
        }
        return null;
    }

    public static Answer removeRedundant(Answer answer, EqualsOptions options) {
        Serializable obj2;
        int j;
        Serializable obj1;
        int i;
        if (answer.getPermissions() != null) {
            for (i = 0; i < answer.getPermissions().getPermission().size() - 1; ++i) {
                obj1 = answer.getPermissions().getPermission().get(i);
                for (j = i + 1; j < answer.getPermissions().getPermission().size(); ++j) {
                    obj2 = answer.getPermissions().getPermission().get(j);
                    if (!EqualsHelper.equals(obj1, obj2, options)) continue;
                    answer.getPermissions().getPermission().remove(j);
                }
            }
        }
        if (answer.getIntents() != null) {
            for (i = 0; i < answer.getIntents().getIntent().size() - 1; ++i) {
                obj1 = answer.getIntents().getIntent().get(i);
                for (j = i + 1; j < answer.getIntents().getIntent().size(); ++j) {
                    obj2 = answer.getIntents().getIntent().get(j);
                    if (!EqualsHelper.equals((Intent)obj1, (Intent)obj2, options)) continue;
                    answer.getIntents().getIntent().remove(j);
                }
            }
        }
        if (answer.getIntentfilters() != null) {
            for (i = 0; i < answer.getIntentfilters().getIntentfilter().size() - 1; ++i) {
                obj1 = answer.getIntentfilters().getIntentfilter().get(i);
                for (j = i + 1; j < answer.getIntentfilters().getIntentfilter().size(); ++j) {
                    obj2 = answer.getIntentfilters().getIntentfilter().get(j);
                    if (!EqualsHelper.equals((Intentfilter)obj1, (Intentfilter)obj2, options)) continue;
                    answer.getIntentfilters().getIntentfilter().remove(j);
                }
            }
        }
        if (answer.getIntentsinks() != null) {
            for (i = 0; i < answer.getIntentsinks().getIntentsink().size() - 1; ++i) {
                obj1 = answer.getIntentsinks().getIntentsink().get(i);
                for (j = i + 1; j < answer.getIntentsinks().getIntentsink().size(); ++j) {
                    obj2 = answer.getIntentsinks().getIntentsink().get(j);
                    if (!EqualsHelper.equals((Intentsink)obj1, (Intentsink)obj2, options)) continue;
                    answer.getIntentsinks().getIntentsink().remove(j);
                }
            }
        }
        if (answer.getIntentsources() != null) {
            for (i = 0; i < answer.getIntentsources().getIntentsource().size() - 1; ++i) {
                obj1 = answer.getIntentsources().getIntentsource().get(i);
                for (j = i + 1; j < answer.getIntentsources().getIntentsource().size(); ++j) {
                    obj2 = answer.getIntentsources().getIntentsource().get(j);
                    if (!EqualsHelper.equals((Intentsource)obj1, (Intentsource)obj2, options)) continue;
                    answer.getIntentsources().getIntentsource().remove(j);
                }
            }
        }
        if (answer.getFlows() != null) {
            for (i = 0; i < answer.getFlows().getFlow().size() - 1; ++i) {
                obj1 = answer.getFlows().getFlow().get(i);
                for (j = i + 1; j < answer.getFlows().getFlow().size(); ++j) {
                    obj2 = answer.getFlows().getFlow().get(j);
                    if (!EqualsHelper.equals((Flow)obj1, (Flow)obj2, options)) continue;
                    answer.getFlows().getFlow().remove(j);
                }
            }
        }
        return answer;
    }

    public static int getCardinality(Tool tool, String operator) {
        if (tool == null || operator == null) {
            return 2;
        }
        if (tool instanceof DefaultOperator) {
            if (operator.equals(KeywordsAndConstants.getFilterOperator()) || operator.equals(KeywordsAndConstants.OPERATOR_FILTER_ORIGINAL)) {
                return 1;
            }
            return 2;
        }
        for (String splitStr : tool.getQuestions().replaceAll(" ", "").split(",")) {
            if (splitStr.equals(operator)) {
                return 0;
            }
            if (!splitStr.contains("(") || !splitStr.substring(0, splitStr.indexOf("(")).equals(operator)) continue;
            String cardinality = splitStr.substring(splitStr.indexOf("(") + 1, splitStr.indexOf(")"));
            if (cardinality.equals("*")) {
                return 0;
            }
            return Integer.valueOf(cardinality);
        }
        return -1;
    }

    public static void waitForResult(String msg, File result) throws FileNotFoundException {
        for (int i = 0; i <= 10; ++i) {
            if (result.exists()) {
                Log.msg("Result available: " + result.getAbsolutePath(), 6);
                break;
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException e) {
                Log.warning("Interrupted while waiting for result. Trying to continue.");
            }
        }
        if (!result.exists()) {
            throw new FileNotFoundException(msg + "\n(" + result.getAbsolutePath() + ")");
        }
    }

    public static String getExecuteCommand(ToolTaskInfo taskinfo) {
        return taskinfo.getTool().isExternal() ? Helper.replaceVariables(taskinfo.getTool().getExecute().getUrl(), (TaskInfo)taskinfo, taskinfo.getQuestion()) : Helper.replaceVariables(taskinfo.getTool().getExecute().getRun(), (TaskInfo)taskinfo, taskinfo.getQuestion());
    }

    public static String getExecuteCommand(PreprocessorTaskInfo taskinfo) {
        return taskinfo.getTool().isExternal() ? Helper.replaceVariables(taskinfo.getTool().getExecute().getUrl(), (TaskInfo)taskinfo, taskinfo.getApp()) : Helper.replaceVariables(taskinfo.getTool().getExecute().getRun(), (TaskInfo)taskinfo, taskinfo.getApp());
    }

    public static String getExecuteCommand(OperatorTaskInfo taskinfo, List<File> tempAnswerFiles) {
        return taskinfo.getTool().isExternal() ? Helper.replaceVariables(taskinfo.getTool().getExecute().getUrl(), taskinfo, tempAnswerFiles) : Helper.replaceVariables(taskinfo.getTool().getExecute().getRun(), taskinfo, tempAnswerFiles);
    }

    public static File lastFileModified(File directory) {
        File fl = directory;
        File[] files = fl.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile();
            }
        });
        long lastMod = Long.MIN_VALUE;
        File choice = null;
        for (File file : files) {
            if (file.lastModified() <= lastMod) continue;
            choice = file;
            lastMod = file.lastModified();
        }
        return choice;
    }

    public static String replaceNull(String input, String replacement) {
        if (input == null) {
            return replacement;
        }
        return input;
    }

    public static void extractDataFromURI(String uri, Data data) {
        String temp = uri;
        data.setScheme(Helper.cutFromStart(temp, "://"));
        temp = Helper.cut(temp, "://");
        if (temp.contains(":")) {
            data.setHost(Helper.cutFromStart(temp, ":"));
            temp = Helper.cut(temp, ":");
            if (temp.contains("/")) {
                data.setPort(Helper.cutFromStart(temp, "/"));
                temp = Helper.cut(temp, "/");
            } else {
                data.setPort(temp);
                temp = "";
            }
        } else if (temp.contains("/")) {
            data.setHost(Helper.cutFromStart(temp, "/"));
        } else {
            data.setHost(temp);
            temp = "";
        }
        if (!temp.equals("")) {
            data.setPath(temp);
        }
    }

    public static void extractDataFromAuthority(String authority, Data data) {
        String temp = authority;
        if (temp.contains(":")) {
            data.setHost(Helper.cutFromStart(temp, ":"));
            data.setPort(Helper.cut(temp, ":"));
        } else {
            data.setHost(temp);
        }
    }

    public static boolean isEmpty(Answer answer) {
        return !(answer.getFlows() != null && !answer.getFlows().getFlow().isEmpty() || answer.getIntentfilters() != null && !answer.getIntentfilters().getIntentfilter().isEmpty() || answer.getIntents() != null && !answer.getIntents().getIntent().isEmpty() || answer.getIntentsinks() != null && !answer.getIntentsinks().getIntentsink().isEmpty() || answer.getIntentsources() != null && !answer.getIntentsources().getIntentsource().isEmpty() || answer.getPermissions() != null && !answer.getPermissions().getPermission().isEmpty());
    }

    public static Collection<Reference> getAllReferences(Answer answer) {
        return Helper.getAllReferences(answer, false);
    }

    public static Collection<Reference> getAllReferences(Answer answer, boolean doubleEntriesAllowed) {
        ArrayList<Reference> references = new ArrayList<Reference>();
        if (answer.getFlows() != null && !answer.getFlows().getFlow().isEmpty()) {
            for (Flow flow : answer.getFlows().getFlow()) {
                for (Reference ref : flow.getReference()) {
                    if (!doubleEntriesAllowed) {
                        boolean skip = false;
                        for (Reference temp : references) {
                            if (!EqualsHelper.equals(ref, temp)) continue;
                            skip = true;
                            break;
                        }
                        if (skip) continue;
                    }
                    references.add(ref);
                }
            }
        }
        if (answer.getIntentfilters() != null && !answer.getIntentfilters().getIntentfilter().isEmpty()) {
            for (Intentfilter intentfilter : answer.getIntentfilters().getIntentfilter()) {
                if (!doubleEntriesAllowed) {
                    boolean skip = false;
                    for (Reference temp : references) {
                        if (!EqualsHelper.equals(intentfilter.getReference(), temp)) continue;
                        skip = true;
                        break;
                    }
                    if (skip) continue;
                }
                references.add(intentfilter.getReference());
            }
        }
        if (answer.getIntents() != null && !answer.getIntents().getIntent().isEmpty()) {
            for (Intent intent : answer.getIntents().getIntent()) {
                if (!doubleEntriesAllowed) {
                    boolean skip = false;
                    for (Reference temp : references) {
                        if (!EqualsHelper.equals(intent.getReference(), temp)) continue;
                        skip = true;
                        break;
                    }
                    if (skip) continue;
                }
                references.add(intent.getReference());
            }
        }
        if (answer.getIntentsinks() != null && !answer.getIntentsinks().getIntentsink().isEmpty()) {
            for (Intentsink intentsink : answer.getIntentsinks().getIntentsink()) {
                if (!doubleEntriesAllowed) {
                    boolean skip = false;
                    for (Reference temp : references) {
                        if (!EqualsHelper.equals(intentsink.getReference(), temp)) continue;
                        skip = true;
                        break;
                    }
                    if (skip) continue;
                }
                references.add(intentsink.getReference());
            }
        }
        if (answer.getIntentsources() != null && !answer.getIntentsources().getIntentsource().isEmpty()) {
            for (Intentsource intentsource : answer.getIntentsources().getIntentsource()) {
                if (!doubleEntriesAllowed) {
                    boolean skip = false;
                    for (Reference temp : references) {
                        if (!EqualsHelper.equals(intentsource.getReference(), temp)) continue;
                        skip = true;
                        break;
                    }
                    if (skip) continue;
                }
                references.add(intentsource.getReference());
            }
        }
        if (answer.getPermissions() != null && !answer.getPermissions().getPermission().isEmpty()) {
            for (Permission permission : answer.getPermissions().getPermission()) {
                if (!doubleEntriesAllowed) {
                    boolean skip = false;
                    for (Reference temp : references) {
                        if (!EqualsHelper.equals(permission.getReference(), temp)) continue;
                        skip = true;
                        break;
                    }
                    if (skip) continue;
                }
                references.add(permission.getReference());
            }
        }
        return references;
    }
}

