/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.helper;

import de.foellix.aql.Log;
import de.foellix.aql.helper.HashHelper;
import de.foellix.aql.helper.ManifestInfo;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.dongliu.apk.parser.ApkFile;

public class ManifestHelper {
    private final Map<String, ManifestInfo> data = new HashMap<String, ManifestInfo>();
    private static ManifestHelper instance = new ManifestHelper();

    private ManifestHelper() {
    }

    public static ManifestHelper getInstance() {
        return instance;
    }

    public synchronized ManifestInfo getManifest(File apkFile) {
        ManifestInfo manifestInfo = this.data.get(HashHelper.md5Hash(apkFile) + HashHelper.sha1Hash(apkFile));
        if (manifestInfo == null) {
            String manifest;
            try (ApkFile apkParserFile = new ApkFile(apkFile);){
                manifest = apkParserFile.getManifestXml();
            }
            catch (Exception e) {
                Log.error("No valid manifest could be found in: \"" + apkFile.getAbsolutePath() + "\"");
                return null;
            }
            manifestInfo = new ManifestInfo(manifest);
            this.data.put(HashHelper.md5Hash(apkFile) + HashHelper.sha1Hash(apkFile), manifestInfo);
        }
        return manifestInfo;
    }
}

