/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.helper;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class ZipHelper {
    public static void zip(File fileToZip, File zipFile) throws IOException {
        FileOutputStream fos = new FileOutputStream(zipFile);
        ZipOutputStream zipOut = new ZipOutputStream(fos);
        ZipHelper.zipFile(fileToZip, fileToZip.getName(), zipOut, zipFile);
        zipOut.close();
        fos.close();
    }

    private static void zipFile(File fileToZip, String fileName, ZipOutputStream zipOut, File zipFile) throws IOException {
        int length;
        if (fileToZip.equals(zipFile)) {
            return;
        }
        if (fileToZip.isHidden()) {
            return;
        }
        if (fileToZip.isDirectory()) {
            File[] children;
            for (File childFile : children = fileToZip.listFiles()) {
                ZipHelper.zipFile(childFile, fileName + "/" + childFile.getName(), zipOut, zipFile);
            }
            return;
        }
        FileInputStream fis = new FileInputStream(fileToZip);
        ZipEntry zipEntry = new ZipEntry(fileName);
        zipOut.putNextEntry(zipEntry);
        byte[] bytes = new byte[1024];
        while ((length = fis.read(bytes)) >= 0) {
            zipOut.write(bytes, 0, length);
        }
        fis.close();
    }
}

