/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.system;

import de.foellix.aql.config.Tool;
import de.foellix.aql.datastructure.Answer;
import de.foellix.aql.datastructure.Attribute;
import de.foellix.aql.datastructure.Attributes;
import de.foellix.aql.datastructure.Flow;
import de.foellix.aql.datastructure.Flows;
import de.foellix.aql.datastructure.Intent;
import de.foellix.aql.datastructure.Intentfilter;
import de.foellix.aql.datastructure.Intentfilters;
import de.foellix.aql.datastructure.Intents;
import de.foellix.aql.datastructure.Intentsink;
import de.foellix.aql.datastructure.Intentsinks;
import de.foellix.aql.datastructure.Intentsource;
import de.foellix.aql.datastructure.Intentsources;
import de.foellix.aql.datastructure.KeywordsAndConstants;
import de.foellix.aql.datastructure.Permission;
import de.foellix.aql.datastructure.Permissions;
import de.foellix.aql.datastructure.QuestionFilter;
import de.foellix.aql.datastructure.Reference;
import de.foellix.aql.datastructure.WaitingAnswer;
import de.foellix.aql.helper.EqualsHelper;
import de.foellix.aql.helper.EqualsOptions;
import de.foellix.aql.helper.Helper;
import de.foellix.aql.system.task.OperatorTaskInfo;
import java.util.ArrayList;

public class DefaultOperatorInstance
extends Tool {
    private EqualsOptions optionsDefault = EqualsOptions.DEFAULT;
    private static DefaultOperatorInstance instance = new DefaultOperatorInstance();

    private DefaultOperatorInstance() {
    }

    public static DefaultOperatorInstance getInstance() {
        return instance;
    }

    public EqualsOptions getDefaultEqualsOptions() {
        return this.optionsDefault;
    }

    public void setDefaultEqualsOptions(EqualsOptions options) {
        this.optionsDefault = options;
    }

    public void resetDefaultEqualsOptions() {
        this.optionsDefault = EqualsOptions.DEFAULT;
    }

    public Answer applyOperator(OperatorTaskInfo taskinfo) {
        Answer answer = null;
        if (taskinfo.getQuestion().getOperator().equals(KeywordsAndConstants.getFilterOperator()) || taskinfo.getQuestion().getOperator().equals(KeywordsAndConstants.OPERATOR_FILTER_ORIGINAL)) {
            QuestionFilter qf;
            answer = taskinfo.getWaitingAnswer().getAnswers()[0];
            if (answer instanceof WaitingAnswer) {
                answer = ((WaitingAnswer)answer).getAnswer();
            }
            answer = taskinfo.getQuestion() instanceof QuestionFilter ? ((qf = (QuestionFilter)taskinfo.getQuestion()).getName() != null || qf.getValue() != null ? this.filter2(answer, qf.getName(), qf.getValue(), qf.getSoi()) : (qf.getSoi() != -1 ? this.filter3(answer, qf.getSoi()) : this.filter1(answer))) : this.filter1(answer);
        } else {
            Answer a2;
            Answer a1 = taskinfo.getWaitingAnswer().getAnswers()[0];
            if (a1 instanceof WaitingAnswer) {
                a1 = ((WaitingAnswer)a1).getAnswer();
            }
            if ((a2 = taskinfo.getWaitingAnswer().getAnswers()[1]) instanceof WaitingAnswer) {
                a2 = ((WaitingAnswer)a2).getAnswer();
            }
            if (taskinfo.getQuestion().getOperator().equals(KeywordsAndConstants.getUnifyOperator()) || taskinfo.getQuestion().getOperator().equals(KeywordsAndConstants.OPERATOR_UNIFY_ORIGINAL)) {
                answer = this.unify(a1, a2);
            } else if (taskinfo.getQuestion().getOperator().equals(KeywordsAndConstants.getConnectOperator()) || taskinfo.getQuestion().getOperator().equals(KeywordsAndConstants.OPERATOR_CONNECT_ORIGINAL)) {
                answer = this.connect(a1, a2);
            } else if (taskinfo.getQuestion().getOperator().equals(KeywordsAndConstants.getMinusOperator()) || taskinfo.getQuestion().getOperator().equals(KeywordsAndConstants.OPERATOR_MINUS_ORIGINAL)) {
                answer = this.minus(a1, a2);
            } else if (taskinfo.getQuestion().getOperator().equals(KeywordsAndConstants.getIntersectOperator()) || taskinfo.getQuestion().getOperator().equals(KeywordsAndConstants.OPERATOR_INTERSECT_ORIGINAL)) {
                answer = this.intersect(a1, a2);
            }
        }
        return answer;
    }

    public Answer unify(Answer answer, Answer unifyWithAnswer) {
        Answer returnAnswer = new Answer();
        if (answer.getPermissions() != null || unifyWithAnswer.getPermissions() != null) {
            Permissions permissions = new Permissions();
            if (answer.getPermissions() != null) {
                permissions.getPermission().addAll(answer.getPermissions().getPermission());
            }
            if (unifyWithAnswer.getPermissions() != null) {
                permissions.getPermission().addAll(unifyWithAnswer.getPermissions().getPermission());
            }
            returnAnswer.setPermissions(permissions);
        }
        if (answer.getIntents() != null || unifyWithAnswer.getIntents() != null) {
            Intents intents = new Intents();
            if (answer.getIntents() != null) {
                intents.getIntent().addAll(answer.getIntents().getIntent());
            }
            if (unifyWithAnswer.getIntents() != null) {
                intents.getIntent().addAll(unifyWithAnswer.getIntents().getIntent());
            }
            returnAnswer.setIntents(intents);
        }
        if (answer.getIntentfilters() != null || unifyWithAnswer.getIntentfilters() != null) {
            Intentfilters intentfilters = new Intentfilters();
            if (answer.getIntentfilters() != null) {
                intentfilters.getIntentfilter().addAll(answer.getIntentfilters().getIntentfilter());
            }
            if (unifyWithAnswer.getIntentfilters() != null) {
                intentfilters.getIntentfilter().addAll(unifyWithAnswer.getIntentfilters().getIntentfilter());
            }
            returnAnswer.setIntentfilters(intentfilters);
        }
        if (answer.getIntentsinks() != null || unifyWithAnswer.getIntentsinks() != null) {
            Intentsinks intentsinks = new Intentsinks();
            if (answer.getIntentsinks() != null) {
                intentsinks.getIntentsink().addAll(answer.getIntentsinks().getIntentsink());
            }
            if (unifyWithAnswer.getIntentsinks() != null) {
                intentsinks.getIntentsink().addAll(unifyWithAnswer.getIntentsinks().getIntentsink());
            }
            returnAnswer.setIntentsinks(intentsinks);
        }
        if (answer.getIntentsources() != null || unifyWithAnswer.getIntentsources() != null) {
            Intentsources intentsources = new Intentsources();
            if (answer.getIntentsources() != null) {
                intentsources.getIntentsource().addAll(answer.getIntentsources().getIntentsource());
            }
            if (unifyWithAnswer.getIntentsources() != null) {
                intentsources.getIntentsource().addAll(unifyWithAnswer.getIntentsources().getIntentsource());
            }
            returnAnswer.setIntentsources(intentsources);
        }
        if (answer.getFlows() != null || unifyWithAnswer.getFlows() != null) {
            Flows paths = new Flows();
            if (answer.getFlows() != null) {
                paths.getFlow().addAll(answer.getFlows().getFlow());
            }
            if (unifyWithAnswer.getFlows() != null) {
                paths.getFlow().addAll(unifyWithAnswer.getFlows().getFlow());
            }
            returnAnswer.setFlows(paths);
        }
        returnAnswer = Helper.removeRedundant(returnAnswer, this.optionsDefault);
        return returnAnswer;
    }

    public Answer connect(Answer answer, Answer connectWithAnswer) {
        return this.connect(answer, connectWithAnswer, 0);
    }

    public Answer connect(Answer answer, Answer connectWithAnswer, int mode) {
        Answer returnAnswer = this.unify(answer, connectWithAnswer);
        if ((mode == 0 || mode == 2) && returnAnswer.getIntentsinks() != null && returnAnswer.getIntentsources() != null) {
            for (Intentsink from : returnAnswer.getIntentsinks().getIntentsink()) {
                boolean addDefault = false;
                if (from.getTarget().getCategory() == null || !from.getTarget().getCategory().contains("android.intent.category.DEFAULT")) {
                    addDefault = true;
                    from.getTarget().getCategory().add("android.intent.category.DEFAULT");
                }
                for (Intentsource to : returnAnswer.getIntentsources().getIntentsource()) {
                    if (!EqualsHelper.equals(to.getTarget(), from.getTarget())) continue;
                    if (returnAnswer.getFlows() == null) {
                        returnAnswer.setFlows(new Flows());
                    }
                    returnAnswer.getFlows().getFlow().add(this.connect(from, to));
                }
                if (!addDefault) continue;
                from.getTarget().getCategory().remove("android.intent.category.DEFAULT");
            }
        }
        if ((mode == 0 || mode == 1) && returnAnswer.getFlows() != null) {
            boolean fixpoint = false;
            while (!fixpoint) {
                fixpoint = true;
                ArrayList<Flow> addPaths = new ArrayList<Flow>();
                for (Flow path1 : returnAnswer.getFlows().getFlow()) {
                    for (Flow path2 : returnAnswer.getFlows().getFlow()) {
                        if (path1 == path2) continue;
                        Reference path1From = null;
                        Reference path1To = null;
                        Reference path2From = null;
                        Reference path2To = null;
                        for (Reference refPath1 : path1.getReference()) {
                            if (refPath1.getType().equals("from")) {
                                path1From = refPath1;
                                continue;
                            }
                            if (!refPath1.getType().equals("to")) continue;
                            path1To = refPath1;
                        }
                        for (Reference refPath2 : path2.getReference()) {
                            if (refPath2.getType().equals("from")) {
                                path2From = refPath2;
                                continue;
                            }
                            if (!refPath2.getType().equals("to")) continue;
                            path2To = refPath2;
                        }
                        if (path1From == null || path1To == null || path2From == null || path2To == null || !EqualsHelper.equals(path1To, path2From)) continue;
                        boolean exists = false;
                        for (Flow checkPath : returnAnswer.getFlows().getFlow()) {
                            Reference checkFrom = null;
                            Reference checkTo = null;
                            for (Reference checkRef : checkPath.getReference()) {
                                if (checkRef.getType().equals("from")) {
                                    checkFrom = checkRef;
                                    continue;
                                }
                                if (!checkRef.getType().equals("to")) continue;
                                checkTo = checkRef;
                            }
                            if (checkFrom != null && checkTo != null) {
                                if (!EqualsHelper.equals(path1From, checkFrom) || !EqualsHelper.equals(path2To, checkTo)) continue;
                                exists = true;
                                continue;
                            }
                            exists = true;
                        }
                        if (exists) continue;
                        fixpoint = false;
                        addPaths.add(this.connect(path1From, path2To));
                    }
                }
                returnAnswer.getFlows().getFlow().addAll(addPaths);
            }
        }
        returnAnswer = Helper.removeRedundant(returnAnswer, this.optionsDefault);
        return returnAnswer;
    }

    private Flow connect(Reference from, Reference to) {
        Flow newPath = new Flow();
        Reference newFrom = new Reference();
        newFrom.setType("from");
        newFrom.setApp(from.getApp());
        newFrom.setClassname(from.getClassname());
        newFrom.setMethod(from.getMethod());
        newFrom.setStatement(from.getStatement());
        Reference newTo = new Reference();
        newTo.setType("to");
        newTo.setApp(to.getApp());
        newTo.setClassname(to.getClassname());
        newTo.setMethod(to.getMethod());
        newTo.setStatement(to.getStatement());
        newPath.getReference().add(newFrom);
        newPath.getReference().add(newTo);
        return newPath;
    }

    private Flow connect(Intentsink from, Intentsource to) {
        Flow newPath = new Flow();
        Reference newFrom = new Reference();
        newFrom.setType("from");
        newFrom.setApp(from.getReference().getApp());
        newFrom.setClassname(from.getReference().getClassname());
        newFrom.setMethod(from.getReference().getMethod());
        newFrom.setStatement(from.getReference().getStatement());
        Reference newTo = new Reference();
        newTo.setType("to");
        newTo.setApp(to.getReference().getApp());
        newTo.setClassname(to.getReference().getClassname());
        newTo.setMethod(to.getReference().getMethod());
        newTo.setStatement(to.getReference().getStatement());
        newPath.getReference().add(newFrom);
        newPath.getReference().add(newTo);
        return newPath;
    }

    public Answer minus(Answer answer, Answer minusAnswer) {
        return this.minus(answer, minusAnswer, this.optionsDefault);
    }

    public Answer minus(Answer answer, Answer minusAnswer, EqualsOptions options) {
        Answer setminus = new Answer();
        if (answer.getPermissions() != null && !answer.getPermissions().getPermission().isEmpty()) {
            setminus.setPermissions(new Permissions());
            setminus.getPermissions().getPermission().addAll(answer.getPermissions().getPermission());
            if (minusAnswer.getPermissions() != null && !minusAnswer.getPermissions().getPermission().isEmpty()) {
                block0: for (Permission permission : answer.getPermissions().getPermission()) {
                    for (Permission permission2 : minusAnswer.getPermissions().getPermission()) {
                        if (!EqualsHelper.equals(permission2, permission, options)) continue;
                        setminus.getPermissions().getPermission().remove(permission);
                        continue block0;
                    }
                }
            }
        }
        if (answer.getIntents() != null && !answer.getIntents().getIntent().isEmpty()) {
            setminus.setIntents(new Intents());
            setminus.getIntents().getIntent().addAll(answer.getIntents().getIntent());
            if (minusAnswer.getIntents() != null && !minusAnswer.getIntents().getIntent().isEmpty()) {
                block2: for (Intent intent : answer.getIntents().getIntent()) {
                    for (Intent intent2 : minusAnswer.getIntents().getIntent()) {
                        if (!EqualsHelper.equals(intent2, intent, options)) continue;
                        setminus.getIntents().getIntent().remove(intent);
                        continue block2;
                    }
                }
            }
        }
        if (answer.getIntentfilters() != null && !answer.getIntentfilters().getIntentfilter().isEmpty()) {
            setminus.setIntentfilters(new Intentfilters());
            setminus.getIntentfilters().getIntentfilter().addAll(answer.getIntentfilters().getIntentfilter());
            if (minusAnswer.getIntentfilters() != null && !minusAnswer.getIntentfilters().getIntentfilter().isEmpty()) {
                block4: for (Intentfilter intentfilter : answer.getIntentfilters().getIntentfilter()) {
                    for (Intentfilter intentfilter2 : minusAnswer.getIntentfilters().getIntentfilter()) {
                        if (!EqualsHelper.equals(intentfilter2, intentfilter, options)) continue;
                        setminus.getIntentfilters().getIntentfilter().remove(intentfilter);
                        continue block4;
                    }
                }
            }
        }
        if (answer.getIntentsinks() != null && !answer.getIntentsinks().getIntentsink().isEmpty()) {
            setminus.setIntentsinks(new Intentsinks());
            setminus.getIntentsinks().getIntentsink().addAll(answer.getIntentsinks().getIntentsink());
            if (minusAnswer.getIntentsinks() != null && !minusAnswer.getIntentsinks().getIntentsink().isEmpty()) {
                block6: for (Intentsink intentsink : answer.getIntentsinks().getIntentsink()) {
                    for (Intentsink intentsink2 : minusAnswer.getIntentsinks().getIntentsink()) {
                        if (!EqualsHelper.equals(intentsink2, intentsink, options)) continue;
                        setminus.getIntentsinks().getIntentsink().remove(intentsink);
                        continue block6;
                    }
                }
            }
        }
        if (answer.getIntentsources() != null && !answer.getIntentsources().getIntentsource().isEmpty()) {
            setminus.setIntentsources(new Intentsources());
            setminus.getIntentsources().getIntentsource().addAll(answer.getIntentsources().getIntentsource());
            if (minusAnswer.getIntentsources() != null && !minusAnswer.getIntentsources().getIntentsource().isEmpty()) {
                block8: for (Intentsource intentsource : answer.getIntentsources().getIntentsource()) {
                    for (Intentsource intentsource2 : minusAnswer.getIntentsources().getIntentsource()) {
                        if (!EqualsHelper.equals(intentsource2, intentsource, options)) continue;
                        setminus.getIntentsources().getIntentsource().remove(intentsource);
                        continue block8;
                    }
                }
            }
        }
        if (answer.getFlows() != null && !answer.getFlows().getFlow().isEmpty()) {
            setminus.setFlows(new Flows());
            setminus.getFlows().getFlow().addAll(answer.getFlows().getFlow());
            if (minusAnswer.getFlows() != null && !minusAnswer.getFlows().getFlow().isEmpty()) {
                block10: for (Flow flow : answer.getFlows().getFlow()) {
                    for (Flow flow2 : minusAnswer.getFlows().getFlow()) {
                        if (!EqualsHelper.equals(flow2, flow, options)) continue;
                        setminus.getFlows().getFlow().remove(flow);
                        continue block10;
                    }
                }
            }
        }
        return setminus;
    }

    public Answer intersect(Answer answer, Answer intersectWithAnswer) {
        return this.intersect(answer, intersectWithAnswer, this.optionsDefault);
    }

    public Answer intersect(Answer answer, Answer intersectWithAnswer, EqualsOptions options) {
        Answer intersection = new Answer();
        intersection.setPermissions(new Permissions());
        if (answer.getPermissions() != null && !answer.getPermissions().getPermission().isEmpty() && intersectWithAnswer.getPermissions() != null && !intersectWithAnswer.getPermissions().getPermission().isEmpty()) {
            block0: for (Permission permission : answer.getPermissions().getPermission()) {
                for (Permission permission2 : intersectWithAnswer.getPermissions().getPermission()) {
                    if (!EqualsHelper.equals(permission2, permission, options)) continue;
                    intersection.getPermissions().getPermission().add(permission);
                    continue block0;
                }
            }
        }
        if (intersection.getPermissions().getPermission().isEmpty()) {
            intersection.setPermissions(null);
        }
        intersection.setIntents(new Intents());
        if (answer.getIntents() != null && !answer.getIntents().getIntent().isEmpty() && intersectWithAnswer.getIntents() != null && !intersectWithAnswer.getIntents().getIntent().isEmpty()) {
            block2: for (Intent intent : answer.getIntents().getIntent()) {
                for (Intent intent2 : intersectWithAnswer.getIntents().getIntent()) {
                    if (!EqualsHelper.equals(intent2, intent, options)) continue;
                    intersection.getIntents().getIntent().add(intent);
                    continue block2;
                }
            }
        }
        if (intersection.getIntents().getIntent().isEmpty()) {
            intersection.setIntents(null);
        }
        intersection.setIntentfilters(new Intentfilters());
        if (answer.getIntentfilters() != null && !answer.getIntentfilters().getIntentfilter().isEmpty() && intersectWithAnswer.getIntentfilters() != null && !intersectWithAnswer.getIntentfilters().getIntentfilter().isEmpty()) {
            block4: for (Intentfilter intentfilter : answer.getIntentfilters().getIntentfilter()) {
                for (Intentfilter intentfilter2 : intersectWithAnswer.getIntentfilters().getIntentfilter()) {
                    if (!EqualsHelper.equals(intentfilter2, intentfilter, options)) continue;
                    intersection.getIntentfilters().getIntentfilter().add(intentfilter);
                    continue block4;
                }
            }
        }
        if (intersection.getIntentfilters().getIntentfilter().isEmpty()) {
            intersection.setIntentfilters(null);
        }
        intersection.setIntentsinks(new Intentsinks());
        if (answer.getIntentsinks() != null && !answer.getIntentsinks().getIntentsink().isEmpty() && intersectWithAnswer.getIntentsinks() != null && !intersectWithAnswer.getIntentsinks().getIntentsink().isEmpty()) {
            block6: for (Intentsink intentsink : answer.getIntentsinks().getIntentsink()) {
                for (Intentsink intentsink2 : intersectWithAnswer.getIntentsinks().getIntentsink()) {
                    if (!EqualsHelper.equals(intentsink2, intentsink, options)) continue;
                    intersection.getIntentsinks().getIntentsink().add(intentsink);
                    continue block6;
                }
            }
        }
        if (intersection.getIntentsinks().getIntentsink().isEmpty()) {
            intersection.setIntentsinks(null);
        }
        intersection.setIntentsources(new Intentsources());
        if (answer.getIntentsources() != null && !answer.getIntentsources().getIntentsource().isEmpty() && intersectWithAnswer.getIntentsources() != null && !intersectWithAnswer.getIntentsources().getIntentsource().isEmpty()) {
            block8: for (Intentsource intentsource : answer.getIntentsources().getIntentsource()) {
                for (Intentsource intentsource2 : intersectWithAnswer.getIntentsources().getIntentsource()) {
                    if (!EqualsHelper.equals(intentsource2, intentsource, options)) continue;
                    intersection.getIntentsources().getIntentsource().add(intentsource);
                    continue block8;
                }
            }
        }
        if (intersection.getIntentsources().getIntentsource().isEmpty()) {
            intersection.setIntentsources(null);
        }
        intersection.setFlows(new Flows());
        if (answer.getFlows() != null && !answer.getFlows().getFlow().isEmpty() && intersectWithAnswer.getFlows() != null && !intersectWithAnswer.getFlows().getFlow().isEmpty()) {
            block10: for (Flow flow : answer.getFlows().getFlow()) {
                for (Flow flow2 : intersectWithAnswer.getFlows().getFlow()) {
                    if (!EqualsHelper.equals(flow2, flow, options)) continue;
                    intersection.getFlows().getFlow().add(flow);
                    continue block10;
                }
            }
        }
        if (intersection.getFlows().getFlow().isEmpty()) {
            intersection.setFlows(null);
        }
        return intersection;
    }

    public Answer filter1(Answer answer) {
        Reference ref1;
        int i;
        if (answer.getPermissions() != null) {
            for (i = 0; i < answer.getPermissions().getPermission().size(); ++i) {
                ref1 = answer.getPermissions().getPermission().get(i).getReference();
                if (!this.filter(ref1, answer)) continue;
                answer.getPermissions().getPermission().remove(i);
                --i;
            }
            if (answer.getPermissions().getPermission().size() == 0) {
                answer.setPermissions(null);
            }
        }
        if (answer.getIntentsinks() != null) {
            for (i = 0; i < answer.getIntentsinks().getIntentsink().size(); ++i) {
                ref1 = answer.getIntentsinks().getIntentsink().get(i).getReference();
                if (!this.filter(ref1, answer)) continue;
                answer.getIntentsinks().getIntentsink().remove(i);
                --i;
            }
            if (answer.getIntentsinks().getIntentsink().size() == 0) {
                answer.setIntentsinks(null);
            }
        }
        if (answer.getIntentsources() != null) {
            for (i = 0; i < answer.getIntentsources().getIntentsource().size(); ++i) {
                ref1 = answer.getIntentsources().getIntentsource().get(i).getReference();
                if (!this.filter(ref1, answer)) continue;
                answer.getIntentsources().getIntentsource().remove(i);
                --i;
            }
            if (answer.getIntentsources().getIntentsource().size() == 0) {
                answer.setIntentsources(null);
            }
        }
        if (answer.getFlows() != null) {
            for (Flow path1 : answer.getFlows().getFlow()) {
                if (path1.getAttributes() == null) continue;
                Attribute removeAttr = null;
                for (Attribute attr : path1.getAttributes().getAttribute()) {
                    if (!attr.getName().equals("complete") || !attr.getValue().equals("true")) continue;
                    removeAttr = attr;
                    break;
                }
                if (removeAttr == null) continue;
                path1.getAttributes().getAttribute().remove(removeAttr);
            }
            for (Flow path1 : answer.getFlows().getFlow()) {
                boolean complete = true;
                Reference path1From = null;
                Reference path1To = null;
                for (Reference reference : path1.getReference()) {
                    if (reference.getType().equals("from")) {
                        path1From = reference;
                        continue;
                    }
                    if (!reference.getType().equals("to")) continue;
                    path1To = reference;
                }
                for (Flow flow : answer.getFlows().getFlow()) {
                    if (path1 == flow) continue;
                    Reference path2From = null;
                    Reference path2To = null;
                    for (Reference refPath2 : flow.getReference()) {
                        if (refPath2.getType().equals("from")) {
                            path2From = refPath2;
                            continue;
                        }
                        if (!refPath2.getType().equals("to")) continue;
                        path2To = refPath2;
                    }
                    if (!EqualsHelper.equals(path1From, path2To) && !EqualsHelper.equals(path1To, path2From)) continue;
                    complete = false;
                }
                if (!complete) continue;
                boolean add = true;
                if (path1.getAttributes() == null) {
                    path1.setAttributes(new Attributes());
                } else {
                    for (Attribute attr : path1.getAttributes().getAttribute()) {
                        if (!attr.getName().equals("complete") || !attr.getValue().equals("true")) continue;
                        add = false;
                        break;
                    }
                }
                if (!add) continue;
                Attribute attribute = new Attribute();
                attribute.setName("complete");
                attribute.setValue("true");
                path1.getAttributes().getAttribute().add(attribute);
            }
        }
        answer = Helper.removeRedundant(answer, this.optionsDefault);
        return answer;
    }

    private boolean filter(Reference ref1, Answer answer) {
        if (answer.getFlows() == null) {
            return true;
        }
        for (Flow path : answer.getFlows().getFlow()) {
            for (Reference ref2 : path.getReference()) {
                if (!EqualsHelper.equals(ref1, ref2)) continue;
                return false;
            }
        }
        return true;
    }

    public Answer filter2(Answer answer, String name, String value, int soi) {
        boolean keep;
        int i;
        name = name.substring(1, name.length() - 1);
        value = value.substring(1, value.length() - 1);
        if ((soi == -1 || soi == 1) && answer.getPermissions() != null) {
            for (i = 0; i < answer.getPermissions().getPermission().size(); ++i) {
                keep = false;
                if (answer.getPermissions().getPermission().get(i).getAttributes() != null) {
                    for (Attribute attr : answer.getPermissions().getPermission().get(i).getAttributes().getAttribute()) {
                        if (!attr.getName().equals(name) || !attr.getValue().equals(value)) continue;
                        keep = true;
                        break;
                    }
                }
                if (keep) continue;
                answer.getPermissions().getPermission().remove(i);
                --i;
            }
            if (answer.getPermissions().getPermission().size() == 0) {
                answer.setPermissions(null);
            }
        }
        if ((soi == -1 || soi == 2) && answer.getIntents() != null) {
            for (i = 0; i < answer.getIntents().getIntent().size(); ++i) {
                keep = false;
                if (answer.getIntents().getIntent().get(i).getAttributes() != null) {
                    for (Attribute attr : answer.getIntents().getIntent().get(i).getAttributes().getAttribute()) {
                        if (!attr.getName().equals(name) || !attr.getValue().equals(value)) continue;
                        keep = true;
                        break;
                    }
                }
                if (keep) continue;
                answer.getIntents().getIntent().remove(i);
                --i;
            }
            if (answer.getIntents().getIntent().size() == 0) {
                answer.setIntents(null);
            }
        }
        if ((soi == -1 || soi == 3) && answer.getIntentfilters() != null) {
            for (i = 0; i < answer.getIntentfilters().getIntentfilter().size(); ++i) {
                keep = false;
                if (answer.getIntentfilters().getIntentfilter().get(i).getAttributes() != null) {
                    for (Attribute attr : answer.getIntentfilters().getIntentfilter().get(i).getAttributes().getAttribute()) {
                        if (!attr.getName().equals(name) || !attr.getValue().equals(value)) continue;
                        keep = true;
                        break;
                    }
                }
                if (keep) continue;
                answer.getIntentfilters().getIntentfilter().remove(i);
                --i;
            }
            if (answer.getIntentfilters().getIntentfilter().size() == 0) {
                answer.setIntentfilters(null);
            }
        }
        if ((soi == -1 || soi == 5) && answer.getIntentsinks() != null) {
            for (i = 0; i < answer.getIntentsinks().getIntentsink().size(); ++i) {
                keep = false;
                if (answer.getIntentsinks().getIntentsink().get(i).getAttributes() != null) {
                    for (Attribute attr : answer.getIntentsinks().getIntentsink().get(i).getAttributes().getAttribute()) {
                        if (!attr.getName().equals(name) || !attr.getValue().equals(value)) continue;
                        keep = true;
                        break;
                    }
                }
                if (keep) continue;
                answer.getIntentsinks().getIntentsink().remove(i);
                --i;
            }
            if (answer.getIntentsinks().getIntentsink().size() == 0) {
                answer.setIntentsinks(null);
            }
        }
        if ((soi == -1 || soi == 4) && answer.getIntentsources() != null) {
            for (i = 0; i < answer.getIntentsources().getIntentsource().size(); ++i) {
                keep = false;
                if (answer.getIntentsources().getIntentsource().get(i).getAttributes() != null) {
                    for (Attribute attr : answer.getIntentsources().getIntentsource().get(i).getAttributes().getAttribute()) {
                        if (!attr.getName().equals(name) || !attr.getValue().equals(value)) continue;
                        keep = true;
                        break;
                    }
                }
                if (keep) continue;
                answer.getIntentsources().getIntentsource().remove(i);
                --i;
            }
            if (answer.getIntentsources().getIntentsource().size() == 0) {
                answer.setIntentsources(null);
            }
        }
        if ((soi == -1 || soi == 0) && answer.getFlows() != null) {
            for (i = 0; i < answer.getFlows().getFlow().size(); ++i) {
                keep = false;
                if (answer.getFlows().getFlow().get(i).getAttributes() != null) {
                    for (Attribute attr : answer.getFlows().getFlow().get(i).getAttributes().getAttribute()) {
                        if (!attr.getName().equals(name) || !attr.getValue().equals(value)) continue;
                        keep = true;
                        break;
                    }
                }
                if (keep) continue;
                answer.getFlows().getFlow().remove(i);
                --i;
            }
            if (answer.getFlows().getFlow().size() == 0) {
                answer.setFlows(null);
            }
        }
        return answer;
    }

    public Answer filter3(Answer answer, int soi) {
        if (soi == 1) {
            answer.setPermissions(null);
        }
        if (soi == 2) {
            answer.setIntents(null);
        }
        if (soi == 3) {
            answer.setIntentfilters(null);
        }
        if (soi == 5) {
            answer.setIntentsinks(null);
        }
        if (soi == 4) {
            answer.setIntentsources(null);
        }
        if (soi == 0) {
            answer.setFlows(null);
        }
        return answer;
    }
}

