/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.system;

import de.foellix.aql.Log;
import de.foellix.aql.config.Tool;
import de.foellix.aql.datastructure.Answer;
import de.foellix.aql.datastructure.IQuestionNode;
import de.foellix.aql.datastructure.KeywordsAndConstants;
import de.foellix.aql.datastructure.Question;
import de.foellix.aql.datastructure.WaitingAnswer;
import de.foellix.aql.helper.Helper;
import de.foellix.aql.system.DefaultOperator;
import de.foellix.aql.system.System;
import de.foellix.aql.system.ToolSelector;
import de.foellix.aql.system.task.OperatorTaskInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class OperatorManager {
    private final System parent;
    private List<OperatorTaskInfo> listToSchedule;
    private Collection<Answer> collection;

    OperatorManager(System parent) {
        this.parent = parent;
        this.collection = null;
    }

    void apply() {
        this.listToSchedule = new ArrayList<OperatorTaskInfo>();
        this.collection = this.parent.buildCompleteAnswer(this.parent.getCurrentQuery());
        this.parent.getScheduler().setWaiting(this.listToSchedule.size());
        this.parent.setMax(this.listToSchedule.size());
        this.parent.progress("Step 3 of 3: Applying operators");
        if (this.parent.getMax() != 0) {
            for (OperatorTaskInfo task : this.listToSchedule) {
                this.parent.getScheduler().scheduleOperator(task);
            }
            this.parent.getScheduler().runSchedule();
        } else {
            this.parent.operatorExecuted(null, null);
        }
    }

    public Answer applyOperator(Question question) {
        int cardinality;
        Tool operator = ToolSelector.getInstance().selectOperator(question);
        if (operator == null && (question.getOperator().equals(KeywordsAndConstants.getFilterOperator()) || question.getOperator().equals(KeywordsAndConstants.OPERATOR_FILTER_ORIGINAL) || question.getOperator().equals(KeywordsAndConstants.getUnifyOperator()) || question.getOperator().equals(KeywordsAndConstants.OPERATOR_UNIFY_ORIGINAL) || question.getOperator().equals(KeywordsAndConstants.getConnectOperator()) || question.getOperator().equals(KeywordsAndConstants.OPERATOR_CONNECT_ORIGINAL) || question.getOperator().equals(KeywordsAndConstants.getMinusOperator()) || question.getOperator().equals(KeywordsAndConstants.OPERATOR_MINUS_ORIGINAL) || question.getOperator().equals(KeywordsAndConstants.getIntersectOperator()) || question.getOperator().equals(KeywordsAndConstants.OPERATOR_INTERSECT_ORIGINAL))) {
            operator = new DefaultOperator();
        }
        if ((cardinality = Helper.getCardinality(operator, question.getOperator())) == 0) {
            cardinality = question.getChildren().size();
        }
        if (question.getChildren().size() != cardinality) {
            if (!(operator instanceof DefaultOperator)) {
                Log.warning("Wrong number of parameters for " + question.getOperator() + " operator. Trying to apply it multiple times with two parameters");
            }
            cardinality = 2;
        }
        Answer answer = null;
        if (cardinality == 2) {
            for (int i = 0; i < question.getChildren().size(); ++i) {
                if (question.getChildren().get(i) instanceof Question && ((Question)question.getChildren().get(i)).getOperator().equals("COLLECTION")) {
                    for (IQuestionNode child : question.getChildren().get(i).getChildren()) {
                        if (answer == null) {
                            answer = this.parent.buildCompleteAnswerNotCollection(child);
                            continue;
                        }
                        answer = this.applyOperator(question, operator, answer, this.parent.buildCompleteAnswerNotCollection(child));
                    }
                    continue;
                }
                answer = answer == null ? this.parent.buildCompleteAnswerNotCollection(question.getChildren().get(i)) : this.applyOperator(question, operator, answer, this.parent.buildCompleteAnswerNotCollection(question.getChildren().get(i)));
            }
        } else {
            Answer[] answers = new Answer[cardinality];
            for (int i = 0; i < cardinality; ++i) {
                answers[i] = this.parent.buildCompleteAnswerNotCollection(question.getChildren().get(i));
            }
            answer = this.applyOperator(question, operator, answers);
        }
        return answer;
    }

    private Answer applyOperator(Question question, Tool operator, Answer ... answers) {
        WaitingAnswer answer = new WaitingAnswer(operator, answers);
        this.listToSchedule.add(new OperatorTaskInfo(question, operator, answer));
        return answer;
    }

    public Collection<Answer> getAnswerCollection() {
        return this.collection;
    }
}

