/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.system;

import de.foellix.aql.Log;
import de.foellix.aql.datastructure.Answer;
import de.foellix.aql.datastructure.App;
import de.foellix.aql.datastructure.Flow;
import de.foellix.aql.datastructure.IQuestionNode;
import de.foellix.aql.datastructure.PreviousQuestion;
import de.foellix.aql.datastructure.Question;
import de.foellix.aql.datastructure.QuestionPart;
import de.foellix.aql.datastructure.Reference;
import de.foellix.aql.datastructure.WaitingAnswer;
import de.foellix.aql.datastructure.handler.AnswerHandler;
import de.foellix.aql.datastructure.handler.QueryHandler;
import de.foellix.aql.helper.EqualsHelper;
import de.foellix.aql.helper.EqualsOptions;
import de.foellix.aql.helper.Helper;
import de.foellix.aql.system.DefaultOperator;
import de.foellix.aql.system.IAnswerAvailable;
import de.foellix.aql.system.IProgressChanged;
import de.foellix.aql.system.OperatorManager;
import de.foellix.aql.system.QueryProcessor;
import de.foellix.aql.system.Scheduler;
import de.foellix.aql.system.task.PreprocessorTaskInfo;
import de.foellix.aql.system.task.Task;
import de.foellix.aql.system.task.TaskHooks;
import de.foellix.aql.ui.cli.AnswerToConsole;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class System {
    private boolean storeAnswers = true;
    private final QueryProcessor queryProcessor;
    private final Scheduler scheduler;
    private final OperatorManager operatorManager;
    private final TaskHooks taskHooksBefore;
    private final TaskHooks taskHooksAfter;
    private final List<IAnswerAvailable> answerReceivers = new ArrayList<IAnswerAvailable>();
    private final List<IProgressChanged> progressListener = new ArrayList<IProgressChanged>();
    private String currentInitialQuery;
    private Collection<Answer> waitForAnswers;
    private boolean waitForAnswersFlag;
    private IQuestionNode currentQuery;
    private Map<QuestionPart, Answer> tempStorage;
    private String step;
    private int max = 0;
    private final Lock lock;

    public System() {
        if (Log.logIt(4)) {
            this.answerReceivers.add(new AnswerToConsole());
        }
        this.queryProcessor = new QueryProcessor(this);
        this.scheduler = new Scheduler(this);
        this.operatorManager = new OperatorManager(this);
        this.taskHooksBefore = new TaskHooks();
        this.taskHooksAfter = new TaskHooks();
        this.lock = new ReentrantLock();
    }

    public void query(String query) {
        Log.reset();
        this.currentInitialQuery = query.replaceAll("\n", "").replaceAll("\t", "").replaceAll("\r", "");
        Log.msg("Started: " + this.currentInitialQuery, 0);
        this.currentQuery = QueryHandler.parseQuery(query);
        this.queryProcessor.preprocess();
    }

    public Collection<Answer> queryAndWait(String query) {
        this.waitForAnswers = null;
        this.waitForAnswersFlag = false;
        new Thread(() -> this.query(query)).start();
        while (!this.waitForAnswersFlag) {
            try {
                Thread.sleep(250L);
            }
            catch (InterruptedException e) {
                return null;
            }
        }
        return this.waitForAnswers;
    }

    public void preprocessingFinished(PreprocessorTaskInfo taskInfo, App storedPreprocessedVersion) {
        QuestionPart questionPart = taskInfo.getQuestion();
        for (Reference reference : questionPart.getAllReferences()) {
            if (!EqualsHelper.equals(reference.getApp(), taskInfo.getApp())) continue;
            if (storedPreprocessedVersion != null) {
                reference.setApp(storedPreprocessedVersion);
            }
            questionPart.removePreprocessor(reference, taskInfo.getKeyword());
            try {
                PreprocessorTaskInfo followUpTask = this.queryProcessor.addPreprocessorTask(questionPart, reference);
                if (followUpTask == null) continue;
                this.scheduler.schedulePreprocessor(followUpTask);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.scheduler.decreaseWaiting();
        this.progress();
        this.lock.lock();
        if (this.scheduler.getWaiting() <= 0) {
            this.queryProcessor.ask(this.currentQuery);
        }
        this.lock.unlock();
    }

    public void localAnswerAvailable(QuestionPart questionPart, Answer answer) {
        if (questionPart != null && answer == null) {
            Log.msg("Aborted: " + this.currentInitialQuery, 0);
            this.scheduler.setWaiting(0);
            this.scheduler.getRunningInstances().clear();
            this.scheduler.getSchedule().clear();
            for (Task task : this.scheduler.getCurrentlyRunningThreads()) {
                task.interrupt();
            }
            this.scheduler.getCurrentlyRunningThreads().clear();
            this.progress("Aborted");
            for (IAnswerAvailable receiver : this.answerReceivers) {
                receiver.answerAvailable(new Answer(), -1);
            }
            this.waitForAnswersFlag = true;
            return;
        }
        if (questionPart != null && answer != null) {
            if (!Helper.isEmpty(answer)) {
                Answer filteredAnswer = this.filterByRef(questionPart, answer = this.filterBySOI(questionPart, answer), false);
                if (Helper.isEmpty(filteredAnswer)) {
                    Log.warning("Filtering answer by given Reference returns an empty answer. Trying to ignore app reference.");
                    answer = this.filterByRef(questionPart, answer, true);
                } else {
                    answer = filteredAnswer;
                }
            }
            Log.msg("**** Answer available ****\nQuestion:\n" + questionPart.toString() + "\nAnswer:\n" + Helper.toString(answer), 6);
            this.tempStorage.put(questionPart, answer);
        }
        this.scheduler.decreaseWaiting();
        this.progress();
        this.lock.lock();
        if (this.scheduler.getWaiting() <= 0) {
            this.operatorManager.apply();
        }
        this.lock.unlock();
    }

    public void operatorExecuted(WaitingAnswer waitingAnswer, Answer answer) {
        if (waitingAnswer != null) {
            waitingAnswer.setAnswer(answer);
        }
        this.scheduler.decreaseWaiting();
        this.progress();
        this.lock.lock();
        if (this.scheduler.getWaiting() <= 0) {
            Collection<Answer> collection = this.operatorManager.getAnswerCollection();
            Log.msg("****** Answer Collection ******\n", 6);
            this.waitForAnswers = new ArrayList<Answer>();
            for (Answer collectionPart : collection) {
                if (collectionPart instanceof WaitingAnswer) {
                    this.waitForAnswers.add(((WaitingAnswer)collectionPart).getAnswer());
                    continue;
                }
                this.waitForAnswers.add(collectionPart);
            }
            for (Answer collectionPart : this.waitForAnswers) {
                if (this.storeAnswers) {
                    File xmlFile = Helper.makeUnique(new File("answers/answer_" + Helper.getDate() + "-0.xml"));
                    AnswerHandler.createXML(collectionPart, xmlFile);
                }
                Log.msg("***** Answer *****\n" + Helper.toString(collectionPart), 5);
                for (IAnswerAvailable receiver : this.answerReceivers) {
                    receiver.answerAvailable(collectionPart, 1);
                }
            }
            Log.msg("Finished: " + this.currentInitialQuery, 0);
            this.waitForAnswersFlag = true;
        }
        this.lock.unlock();
    }

    private Answer filterBySOI(QuestionPart questionPart, Answer answer) {
        int[] sois;
        for (int soi : sois = new int[]{0, 3, 2, 5, 4, 1}) {
            if (questionPart.getMode() == soi) continue;
            DefaultOperator.filter3(answer, soi);
        }
        return answer;
    }

    private Answer filterByRef(QuestionPart questionPart, Answer answer, boolean ignoreApp) {
        Reference ref;
        int i;
        Answer filteredAnswer = Helper.copy(answer);
        EqualsOptions options = new EqualsOptions();
        options.setOption(0, true);
        options.setOption(3, ignoreApp);
        if (filteredAnswer.getPermissions() != null) {
            for (i = 0; i < filteredAnswer.getPermissions().getPermission().size(); ++i) {
                ref = filteredAnswer.getPermissions().getPermission().get(i).getReference();
                if (EqualsHelper.equals(questionPart.getAllReferences().get(0), ref, options)) continue;
                filteredAnswer.getPermissions().getPermission().remove(i);
                --i;
            }
            if (filteredAnswer.getPermissions().getPermission().size() == 0) {
                filteredAnswer.setPermissions(null);
            }
        }
        if (filteredAnswer.getIntents() != null) {
            for (i = 0; i < filteredAnswer.getIntents().getIntent().size(); ++i) {
                ref = filteredAnswer.getIntents().getIntent().get(i).getReference();
                if (EqualsHelper.equals(questionPart.getAllReferences().get(0), ref, options)) continue;
                filteredAnswer.getIntents().getIntent().remove(i);
                --i;
            }
            if (filteredAnswer.getIntents().getIntent().size() == 0) {
                filteredAnswer.setIntents(null);
            }
        }
        if (filteredAnswer.getIntentfilters() != null) {
            for (i = 0; i < filteredAnswer.getIntentfilters().getIntentfilter().size(); ++i) {
                ref = filteredAnswer.getIntentfilters().getIntentfilter().get(i).getReference();
                if (EqualsHelper.equals(questionPart.getAllReferences().get(0), ref, options)) continue;
                filteredAnswer.getIntentfilters().getIntentfilter().remove(i);
                --i;
            }
            if (filteredAnswer.getIntentfilters().getIntentfilter().size() == 0) {
                filteredAnswer.setIntentfilters(null);
            }
        }
        if (filteredAnswer.getIntentsinks() != null) {
            for (i = 0; i < filteredAnswer.getIntentsinks().getIntentsink().size(); ++i) {
                ref = filteredAnswer.getIntentsinks().getIntentsink().get(i).getReference();
                if (EqualsHelper.equals(questionPart.getAllReferences().get(0), ref, options)) continue;
                filteredAnswer.getIntentsinks().getIntentsink().remove(i);
                --i;
            }
            if (filteredAnswer.getIntentsinks().getIntentsink().size() == 0) {
                filteredAnswer.setIntentsinks(null);
            }
        }
        if (filteredAnswer.getIntentsources() != null) {
            for (i = 0; i < filteredAnswer.getIntentsources().getIntentsource().size(); ++i) {
                ref = filteredAnswer.getIntentsources().getIntentsource().get(i).getReference();
                if (EqualsHelper.equals(questionPart.getAllReferences().get(0), ref, options)) continue;
                filteredAnswer.getIntentsources().getIntentsource().remove(i);
                --i;
            }
            if (filteredAnswer.getIntentsources().getIntentsource().size() == 0) {
                filteredAnswer.setIntentsources(null);
            }
        }
        if (filteredAnswer.getFlows() != null) {
            for (i = 0; i < filteredAnswer.getFlows().getFlow().size(); ++i) {
                if (filteredAnswer.getFlows().getFlow().get(i).getReference().size() == 1) continue;
                boolean keepFrom = false;
                boolean keepTo = questionPart.getAllReferences().size() < 2;
                Reference fromRef = null;
                Reference toRef = null;
                for (Reference ref2 : filteredAnswer.getFlows().getFlow().get(i).getReference()) {
                    if (ref2.getType().equals("from")) {
                        fromRef = ref2;
                        if (EqualsHelper.equals(questionPart.getAllReferences().get(0), fromRef, options)) {
                            keepFrom = true;
                        }
                    }
                    if (keepTo || !ref2.getType().equals("to")) continue;
                    toRef = ref2;
                    if (!EqualsHelper.equals(questionPart.getAllReferences().get(1), toRef, options)) continue;
                    keepTo = true;
                }
                if (fromRef != null && toRef != null) {
                    boolean keepTo2;
                    boolean keepFrom2;
                    if (!keepFrom && keepTo) {
                        for (Flow flow : filteredAnswer.getFlows().getFlow()) {
                            keepFrom2 = false;
                            keepTo2 = false;
                            for (Reference ref3 : flow.getReference()) {
                                if (ref3.getType().equals("from")) {
                                    if (!EqualsHelper.equals(questionPart.getAllReferences().get(0), ref3, options)) continue;
                                    keepFrom2 = true;
                                    continue;
                                }
                                if (!ref3.getType().equals("to") || !EqualsHelper.equals(ref3, fromRef)) continue;
                                keepTo2 = true;
                            }
                            if (!keepFrom2 || !keepTo2) continue;
                            keepFrom = true;
                            break;
                        }
                    } else if (keepFrom && !keepTo) {
                        for (Flow flow : filteredAnswer.getFlows().getFlow()) {
                            keepFrom2 = false;
                            keepTo2 = false;
                            for (Reference ref3 : flow.getReference()) {
                                if (ref3.getType().equals("from")) {
                                    if (!EqualsHelper.equals(ref3, toRef)) continue;
                                    keepFrom2 = true;
                                    continue;
                                }
                                if (!ref3.getType().equals("to") || !EqualsHelper.equals(questionPart.getAllReferences().get(1), ref3, options)) continue;
                                keepTo2 = true;
                            }
                            if (!keepFrom2 || !keepTo2) continue;
                            keepTo = true;
                            break;
                        }
                    }
                }
                if (keepFrom && keepTo) continue;
                filteredAnswer.getFlows().getFlow().remove(i);
                --i;
            }
            if (filteredAnswer.getFlows().getFlow().size() == 0) {
                filteredAnswer.setFlows(null);
            }
        }
        return filteredAnswer;
    }

    List<Answer> buildCompleteAnswer(IQuestionNode question) {
        ArrayList<Answer> answerCollection = new ArrayList<Answer>();
        if (question instanceof Question && ((Question)question).getOperator().equals("COLLECTION")) {
            for (IQuestionNode child : question.getChildren()) {
                answerCollection.add(this.buildCompleteAnswerNotCollection(child));
            }
        } else {
            answerCollection.add(this.buildCompleteAnswerNotCollection(question));
        }
        return answerCollection;
    }

    Answer buildCompleteAnswerNotCollection(IQuestionNode question) {
        if (question instanceof Question) {
            return this.operatorManager.applyOperator((Question)question);
        }
        if (question instanceof QuestionPart) {
            return this.tempStorage.get(question);
        }
        Answer a = AnswerHandler.parseXML(new File(((PreviousQuestion)question).getFile()));
        if (a != null) {
            return a;
        }
        return new Answer();
    }

    void progress() {
        this.progress(this.step);
    }

    void progress(String step) {
        this.step = step;
        int inProgress = 0;
        if (this.scheduler.getWaiting() != 0) {
            for (Integer active : this.scheduler.getRunningInstances().values()) {
                inProgress += active.intValue();
            }
        }
        for (IProgressChanged listener : this.progressListener) {
            listener.onProgressChanged(step, inProgress, this.max - this.scheduler.getWaiting(), this.max);
        }
    }

    public void cancel() {
        this.localAnswerAvailable(new QuestionPart(), null);
    }

    public QueryProcessor getQueryProcessor() {
        return this.queryProcessor;
    }

    public Scheduler getScheduler() {
        return this.scheduler;
    }

    public OperatorManager getOperatorManager() {
        return this.operatorManager;
    }

    public TaskHooks getTaskHooksBefore() {
        return this.taskHooksBefore;
    }

    public TaskHooks getTaskHooksAfter() {
        return this.taskHooksAfter;
    }

    public List<IAnswerAvailable> getAnswerReceivers() {
        return this.answerReceivers;
    }

    public List<IProgressChanged> getProgressListener() {
        return this.progressListener;
    }

    public IQuestionNode getCurrentQuery() {
        return this.currentQuery;
    }

    public Map<QuestionPart, Answer> getTempStorage() {
        return this.tempStorage;
    }

    public int getMax() {
        return this.max;
    }

    public void setCurrentQuery(IQuestionNode currentQuery) {
        this.currentQuery = currentQuery;
    }

    public void setStoreAnswers(boolean storeAnswers) {
        this.storeAnswers = storeAnswers;
    }

    public void setTempStorage(Map<QuestionPart, Answer> tempStorage) {
        this.tempStorage = tempStorage;
    }

    public void setMax(int max) {
        this.max = max;
    }
}

