/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.system;

import de.foellix.aql.config.ConfigHandler;
import de.foellix.aql.config.Priority;
import de.foellix.aql.config.Tool;
import de.foellix.aql.datastructure.Question;
import de.foellix.aql.datastructure.QuestionPart;
import de.foellix.aql.datastructure.Reference;
import de.foellix.aql.helper.EqualsHelper;
import java.util.ArrayList;
import java.util.List;

public class ToolSelector {
    private static ToolSelector instance = new ToolSelector();

    private ToolSelector() {
    }

    public static ToolSelector getInstance() {
        return instance;
    }

    public boolean detectInterApp(QuestionPart question) {
        boolean interApp = false;
        Reference firstReference = null;
        for (Reference reference : question.getAllReferences()) {
            if (firstReference == null) {
                firstReference = reference;
                continue;
            }
            if (EqualsHelper.equals(firstReference.getApp().getHashes(), reference.getApp().getHashes())) continue;
            interApp = true;
            break;
        }
        return interApp;
    }

    public Tool selectTool(QuestionPart question) {
        return this.selectTool(question, 0);
    }

    public Tool selectTool(QuestionPart question, int priority) {
        ArrayList<Tool> choices = new ArrayList<Tool>();
        if (!question.getAllReferences().isEmpty()) {
            for (Tool tool : ConfigHandler.getInstance().getConfig().getTools().getTool()) {
                if (question.getMode() == 0) {
                    boolean interApp = this.detectInterApp(question);
                    if (interApp) {
                        if (!tool.getQuestions().contains("InterAppFlows")) continue;
                        choices.add(tool);
                        continue;
                    }
                    if (!tool.getQuestions().contains("IntraAppFlows")) continue;
                    choices.add(tool);
                    continue;
                }
                if (question.getMode() == 1) {
                    if (!tool.getQuestions().contains("Permissions")) continue;
                    choices.add(tool);
                    continue;
                }
                if (question.getMode() == 3) {
                    if (!tool.getQuestions().contains("IntentFilters")) continue;
                    choices.add(tool);
                    continue;
                }
                if (question.getMode() == 2) {
                    if (!tool.getQuestions().contains("Intents")) continue;
                    choices.add(tool);
                    continue;
                }
                if (question.getMode() == 5) {
                    if (!tool.getQuestions().contains("IntentSinks")) continue;
                    choices.add(tool);
                    continue;
                }
                if (question.getMode() != 4 || !tool.getQuestions().contains("IntentSources")) continue;
                choices.add(tool);
            }
        }
        return this.selectChoice(choices, priority, question);
    }

    public Tool selectPreprocessor(QuestionPart question, String keyword) {
        return this.selectPreprocessor(question, keyword, 0);
    }

    public Tool selectPreprocessor(QuestionPart question, String keyword, int priority) {
        keyword = keyword.substring(1, keyword.length() - 1);
        ArrayList<Tool> choices = new ArrayList<Tool>();
        if (ConfigHandler.getInstance().getConfig().getPreprocessors() != null) {
            for (Tool preprocessor : ConfigHandler.getInstance().getConfig().getPreprocessors().getTool()) {
                if (!preprocessor.getQuestions().equals(keyword)) continue;
                choices.add(preprocessor);
            }
        }
        return this.selectChoice(choices, priority, question);
    }

    public Tool selectOperator(Question question) {
        return this.selectOperator(question, 0);
    }

    public Tool selectOperator(Question question, int priority) {
        ArrayList<Tool> choices = new ArrayList<Tool>();
        if (ConfigHandler.getInstance().getConfig().getOperators() != null) {
            for (Tool operator : ConfigHandler.getInstance().getConfig().getOperators().getTool()) {
                for (String splitStr : operator.getQuestions().replaceAll(" ", "").split(",")) {
                    if (!splitStr.equals(question.getOperator()) && (!splitStr.contains("(") || !splitStr.substring(0, splitStr.indexOf("(")).equals(question.getOperator()))) continue;
                    choices.add(operator);
                }
            }
        }
        return this.selectChoice(choices, priority, null);
    }

    private Tool selectChoice(List<Tool> choices, int priority, QuestionPart question) {
        if (choices.size() > 0) {
            Tool selectedChoice = null;
            int selectedPriority = -1;
            for (Tool choice : choices) {
                int newPriority = this.getPriority(choice, question);
                if (newPriority <= priority || selectedChoice != null && selectedPriority >= newPriority) continue;
                selectedChoice = choice;
                selectedPriority = newPriority;
            }
            return selectedChoice;
        }
        return null;
    }

    public int getPriority(Tool tool, QuestionPart question) {
        if (question != null) {
            if (question.getUses() != null && !question.getUses().isEmpty()) {
                for (String use : question.getUses()) {
                    if (!tool.getName().equals(use)) continue;
                    return ConfigHandler.getInstance().getMaxConfiguredPriority() + this.getPriorityByFeatures(tool, question);
                }
            } else if (question.getFeatures() != null && !question.getFeatures().isEmpty()) {
                return this.getPriorityByFeatures(tool, question);
            }
        }
        return this.getPriority(tool);
    }

    public int getPriorityByFeatures(Tool tool, QuestionPart question) {
        int priorityValue = this.getPriority(tool);
        for (Priority priority : tool.getPriority()) {
            if (!question.getFeatures().contains(priority.getFeature())) continue;
            priorityValue += priority.getValue();
        }
        return priorityValue;
    }

    public int getPriority(Tool tool) {
        for (Priority priority : tool.getPriority()) {
            if (priority.getFeature() != null) continue;
            return priority.getValue();
        }
        return 0;
    }
}

