/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.system.task;

import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import com.mashape.unirest.request.HttpRequestWithBody;
import com.mashape.unirest.request.body.MultipartBody;
import de.foellix.aql.Log;
import de.foellix.aql.datastructure.App;
import de.foellix.aql.helper.Helper;
import de.foellix.aql.system.Storage;
import de.foellix.aql.system.task.PreprocessorTaskInfo;
import de.foellix.aql.system.task.Task;
import de.foellix.aql.system.task.TaskAbortedBeforeException;
import de.foellix.aql.system.task.TaskInfo;
import de.foellix.aql.system.task.UnirestHandler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

public class PreprocessorTask {
    Task parent;
    private final PreprocessorTaskInfo taskinfo;
    private App preprocessedApp;

    PreprocessorTask(Task parent) {
        this.parent = parent;
        this.taskinfo = (PreprocessorTaskInfo)parent.getTaskinfo();
    }

    public void execute() throws Exception {
        this.init();
        if (this.preprocessedApp != null) {
            this.parent.getParent().preprocessingFinished(this.taskinfo, this.preprocessedApp);
            this.parent.successPart2(false);
        } else {
            Log.msg("Executing " + (this.taskinfo.getTool().isExternal() ? "external" : "internal") + " Preprocessor: " + this.taskinfo.getTool().getName() + " (" + Helper.getExecuteCommand(this.taskinfo) + ")", 0);
            if (this.taskinfo.getTool().isExternal()) {
                File result = this.getExternalPreprocessedApp();
                if (result != null) {
                    this.parent.successPart1(this.taskinfo.getTool().getName() + " successfully executed in %TIME%s. (" + Helper.getExecuteCommand(this.taskinfo) + ")");
                    this.finish(result);
                    this.parent.successPart2(true);
                    return;
                }
            } else {
                String[] runCmd = this.taskinfo.getTool().getExecute().getRun().split(" ");
                for (int i = 0; i < runCmd.length; ++i) {
                    runCmd[i] = Helper.replaceVariables(runCmd[i], (TaskInfo)this.taskinfo, this.taskinfo.getApp());
                }
                String path = Helper.replaceVariables(this.taskinfo.getTool().getPath(), (TaskInfo)this.taskinfo, this.taskinfo.getApp());
                if (this.parent.waitFor(runCmd, path) == 0) {
                    this.parent.successPart1(this.taskinfo.getTool().getName() + " successfully executed in %TIME%s. (" + Helper.getExecuteCommand(this.taskinfo) + ")");
                    File result = Helper.findFileWithAsterisk(new File(Helper.replaceVariables(this.taskinfo.getTool().getExecute().getResult(), (TaskInfo)this.taskinfo, this.taskinfo.getApp())));
                    Helper.waitForResult("Preprocessed app was not generated. " + this.taskinfo.getTool().getName() + " may have not finished properly.", result);
                    this.finish(result);
                    this.parent.successPart2(true);
                    return;
                }
            }
            this.parent.failed(this.taskinfo.getTool().getName() + " execution failed after %TIME%s! (" + Helper.getExecuteCommand(this.taskinfo) + ")");
        }
    }

    void abort(Exception err) {
        block7: {
            try {
                if (!this.parent.isExecuted()) {
                    Log.msg(this.taskinfo.getTool().getName() + " execution aborted " + (err instanceof TaskAbortedBeforeException ? "before " : "") + "after " + this.parent.getTime() + "s! (" + Helper.getExecuteCommand(this.taskinfo) + ")", 0);
                } else {
                    err.printStackTrace();
                    Log.msg(this.taskinfo.getTool().getName() + "'s result unavailable after " + this.parent.getTime() + "s because of the following error: " + err.getMessage(), 0);
                }
                if (Log.logIt(6)) {
                    err.printStackTrace();
                }
            }
            catch (NullPointerException e) {
                if (!this.parent.isExecuted()) {
                    Log.msg("Execution aborted!", 0);
                } else {
                    Log.msg("Result unavailable!" + (err.getMessage() != null ? " (" + err.getMessage() + ")" : ""), 0);
                }
                if (!Log.logIt(6)) break block7;
                e.printStackTrace();
            }
        }
    }

    private void init() {
        this.preprocessedApp = Storage.getInstance().load(this.taskinfo.getTool(), this.taskinfo.getApp());
    }

    private void finish(File result) {
        this.preprocessedApp = Helper.createApp(result);
        Storage.getInstance().store(this.taskinfo.getTool(), this.taskinfo.getApp(), this.preprocessedApp);
        this.parent.getParent().preprocessingFinished(this.taskinfo, this.preprocessedApp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getExternalPreprocessedApp() {
        File original = new File(this.taskinfo.getApp().getFile());
        try {
            UnirestHandler.getInstance().start(this.parent.getParent());
            HttpRequestWithBody request = Unirest.post(this.taskinfo.getTool().getExecute().getUrl() + "/" + this.taskinfo.getKeyword().substring(1, this.taskinfo.getKeyword().length() - 1)).header("accept", "application/vnd.android.package-archive");
            MultipartBody requestWithParameters = request.field("timeout", this.parent.getParent().getScheduler().getTimeout()).field("username", this.taskinfo.getTool().getExecute().getUsername()).field("password", this.taskinfo.getTool().getExecute().getPassword()).field("app", original);
            HttpResponse<InputStream> response = requestWithParameters.asBinary();
            File result = this.getPreprocessedFilename(original);
            try {
                Files.copy(response.getBody(), result.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                Log.error("Error while storing preprocessed file (" + result.getAbsolutePath() + "): " + e.getMessage());
                File file = null;
                UnirestHandler.getInstance().stop();
                return file;
            }
            File file = result;
            return file;
        }
        catch (UnirestException e) {
            Log.error("Error occured while accessing external perprocessor: " + e.getMessage());
            File file = null;
            return file;
        }
        finally {
            UnirestHandler.getInstance().stop();
        }
    }

    private File getPreprocessedFilename(File original) {
        File preprocessed = new File(original.getAbsolutePath().substring(0, original.getAbsolutePath().lastIndexOf(".")) + "_preprocessed-0.apk");
        return Helper.makeUnique(preprocessed);
    }
}

