/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.system.task;

import de.foellix.aql.Log;
import de.foellix.aql.helper.Helper;
import de.foellix.aql.system.System;
import de.foellix.aql.system.task.ExtraTask;
import de.foellix.aql.system.task.ITaskHook;
import de.foellix.aql.system.task.OperatorTask;
import de.foellix.aql.system.task.PreprocessorTask;
import de.foellix.aql.system.task.PreprocessorTaskInfo;
import de.foellix.aql.system.task.ProcessWrapper;
import de.foellix.aql.system.task.TaskAbortedBeforeException;
import de.foellix.aql.system.task.TaskInfo;
import de.foellix.aql.system.task.TaskMemory;
import de.foellix.aql.system.task.TaskStatus;
import de.foellix.aql.system.task.TaskTimer;
import de.foellix.aql.system.task.ToolTask;
import de.foellix.aql.system.task.ToolTaskInfo;
import java.io.File;
import java.util.List;

public class Task
extends Thread {
    private final System parent;
    private final TaskInfo taskinfo;
    private long start;
    private long time;
    private final long timeout;
    private boolean done;
    private boolean interrupted;
    private boolean executed;
    private Process process;
    private ProcessWrapper processWrapper;

    public Task(System parent, TaskInfo taskinfo, long timeout) {
        this.parent = parent;
        this.taskinfo = taskinfo;
        this.timeout = timeout;
        this.done = false;
        this.interrupted = false;
        this.executed = false;
    }

    @Override
    public void run() {
        try {
            if (TaskMemory.getInstance().contains(this)) {
                this.start = java.lang.System.currentTimeMillis() - this.timeout * 1000L;
                throw new TaskAbortedBeforeException("The associated task has been aborted before.");
            }
            if (this.timeout > 0L) {
                new TaskTimer(this, this.timeout).start();
            }
            this.start = java.lang.System.currentTimeMillis();
            this.executeTaskHooks(true);
            new ExtraTask(this.taskinfo, TaskStatus.STATUS_ENTRY).runAndWait();
            if (this.taskinfo instanceof ToolTaskInfo) {
                new ToolTask(this).execute();
            } else if (this.taskinfo instanceof PreprocessorTaskInfo) {
                new PreprocessorTask(this).execute();
            } else {
                new OperatorTask(this).execute();
            }
            this.executeTaskHooks(false);
        }
        catch (Exception err) {
            this.time = Math.max(1L, (java.lang.System.currentTimeMillis() - this.start) / 1000L);
            TaskMemory.getInstance().aborted(this);
            if (this.taskinfo instanceof ToolTaskInfo) {
                new ToolTask(this).abort(err);
            } else if (this.taskinfo instanceof PreprocessorTaskInfo) {
                new PreprocessorTask(this).abort(err);
            } else {
                new OperatorTask(this).abort(err);
            }
            this.parent.getScheduler().finishedTask(this, this.taskinfo, TaskStatus.STATUS_ABORT);
        }
        finally {
            this.done = true;
        }
    }

    @Override
    public void interrupt() {
        if (this.process != null) {
            this.interrupted = true;
            new ExtraTask(this.taskinfo, TaskStatus.STATUS_ABORT).runAndWait();
            if (this.process.isAlive()) {
                this.process.destroy();
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    Log.error("Someting went wrong while killing processes: " + e.getMessage());
                }
                if (this.process.isAlive()) {
                    this.process.destroyForcibly();
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        Log.error("Someting went wrong while killing processes: " + e.getMessage());
                    }
                }
            }
        }
        super.interrupt();
    }

    public int waitFor(String[] runCmd, String path) throws Exception {
        this.process = new ProcessBuilder(runCmd).directory(new File(path)).start();
        this.taskinfo.setPID(Helper.getPid(this.process));
        this.processWrapper = new ProcessWrapper(this.process);
        return this.processWrapper.waitFor();
    }

    public void successPart1(String msg) {
        Log.msg(this.replaceTime(msg), 0);
        this.executed = true;
    }

    public void successPart2(boolean wait) throws InterruptedException {
        if (wait && !this.taskinfo.getTool().isExternal() && this.taskinfo.getTool().getExecute().getInstances() == 1) {
            Thread.sleep(1000L);
        }
        new ExtraTask(this.taskinfo, TaskStatus.STATUS_SUCCESS).runAndWait();
        this.getParent().getScheduler().finishedTask(this, this.taskinfo, TaskStatus.STATUS_SUCCESS);
    }

    public void failed(String msg) throws InterruptedException {
        if (this.interrupted) {
            Log.msg("Task was interrupted!", 5);
        }
        Log.msg(this.replaceTime(msg), 0);
        new ExtraTask(this.taskinfo, TaskStatus.STATUS_FAIL).runAndWait();
        this.parent.getScheduler().finishedTask(this, this.taskinfo, TaskStatus.STATUS_FAIL);
    }

    private void executeTaskHooks(boolean before) {
        List<ITaskHook> hooks = before ? this.parent.getTaskHooksBefore().getHooks().get(this.taskinfo.getTool()) : this.parent.getTaskHooksAfter().getHooks().get(this.taskinfo.getTool());
        if (hooks != null) {
            for (ITaskHook hook : hooks) {
                try {
                    hook.execute(this.taskinfo);
                }
                catch (Exception e) {
                    Log.warning("Something went wrong while executing hook (" + e.getClass().getName() + "): " + e.getMessage());
                }
            }
        }
    }

    private String replaceTime(String msg) {
        this.time = Math.max(1L, (java.lang.System.currentTimeMillis() - this.start) / 1000L);
        return msg.replaceAll("%TIME%", String.valueOf(this.time));
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Task other = (Task)obj;
        if (this.parent == null ? other.parent != null : !this.parent.equals(other.parent)) {
            return false;
        }
        if (this.taskinfo == null ? other.taskinfo != null : !this.taskinfo.equals(other.taskinfo)) {
            return false;
        }
        return this.timeout == other.timeout;
    }

    public System getParent() {
        return this.parent;
    }

    public TaskInfo getTaskinfo() {
        return this.taskinfo;
    }

    public long getTime() {
        return this.time;
    }

    public Process getProcess() {
        return this.process;
    }

    public boolean isExecuted() {
        return this.executed;
    }

    public boolean isDone() {
        return this.done;
    }
}

