/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.system.task;

import de.foellix.aql.helper.Helper;
import de.foellix.aql.system.task.PreprocessorTaskInfo;
import de.foellix.aql.system.task.Task;
import de.foellix.aql.system.task.TaskInfo;
import de.foellix.aql.system.task.ToolTaskInfo;
import java.util.ArrayList;
import java.util.List;

public class TaskMemory {
    private static TaskMemory instance = new TaskMemory();
    private final List<String> abortedTasks = new ArrayList<String>();

    private TaskMemory() {
    }

    public static TaskMemory getInstance() {
        return instance;
    }

    public boolean contains(Task task) {
        return this.abortedTasks.contains(this.taskToString(task));
    }

    public void aborted(Task task) {
        String entry;
        try {
            entry = this.taskToString(task);
        }
        catch (Exception e) {
            return;
        }
        this.abortedTasks.add(entry);
    }

    private String taskToString(Task task) {
        TaskInfo taskinfo = task.getTaskinfo();
        if (taskinfo instanceof ToolTaskInfo) {
            ToolTaskInfo t = (ToolTaskInfo)taskinfo;
            return Helper.getExecuteCommand(t) + "; " + task.getParent().getScheduler().getTimeout();
        }
        if (taskinfo instanceof PreprocessorTaskInfo) {
            PreprocessorTaskInfo t = (PreprocessorTaskInfo)taskinfo;
            return Helper.getExecuteCommand(t) + "; " + task.getParent().getScheduler().getTimeout();
        }
        return null;
    }
}

