/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.system.task;

import de.foellix.aql.Log;
import de.foellix.aql.system.task.Task;

public class TaskTimer
extends Thread {
    private final Task parent;
    private final long timeout;

    public TaskTimer(Task parent, long timeout) {
        this.parent = parent;
        this.timeout = timeout;
    }

    @Override
    public void run() {
        long start = System.currentTimeMillis();
        while (start + this.timeout * 1000L > System.currentTimeMillis()) {
            try {
                Thread.sleep(500L);
            }
            catch (InterruptedException e) {
                Log.msg("Timer stopped: " + e.getMessage(), 6);
                return;
            }
            if (!this.parent.isDone()) continue;
            return;
        }
        Log.msg("Timeout-Timer expired! (" + this.parent.getTaskinfo().getTool().getName() + ")", 4);
        this.parent.interrupt();
    }
}

