/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.system.task;

import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import com.mashape.unirest.http.exceptions.UnirestException;
import com.mashape.unirest.request.HttpRequestWithBody;
import com.mashape.unirest.request.body.MultipartBody;
import de.foellix.aql.Log;
import de.foellix.aql.converter.ConverterRegistry;
import de.foellix.aql.converter.IConverter;
import de.foellix.aql.converter.NoConverter;
import de.foellix.aql.datastructure.Answer;
import de.foellix.aql.datastructure.App;
import de.foellix.aql.datastructure.IQuestionNode;
import de.foellix.aql.datastructure.handler.AnswerHandler;
import de.foellix.aql.datastructure.handler.QueryHandler;
import de.foellix.aql.helper.Helper;
import de.foellix.aql.system.Storage;
import de.foellix.aql.system.task.Task;
import de.foellix.aql.system.task.TaskAbortedBeforeException;
import de.foellix.aql.system.task.TaskInfo;
import de.foellix.aql.system.task.ToolTaskInfo;
import de.foellix.aql.system.task.UnirestHandler;
import java.io.File;
import java.util.ArrayList;

public class ToolTask {
    Task parent;
    private final ToolTaskInfo taskinfo;
    private Answer answer;

    ToolTask(Task parent) {
        this.parent = parent;
        this.taskinfo = (ToolTaskInfo)parent.getTaskinfo();
    }

    public void execute() throws Exception {
        this.init();
        if (this.answer != null) {
            this.parent.getParent().localAnswerAvailable(this.taskinfo.getQuestion(), this.answer);
            this.parent.successPart2(false);
        } else {
            Log.msg("Executing " + (this.taskinfo.getTool().isExternal() ? "external" : "internal") + " Tool: " + this.taskinfo.getTool().getName() + " (" + Helper.getExecuteCommand(this.taskinfo) + ")", 0);
            if (this.taskinfo.getTool().isExternal()) {
                this.answer = this.getExternalAnswer();
                if (this.answer != null) {
                    this.parent.successPart1(this.taskinfo.getTool().getName() + " successfully executed in %TIME%s. (" + Helper.getExecuteCommand(this.taskinfo) + ")");
                    this.finish();
                    this.parent.successPart2(true);
                    return;
                }
            } else {
                String[] runCmd = this.taskinfo.getTool().getExecute().getRun().split(" ");
                for (int i = 0; i < runCmd.length; ++i) {
                    runCmd[i] = Helper.replaceVariables(runCmd[i], (TaskInfo)this.taskinfo, this.taskinfo.getQuestion());
                }
                String path = Helper.replaceVariables(this.taskinfo.getTool().getPath(), (TaskInfo)this.taskinfo, this.taskinfo.getQuestion());
                if (this.parent.waitFor(runCmd, path) == 0) {
                    this.parent.successPart1(this.taskinfo.getTool().getName() + " successfully executed in %TIME%s. (" + Helper.getExecuteCommand(this.taskinfo) + ")");
                    File result = Helper.findFileWithAsterisk(new File(Helper.replaceVariables(this.taskinfo.getTool().getExecute().getResult(), (TaskInfo)this.taskinfo, this.taskinfo.getQuestion())));
                    Helper.waitForResult("Result file was not generated. " + this.taskinfo.getTool().getName() + " may have not finished properly.", result);
                    this.applyConverter(result);
                    this.finish();
                    this.parent.successPart2(true);
                    return;
                }
            }
            this.parent.failed(this.taskinfo.getTool().getName() + " execution failed after %TIME%s! (" + Helper.getExecuteCommand(this.taskinfo) + ")");
        }
    }

    void abort(Exception err) {
        block7: {
            try {
                if (!this.parent.isExecuted()) {
                    Log.msg(this.taskinfo.getTool().getName() + " execution aborted " + (err instanceof TaskAbortedBeforeException ? "before " : "") + "after " + this.parent.getTime() + "s! (" + Helper.getExecuteCommand(this.taskinfo) + ")", 0);
                } else {
                    Log.msg(this.taskinfo.getTool().getName() + "'s result conversion failed after " + this.parent.getTime() + "s with the following error: " + err.getMessage(), 0);
                }
                if (Log.logIt(6)) {
                    err.printStackTrace();
                }
            }
            catch (NullPointerException e) {
                if (!this.parent.isExecuted()) {
                    Log.msg("Execution aborted!", 0);
                    err.printStackTrace();
                } else {
                    Log.msg("Result conversion failed!" + (err.getMessage() != null ? " (" + err.getMessage() + ")" : ""), 0);
                }
                if (!Log.logIt(6)) break block7;
                e.printStackTrace();
            }
        }
    }

    private void init() {
        this.answer = Storage.getInstance().load(this.taskinfo.getTool(), this.taskinfo.getQuestion(), this.parent.getParent().getScheduler().isAlwaysPreferLoading());
    }

    private void applyConverter(File result) throws Exception {
        IConverter converter = ConverterRegistry.getInstance().getConverter(this.taskinfo.getTool());
        if (converter instanceof NoConverter) {
            Log.msg("No converter found for: " + this.taskinfo.getTool().getName(), 5);
        }
        this.answer = converter.parse(result, this.taskinfo);
    }

    private void finish() {
        Storage.getInstance().store(this.taskinfo.getTool(), this.taskinfo.getQuestion(), this.answer);
        this.parent.getParent().localAnswerAvailable(this.taskinfo.getQuestion(), this.answer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Answer getExternalAnswer() {
        String query = this.taskinfo.getQuestion().toString();
        try {
            UnirestHandler.getInstance().start(this.parent.getParent());
            HttpRequestWithBody request = Unirest.post(this.taskinfo.getTool().getExecute().getUrl()).header("accept", "text/xml");
            IQuestionNode parsedQuery = QueryHandler.parseQuery(query);
            ArrayList<File> files = new ArrayList<File>();
            for (App app : parsedQuery.getAllApps(false)) {
                String allFiles = app.getFile();
                for (String file : allFiles.replaceAll(", ", ",").split(",")) {
                    files.add(new File(file));
                }
            }
            query = this.replaceFilesInQuery(parsedQuery);
            MultipartBody requestWithParameters = request.field("query", query).field("timeout", this.parent.getParent().getScheduler().getTimeout()).field("username", this.taskinfo.getTool().getExecute().getUsername()).field("password", this.taskinfo.getTool().getExecute().getPassword()).field("files", files);
            HttpResponse<String> response = requestWithParameters.asString();
            Answer answer = AnswerHandler.parseXML(response.getBody());
            return answer;
        }
        catch (UnirestException e) {
            Log.error("Error occured while accessing external tool: " + e.getMessage());
            Answer answer = null;
            return answer;
        }
        finally {
            UnirestHandler.getInstance().stop();
        }
    }

    private String replaceFilesInQuery(IQuestionNode parsedQuery) {
        parsedQuery = QueryHandler.replaceWithAbsolutePaths(parsedQuery);
        String returnQuery = parsedQuery.toString();
        int i = 0;
        for (App app : parsedQuery.getAllApps(false)) {
            String allFiles = app.getFile();
            for (String file : allFiles.replaceAll(", ", ",").split(",")) {
                returnQuery = returnQuery.replaceAll(file, "%FILE_" + ++i + "%");
            }
        }
        return returnQuery;
    }
}

