/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.system.task;

import com.mashape.unirest.http.Unirest;
import de.foellix.aql.Log;
import de.foellix.aql.system.System;
import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class UnirestHandler {
    private static UnirestHandler instance = new UnirestHandler();
    private final Lock lock = new ReentrantLock();
    private int counter;

    private UnirestHandler() {
    }

    public static UnirestHandler getInstance() {
        return instance;
    }

    public void start(System aqlSystem) {
        long timeoutConverted = aqlSystem.getScheduler().getTimeout() == -1L ? Long.MAX_VALUE : aqlSystem.getScheduler().getTimeout() * 1000L + 10000L;
        Unirest.setTimeouts(10000L, timeoutConverted);
    }

    public synchronized void stop() {
        this.lock.lock();
        --this.counter;
        if (this.counter == 0) {
            try {
                Unirest.shutdown();
            }
            catch (IOException e) {
                Log.warning("Could not close connection to external tool: " + e.getMessage());
            }
        }
        this.lock.unlock();
    }
}

