/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.ui.cli;

import de.foellix.aql.Log;
import de.foellix.aql.Properties;
import de.foellix.aql.config.ConfigHandler;
import de.foellix.aql.helper.ManpageReader;
import de.foellix.aql.system.BackupAndReset;
import de.foellix.aql.ui.cli.OutputWriter;
import de.foellix.aql.ui.gui.GUI;
import java.io.File;
import javafx.application.Application;
import org.fusesource.jansi.Ansi;
import org.fusesource.jansi.AnsiConsole;

public class CommandLineInterface {
    private static String config = null;
    private static String output = null;
    private static String query = null;
    private static String debug = null;
    private static long timeout = -1L;
    private static boolean gui = false;
    private static boolean cw = false;
    private static boolean alwaysPreferLoading = true;

    public static void main(String[] args) {
        AnsiConsole.systemInstall();
        String authorStr = "Author: " + Properties.info().AUTHOR + " (" + Properties.info().AUTHOR_EMAIL + ")";
        String space = "                 ".substring(Math.min(Properties.info().VERSION.length() + 3, 17));
        String centerspace = "                               ".substring(Math.min(32, authorStr.length() / 2));
        Log.msg(Ansi.ansi().bold().fg(Ansi.Color.GREEN).a("           ____  _          _____           _" + space).reset().a("v. " + Properties.info().VERSION).bold().fg(Ansi.Color.GREEN).a("\r\n     /\\   / __ \\| |        / ____|         | |                \r\n    /  \\ | |  | | |  _____| (___  _   _ ___| |_ ___ _ __ ___  \r\n   / /\\ \\| |  | | | |______\\___ \\| | | / __| __/ _ \\ '_ ` _ \\ \r\n  / ____ \\ |__| | |____    ____) | |_| \\__ \\ ||  __/ | | | | |\r\n /_/    \\_\\___\\_\\______|  |_____/ \\__, |___/\\__\\___|_| |_| |_|\r\n                                   __/ |                      \r\n                                  |___/                       \r\n").reset().a("\r\n" + centerspace + authorStr + "\r\n\r\n"), 4);
        if (args == null) {
            CommandLineInterface.help();
            return;
        }
        for (String arg : args) {
            if (!arg.equals("-help") && !arg.equals("-h") && !arg.equals("-?") && !arg.equals("-man") && !arg.equals("-manpage")) continue;
            CommandLineInterface.help();
            return;
        }
        if (args == null || args.length == 0) {
            gui = true;
        } else {
            int i;
            for (i = 0; i < args.length; ++i) {
                if (!args[i].equals("-backup") && !args[i].equals("-b")) continue;
                BackupAndReset.backup();
            }
            for (i = 0; i < args.length; ++i) {
                if (args[i].equals("-gui")) {
                    gui = true;
                    continue;
                }
                if (args[i].equals("-cw") || args[i].equals("-configwizard")) {
                    gui = true;
                    cw = true;
                    continue;
                }
                if (args[i].equals("-pe") || args[i].equals("-preferexecute")) {
                    alwaysPreferLoading = false;
                    continue;
                }
                if (args[i].equals("-backup") || args[i].equals("-b")) continue;
                if (args[i].equals("-reset") || args[i].equals("-re") || args[i].equals("-r")) {
                    BackupAndReset.reset();
                    continue;
                }
                if (args[i].equals("-c") || args[i].equals("-cfg") || args[i].equals("-config")) {
                    config = args[i + 1];
                } else if (args[i].equals("-o") || args[i].equals("-out") || args[i].equals("-output")) {
                    output = args[i + 1];
                } else if (args[i].equals("-q") || args[i].equals("-query")) {
                    query = args[i + 1];
                } else if (args[i].equals("-d") || args[i].equals("-debug")) {
                    debug = args[i + 1];
                } else if (args[i].equals("-t") || args[i].equals("-timeout")) {
                    String readTimeout = args[i + 1];
                    timeout = readTimeout.contains("h") ? (long)(Integer.parseInt(readTimeout.replaceAll("h", "")) * 3600) : (readTimeout.contains("m") ? (long)(Integer.parseInt(readTimeout.replaceAll("m", "")) * 60) : (long)Integer.parseInt(readTimeout.replaceAll("s", "")));
                } else {
                    System.exit(0);
                }
                ++i;
            }
        }
        if (debug != null) {
            if (debug.equals("normal")) {
                Log.setLogLevel(4);
            } else if (debug.equals("short")) {
                Log.setLogLevel(4);
                Log.setShorten(true);
            } else if (debug.equals("warning")) {
                Log.setLogLevel(3);
            } else if (debug.equals("error")) {
                Log.setLogLevel(1);
            } else if (debug.equals("debug")) {
                Log.setLogLevel(5);
            } else if (debug.equals("detailed")) {
                Log.setLogLevel(6);
            } else if (debug.equals("special")) {
                Log.setLogLevel(2);
            } else {
                Log.setLogLevel(Integer.valueOf(debug));
            }
        }
        if (config != null) {
            File configFile = new File(config);
            if (config != null && configFile.exists()) {
                ConfigHandler.getInstance().setConfig(configFile);
            } else {
                Log.warning("Configuration file does not exist: " + configFile.getAbsolutePath());
            }
        }
        if (!gui) {
            de.foellix.aql.system.System aqlSystem = new de.foellix.aql.system.System();
            aqlSystem.getScheduler().setAlwaysPreferLoading(alwaysPreferLoading);
            aqlSystem.getScheduler().setTimeout(timeout);
            if (output != null) {
                aqlSystem.getAnswerReceivers().add(new OutputWriter(new File(output)));
            }
            if (query != null) {
                aqlSystem.query(query);
            } else {
                Log.error("Please specify a query (e.g. -q \"Flows IN App('path/to/file.apk') ?\")");
            }
        } else {
            GUI.alwaysPreferLoading = alwaysPreferLoading;
            GUI.timeout = timeout;
            GUI.showConfigWizard = cw;
            if (query != null) {
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            while (!GUI.started) {
                                1.sleep(100L);
                            }
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        GUI.editor.setContent(query);
                    }
                }.start();
            }
            Application.launch(GUI.class, (String[])args);
        }
    }

    private static void help() {
        Log.msg(ManpageReader.getInstance().getManpageContent(), 4);
    }
}

