/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.ui.gui;

import de.foellix.aql.Log;
import de.foellix.aql.Properties;
import de.foellix.aql.config.ConfigHandler;
import de.foellix.aql.config.wizard.ConfigWizard;
import de.foellix.aql.datastructure.Answer;
import de.foellix.aql.datastructure.handler.AnswerHandler;
import de.foellix.aql.ui.gui.BottomViewer;
import de.foellix.aql.ui.gui.Editor;
import de.foellix.aql.ui.gui.ExitDialog;
import de.foellix.aql.ui.gui.IGUI;
import de.foellix.aql.ui.gui.SplashScreen;
import de.foellix.aql.ui.gui.Storage;
import de.foellix.aql.ui.gui.Viewer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.TransferMode;
import javafx.scene.paint.Color;
import javafx.stage.FileChooser;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;

public class GUI
extends Application
implements IGUI {
    public static Stage stage;
    public de.foellix.aql.system.System system = new de.foellix.aql.system.System();
    public static Editor editor;
    public static Viewer viewer;
    private FileChooser openDialog;
    private FileChooser saveDialog;
    private FileChooser.ExtensionFilter allFilter;
    private FileChooser.ExtensionFilter aqlFilter;
    private FileChooser.ExtensionFilter xmlFilter;
    private FileChooser.ExtensionFilter pngFilter;
    private File currentQuery;
    private File currentAnswer;
    private File currentExport;
    public static boolean viewerActive;
    public static boolean started;
    public static boolean alwaysPreferLoading;
    public static long timeout;
    public static boolean showConfigWizard;
    private long time;

    public GUI() {
        this.system.getScheduler().setAlwaysPreferLoading(alwaysPreferLoading);
        this.system.getScheduler().setTimeout(timeout);
    }

    public void start(Stage stage) throws Exception {
        this.time = System.currentTimeMillis();
        GUI.stage = stage;
        stage.setTitle("AQL-Editor");
        stage.getIcons().add((Object)new Image("file:data/gui/images/icon_16.png", 16.0, 16.0, false, true));
        stage.getIcons().add((Object)new Image("file:data/gui/images/icon_32.png", 32.0, 32.0, false, true));
        stage.getIcons().add((Object)new Image("file:data/gui/images/icon_64.png", 64.0, 64.0, false, true));
        editor = new Editor(this);
        viewer = new Viewer(this);
        TabPane tabPane = new TabPane();
        Tab tabEditor = new Tab("Editor");
        tabEditor.setOnSelectionChanged((EventHandler)new EventHandler<Event>(){

            public void handle(Event event) {
                viewerActive = false;
                GUI.this.adjustTitle();
            }
        });
        tabEditor.setGraphic((Node)new ImageView(new Image("file:data/gui/images/editor_icon_32.png", 32.0, 32.0, false, true)));
        tabEditor.setContent((Node)editor);
        tabEditor.setClosable(false);
        Tab tabViewer = new Tab("Viewer");
        tabViewer.setOnSelectionChanged((EventHandler)new EventHandler<Event>(){

            public void handle(Event event) {
                viewerActive = true;
                GUI.this.adjustTitle();
            }
        });
        tabViewer.setGraphic((Node)new ImageView(new Image("file:data/gui/images/viewer_icon_32.png", 32.0, 32.0, false, true)));
        tabViewer.setContent((Node)viewer);
        tabViewer.setClosable(false);
        tabPane.getTabs().addAll((Object[])new Tab[]{tabEditor, tabViewer});
        Scene scene = new Scene((Parent)tabPane, 1024.0, 768.0);
        scene.getStylesheets().add((Object)"file:data/gui/style.css");
        scene.getStylesheets().add((Object)"file:data/gui/keywords.css");
        scene.getStylesheets().add((Object)"file:data/gui/xml_highlighting.css");
        stage.setScene(scene);
        stage.maximizedProperty().addListener((ChangeListener)new ChangeListener<Boolean>(){

            public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
                GUI.viewer.viewerGraph.refresh();
            }
        });
        scene.widthProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observableValue, Number oldSceneWidth, Number newSceneWidth) {
                GUI.viewer.viewerGraph.refresh();
            }
        });
        scene.heightProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observableValue, Number oldSceneHeight, Number newSceneHeight) {
                GUI.viewer.viewerGraph.refresh();
            }
        });
        stage.setOnCloseRequest((EventHandler)new EventHandler<WindowEvent>(){

            public void handle(WindowEvent we) {
                we.consume();
                GUI.this.exit();
            }
        });
        this.openDialog = new FileChooser();
        this.saveDialog = new FileChooser();
        this.allFilter = new FileChooser.ExtensionFilter("*.* All files", new String[]{"*.*"});
        this.aqlFilter = new FileChooser.ExtensionFilter("*.aql AQL-Query", new String[]{"*.aql"});
        this.xmlFilter = new FileChooser.ExtensionFilter("*.xml AQL-Answer", new String[]{"*.xml"});
        this.pngFilter = new FileChooser.ExtensionFilter("*.png Image files", new String[]{"*.png"});
        started = true;
        scene.setOnDragOver((EventHandler)new EventHandler<DragEvent>(){

            public void handle(DragEvent event) {
                Dragboard db = event.getDragboard();
                if (db.hasFiles()) {
                    event.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
                } else {
                    event.consume();
                }
            }
        });
        scene.setOnDragDropped((EventHandler)new EventHandler<DragEvent>(){

            public void handle(DragEvent event) {
                Dragboard db = event.getDragboard();
                boolean success = false;
                if (db.hasFiles()) {
                    success = true;
                    if (viewerActive) {
                        GUI.this.openFile((File)db.getFiles().get(0));
                    } else if (((File)db.getFiles().get(0)).getName().endsWith(".aql")) {
                        GUI.this.openFile((File)db.getFiles().get(0));
                    } else {
                        StringBuilder sb = new StringBuilder();
                        for (int i = 0; i < db.getFiles().size(); ++i) {
                            File file = (File)db.getFiles().get(i);
                            sb.append((i == 0 ? "" : " ") + file.getAbsolutePath());
                        }
                        editor.insert(sb.toString());
                    }
                }
                event.setDropCompleted(success);
                event.consume();
            }
        });
        GUI.viewer.viewerWeb.getWebView().setOnDragOver(scene.getOnDragOver());
        GUI.viewer.viewerWeb.getWebView().setOnDragDropped(scene.getOnDragDropped());
        Platform.runLater(() -> {
            scene.getAccelerators().put((Object)new KeyCodeCombination(KeyCode.NUMPAD0, new KeyCombination.Modifier[]{KeyCombination.CONTROL_ANY}), (Object)new Runnable(){

                @Override
                public void run() {
                    viewer.zoomReset();
                }
            });
            scene.getAccelerators().put((Object)new KeyCodeCombination(KeyCode.ADD, new KeyCombination.Modifier[]{KeyCombination.CONTROL_ANY}), (Object)new Runnable(){

                @Override
                public void run() {
                    viewer.zoomIn();
                }
            });
            scene.getAccelerators().put((Object)new KeyCodeCombination(KeyCode.SUBTRACT, new KeyCombination.Modifier[]{KeyCombination.CONTROL_ANY}), (Object)new Runnable(){

                @Override
                public void run() {
                    viewer.zoomOut();
                }
            });
        });
        SplashScreen splashScreen = new SplashScreen(Properties.info().ABBREVIATION + " (v. " + Properties.info().VERSION + ")", "by " + Properties.info().AUTHOR, Color.WHITE);
        new Thread(() -> {
            try {
                this.time = System.currentTimeMillis() - this.time;
                if (this.time < 2000L) {
                    Thread.sleep(2000L - this.time);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            Platform.runLater(() -> {
                splashScreen.setDone(true);
                if (!showConfigWizard) {
                    stage.show();
                    ConfigHandler.getInstance().getConfig();
                } else {
                    new ConfigWizard(stage, ConfigHandler.getInstance().getConfigFile());
                }
            });
        }).start();
    }

    @Override
    public void newFile() {
        if (!viewerActive) {
            editor.resetContent();
            this.currentQuery = null;
        } else {
            viewer.resetContent();
            this.currentAnswer = null;
        }
    }

    @Override
    public void open() {
        this.openDialog.getExtensionFilters().clear();
        if (!viewerActive) {
            this.openDialog.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{this.allFilter, this.aqlFilter});
            this.openDialog.setSelectedExtensionFilter(this.aqlFilter);
            if (this.currentQuery != null) {
                this.openDialog.setInitialDirectory(this.currentQuery.getParentFile());
            } else {
                this.openDialog.setInitialDirectory(new File("queries"));
            }
        } else {
            this.openDialog.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{this.allFilter, this.xmlFilter});
            this.openDialog.setSelectedExtensionFilter(this.xmlFilter);
            if (this.currentAnswer != null) {
                this.openDialog.setInitialDirectory(this.currentAnswer.getParentFile());
            } else {
                this.openDialog.setInitialDirectory(new File("answers"));
            }
        }
        this.openFile(this.openDialog.showOpenDialog((Window)this.getStage()));
    }

    private void openFile(File file) {
        if (file != null) {
            try {
                if (!viewerActive) {
                    editor.openFile(file);
                    this.currentQuery = file;
                } else {
                    viewer.openFile(file);
                    this.currentAnswer = file;
                }
            }
            catch (FileNotFoundException e) {
                Log.msg("File not found: " + file.toString(), 1);
            }
            catch (Exception e) {
                Log.msg("Error occurred while opening file: " + file.toString() + " (" + e.getClass().getSimpleName() + ": " + e.getMessage() + ")", 1);
            }
        }
        this.adjustTitle();
    }

    @Override
    public void saveAs() {
        this.saveDialog.getExtensionFilters().clear();
        if (!viewerActive) {
            this.saveDialog.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{this.allFilter, this.aqlFilter});
            this.saveDialog.setSelectedExtensionFilter(this.aqlFilter);
            if (this.currentQuery != null) {
                this.saveDialog.setInitialDirectory(this.currentQuery.getParentFile());
            } else {
                this.saveDialog.setInitialDirectory(new File("queries"));
            }
            this.currentQuery = this.saveDialog.showSaveDialog((Window)this.getStage());
            if (this.currentQuery != null) {
                this.save();
            }
        } else {
            this.saveDialog.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{this.allFilter, this.xmlFilter});
            this.saveDialog.setSelectedExtensionFilter(this.xmlFilter);
            if (this.currentAnswer != null) {
                this.saveDialog.setInitialDirectory(this.currentAnswer.getParentFile());
            } else {
                this.saveDialog.setInitialDirectory(new File("answers"));
            }
            this.currentAnswer = this.saveDialog.showSaveDialog((Window)this.getStage());
            if (this.currentAnswer != null) {
                this.save();
            }
        }
    }

    @Override
    public void save() {
        if (!viewerActive) {
            if (this.currentQuery == null) {
                this.saveAs();
            } else {
                this.save(this.currentQuery);
            }
        } else if (this.currentAnswer == null) {
            this.saveAs();
        } else {
            this.save(this.currentAnswer);
        }
    }

    private void save(File file) {
        if (!viewerActive) {
            try {
                file.delete();
                Files.write(Paths.get(file.toURI()), editor.getContent().getBytes(), StandardOpenOption.CREATE_NEW);
                Storage.getInstance().store(file, false);
            }
            catch (IOException e) {
                Log.msg("Could not write file: " + file.getAbsolutePath() + " (" + e.getMessage() + ")", 1);
            }
        } else {
            Answer temp = AnswerHandler.parseXML(GUI.viewer.viewerXML.getContent());
            if (temp == null) {
                temp = new Answer();
            }
            AnswerHandler.createXML(temp, file);
            Storage.getInstance().store(file, true);
            ((BottomViewer)viewer.getBottom()).refresh();
        }
        this.adjustTitle();
    }

    @Override
    public void exit() {
        new ExitDialog("Exit", "You will exit the " + Properties.info().ABBREVIATION + " now.", "Proceed?");
    }

    public void exportGraph() {
        this.saveDialog.getExtensionFilters().clear();
        this.saveDialog.getExtensionFilters().addAll((Object[])new FileChooser.ExtensionFilter[]{this.allFilter, this.pngFilter});
        this.saveDialog.setSelectedExtensionFilter(this.pngFilter);
        if (this.currentExport != null) {
            this.saveDialog.setInitialDirectory(this.currentExport.getParentFile());
        } else {
            this.saveDialog.setInitialDirectory(new File("./"));
        }
        this.currentExport = this.saveDialog.showSaveDialog((Window)this.getStage());
        if (this.currentExport != null) {
            GUI.viewer.viewerGraph.exportGraph(this.currentExport);
        }
    }

    private void adjustTitle() {
        Platform.runLater(() -> {
            if (viewerActive) {
                if (this.currentAnswer == null) {
                    this.getStage().setTitle("AQL-Viewer");
                } else {
                    this.getStage().setTitle("AQL-Viewer (" + this.currentAnswer.getAbsolutePath() + ")");
                }
            } else if (this.currentQuery == null) {
                this.getStage().setTitle("AQL-Editor");
            } else {
                this.getStage().setTitle("AQL-Editor (" + this.currentQuery.getAbsolutePath() + ")");
            }
        });
    }

    @Override
    public Stage getStage() {
        return stage;
    }

    @Override
    public de.foellix.aql.system.System getSystem() {
        return this.system;
    }

    static {
        viewerActive = false;
        started = false;
        alwaysPreferLoading = true;
        timeout = -1L;
        showConfigWizard = false;
    }
}

