/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.ui.gui;

import de.foellix.aql.Log;
import de.foellix.aql.Properties;
import de.foellix.aql.config.ConfigHandler;
import de.foellix.aql.config.wizard.ConfigWizard;
import de.foellix.aql.ui.gui.FontAwesome;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.control.Alert;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.image.Image;
import javafx.stage.Stage;

public class MenuHelp
extends Menu {
    private final MenuItem menuItemConfigWizard = FontAwesome.getInstance().createMenuItem("\uf0d0", "ConfigWizard");
    private final SeparatorMenuItem separator;

    public MenuHelp(final Stage stage) {
        super("Help");
        this.menuItemConfigWizard.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                new ConfigWizard(stage, ConfigHandler.getInstance().getConfigFile()).show();
            }
        });
        this.separator = new SeparatorMenuItem();
        MenuItem menuItemManual = FontAwesome.getInstance().createMenuItem("\uf1c1", "Manual");
        menuItemManual.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                if (Desktop.isDesktopSupported()) {
                    try {
                        File myFile = new File("manual.pdf");
                        Desktop.getDesktop().open(myFile);
                    }
                    catch (IOException ex) {
                        Log.error("Could not access manual.pdf or PDF Viewer.");
                    }
                }
            }
        });
        MenuItem menuItemInfo = FontAwesome.getInstance().createMenuItem("\uf05a", "Info");
        menuItemInfo.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Alert alert = new Alert(Alert.AlertType.INFORMATION);
                Stage alertStage = (Stage)alert.getDialogPane().getScene().getWindow();
                alertStage.getIcons().add((Object)new Image("file:data/gui/images/icon_16.png", 16.0, 16.0, false, true));
                alertStage.getIcons().add((Object)new Image("file:data/gui/images/icon_32.png", 32.0, 32.0, false, true));
                alertStage.getIcons().add((Object)new Image("file:data/gui/images/icon_64.png", 64.0, 64.0, false, true));
                alert.setTitle("Information");
                alert.setHeaderText(Properties.info().ABBREVIATION + "\n" + Properties.info().NAME);
                alert.setContentText("Version: " + Properties.info().VERSION + " (" + Properties.info().BUILDNUMBER + ")\nDeveloped by: " + Properties.info().AUTHOR + " (" + Properties.info().AUTHOR_EMAIL + ")\n\nGitHub: " + Properties.info().GITHUB_LINK);
                alert.showAndWait();
                alert.hide();
            }
        });
        this.getItems().addAll((Object[])new MenuItem[]{this.menuItemConfigWizard, this.separator, menuItemManual, menuItemInfo});
    }

    public Menu removeConfigWizard() {
        this.getItems().removeAll((Object[])new MenuItem[]{this.menuItemConfigWizard, this.separator});
        return this;
    }
}

