/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.ui.gui;

import de.foellix.aql.Log;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;

public class Storage {
    private final String storageFolder = "data/gui/";
    private final String storageFileQ = "lastQueries.ser";
    private final String storageFileA = "lastAnswers.ser";
    List<File> queries;
    List<File> answers;
    private static Storage instance = new Storage();

    private Storage() {
        this.loadData();
        if (this.queries == null) {
            this.queries = new ArrayList<File>();
        }
        if (this.answers == null) {
            this.answers = new ArrayList<File>();
        }
    }

    public static Storage getInstance() {
        return instance;
    }

    public void store(File file, boolean isAnswer) {
        if (!isAnswer) {
            if (!this.queries.contains(file)) {
                this.queries.add(file);
            }
        } else if (!this.answers.contains(file)) {
            this.answers.add(file);
        }
        this.saveData();
    }

    private void loadData() {
        ObjectInputStream in;
        FileInputStream fileIn;
        try {
            fileIn = new FileInputStream(this.storageFolder + this.storageFileQ);
            in = new ObjectInputStream(fileIn);
            this.queries = (List)in.readObject();
            in.close();
            fileIn.close();
        }
        catch (IOException | ClassNotFoundException e) {
            Log.msg("Could not load last queries.", 6);
        }
        try {
            fileIn = new FileInputStream(this.storageFolder + this.storageFileA);
            in = new ObjectInputStream(fileIn);
            this.answers = (List)in.readObject();
            in.close();
            fileIn.close();
        }
        catch (IOException | ClassNotFoundException e) {
            Log.msg("Could not load last answers.", 6);
        }
        boolean changed = false;
        if (this.queries != null) {
            for (int i = 0; i < this.queries.size(); ++i) {
                if (this.queries.get(i).exists()) continue;
                this.queries.remove(i);
                --i;
                changed = true;
            }
        }
        if (this.answers != null) {
            for (int i = 0; i < this.answers.size(); ++i) {
                if (this.answers.get(i).exists()) continue;
                this.answers.remove(i);
                --i;
                changed = true;
            }
        }
        if (changed) {
            this.saveData();
        }
    }

    private void saveData() {
        ObjectOutputStream out;
        FileOutputStream fileOut;
        try {
            fileOut = new FileOutputStream(this.storageFolder + this.storageFileQ);
            out = new ObjectOutputStream(fileOut);
            out.writeObject(this.queries);
            out.close();
            fileOut.close();
        }
        catch (IOException e) {
            Log.msg("Could not save last queries.", 5);
        }
        try {
            fileOut = new FileOutputStream(this.storageFolder + this.storageFileA);
            out = new ObjectOutputStream(fileOut);
            out.writeObject(this.answers);
            out.close();
            fileOut.close();
        }
        catch (IOException e) {
            Log.msg("Could not save last answers.", 5);
        }
    }

    public List<File> getLastFiles(boolean isAnswer) {
        if (!isAnswer) {
            return this.queries;
        }
        return this.answers;
    }
}

