/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.ui.gui;

import de.foellix.aql.datastructure.Answer;
import de.foellix.aql.datastructure.handler.AnswerHandler;
import de.foellix.aql.ui.gui.BottomViewer;
import de.foellix.aql.ui.gui.GUI;
import de.foellix.aql.ui.gui.IGUI;
import de.foellix.aql.ui.gui.MenubarViewer;
import de.foellix.aql.ui.gui.ViewerXML;
import de.foellix.aql.ui.gui.viewer.graph.ViewerGraph;
import de.foellix.aql.ui.gui.viewer.web.ViewerWeb;
import java.io.File;
import javafx.scene.Node;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.layout.BorderPane;

public class Viewer
extends BorderPane {
    private final IGUI parent;
    public MenubarViewer menubarViewer;
    public ViewerXML viewerXML;
    public ViewerGraph viewerGraph;
    public ViewerWeb viewerWeb;

    public Viewer(IGUI parent) {
        this.parent = parent;
        this.menubarViewer = new MenubarViewer(this);
        this.viewerXML = new ViewerXML(this.menubarViewer);
        this.viewerGraph = new ViewerGraph(this, this.menubarViewer);
        this.viewerWeb = new ViewerWeb(this.menubarViewer);
        parent.getSystem().getAnswerReceivers().add(this.viewerXML);
        parent.getSystem().getAnswerReceivers().add(this.viewerGraph);
        parent.getSystem().getAnswerReceivers().add(this.viewerWeb);
        TabPane innerTabPane = new TabPane();
        Tab tabViewer1 = new Tab("XML");
        tabViewer1.setContent((Node)this.viewerXML);
        tabViewer1.setClosable(false);
        Tab tabViewer2 = new Tab("Graph");
        tabViewer2.setContent((Node)this.viewerGraph);
        tabViewer2.setClosable(false);
        Tab tabViewer3 = new Tab("Web");
        tabViewer3.setContent((Node)this.viewerWeb);
        tabViewer3.setClosable(false);
        innerTabPane.getTabs().addAll((Object[])new Tab[]{tabViewer1, tabViewer2, tabViewer3});
        this.setTop((Node)this.menubarViewer);
        if (parent instanceof GUI) {
            BottomViewer bottomViewer = new BottomViewer(this);
            parent.getSystem().getAnswerReceivers().add(bottomViewer);
            this.setBottom((Node)bottomViewer);
        }
        this.setCenter((Node)innerTabPane);
    }

    public void openFile(File file) {
        Answer temp = AnswerHandler.parseXML(file);
        this.openAnswer(temp);
    }

    public void openAnswer(Answer answer) {
        this.viewerXML.answerAvailable(answer, 0);
        this.viewerGraph.answerAvailable(answer, 0);
        this.viewerWeb.answerAvailable(answer, 0);
    }

    public void refreshGraph() {
        Answer temp = AnswerHandler.parseXML(this.viewerXML.getContent());
        this.viewerGraph.answerAvailable(temp, 0);
        this.viewerWeb.answerAvailable(temp, 0);
    }

    public IGUI getParentGUI() {
        return this.parent;
    }

    public void rotate() {
        this.viewerGraph.rotate();
    }

    public void zoomReset() {
        this.viewerGraph.zoomReset();
    }

    public void zoomIn() {
        this.viewerGraph.zoomIn();
    }

    public void zoomOut() {
        this.viewerGraph.zoomOut();
    }

    public void resetContent() {
        this.viewerXML.resetContent();
        this.viewerGraph.answerAvailable(new Answer(), 0);
        this.viewerWeb.answerAvailable(new Answer(), 0);
    }
}

