/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.ui.gui.viewer.graph;

import de.foellix.aql.Log;
import de.foellix.aql.datastructure.Attribute;
import de.foellix.aql.datastructure.Intentsink;
import de.foellix.aql.datastructure.Intentsource;
import de.foellix.aql.datastructure.Permission;
import de.foellix.aql.datastructure.Reference;
import de.foellix.aql.datastructure.handler.AnswerHandler;
import de.foellix.aql.helper.Helper;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.transform.Rotate;

public class Node {
    private final int fontSize = 11;
    private int lines = 1;
    private float posX;
    private float posY;
    private float width;
    private float height;
    private Object reference;
    private int dockX1 = 0;
    private int dockX2 = 0;

    public Node(float posX, float posY) {
        this.create(posX, posY, 1.0f, 1.0f, 1.0f, 1, 0.0f, 0, null);
    }

    public Node(float posX, float posY, float width, float height, float maxWidth, int maxHeight) {
        this.create(posX, posY, width, height, maxWidth, maxHeight, 0.0f, 0, null);
    }

    public Node(float posX, float posY, float width, float height, float maxWidth, int maxHeight, float minWidth, int minHeight, Object reference) {
        this.create(posX, posY, width, height, maxWidth, maxHeight, minWidth, minHeight, reference);
    }

    private void create(float posX, float posY, float width, float height, float maxWidth, int maxHeight, float minWidth, int minHeight, Object reference) {
        this.posX = posX;
        this.posY = posY;
        this.width = Math.max(Math.min(width, maxWidth), minWidth);
        this.height = Math.max(Math.min(height, (float)maxHeight), (float)minHeight);
        this.reference = reference;
    }

    public void draw(GraphicsContext gc) {
        this.draw(gc, false);
    }

    public void draw(GraphicsContext gc, boolean rotate) {
        gc.fillRoundRect((double)this.posX, (double)this.posY, (double)this.width, (double)this.height, 10.0, 10.0);
        gc.strokeRoundRect((double)this.posX, (double)this.posY, (double)this.width, (double)this.height, 10.0, 10.0);
        Paint p = gc.getFill();
        gc.setFill((Paint)Color.BLACK);
        gc.setFont(Font.font((String)"Tahoma", (FontWeight)FontWeight.BOLD, (double)this.fontSize));
        if (rotate) {
            gc.save();
            Rotate r = new Rotate(90.0, (double)this.posX, (double)this.posY);
            gc.setTransform(r.getMxx(), r.getMyx(), r.getMxy(), r.getMyy(), r.getTx(), r.getTy());
            gc.fillText(this.toString(), (double)(this.posX + 10.0f), (double)(this.posY - this.width / 2.0f + (float)(this.fontSize / 2) - (float)(this.fontSize / 2 * (this.lines - 1)) - (float)(1 * this.lines)));
            gc.restore();
        } else {
            gc.fillText(this.toString(), (double)(this.posX + 10.0f), (double)(this.posY + this.height / 2.0f + (float)(this.fontSize / 2) - (float)(this.fontSize / 2 * (this.lines - 1)) - (float)(1 * this.lines)));
        }
        gc.setFill(p);
    }

    public int getDockX(boolean fromTop) {
        if (fromTop) {
            ++this.dockX1;
            return this.dockX1;
        }
        ++this.dockX2;
        return this.dockX2;
    }

    public String toString() {
        if (this.reference instanceof Intentsource) {
            if (((Intentsource)this.reference).getTarget().getAction() != null && !((Intentsource)this.reference).getTarget().getAction().isEmpty()) {
                this.lines = 2;
                return ((Intentsource)this.reference).getTarget().getAction() + "\n" + (((Intentsource)this.reference).getTarget().getCategory() == null ? "-" : ((Intentsource)this.reference).getTarget().getCategory());
            }
            this.lines = 1;
            if (((Intentsource)this.reference).getTarget().getReference() != null && ((Intentsource)this.reference).getTarget().getReference().getClassname() != null) {
                return ((Intentsource)this.reference).getTarget().getReference().getClassname();
            }
            this.lines = 2;
            return "No short info except:\nImplicit without action";
        }
        if (this.reference instanceof Intentsink) {
            if (((Intentsink)this.reference).getTarget().getAction() != null && !((Intentsink)this.reference).getTarget().getAction().isEmpty()) {
                this.lines = 2;
                return ((Intentsink)this.reference).getTarget().getAction() + "\n" + (((Intentsink)this.reference).getTarget().getCategory() == null ? "-" : ((Intentsink)this.reference).getTarget().getCategory());
            }
            this.lines = 1;
            if (((Intentsink)this.reference).getTarget().getReference() != null && ((Intentsink)this.reference).getTarget().getReference().getClassname() != null) {
                return ((Intentsink)this.reference).getTarget().getReference().getClassname();
            }
            this.lines = 2;
            return "No short info except:\nImplicit without action";
        }
        if (this.reference instanceof Permission) {
            return ((Permission)this.reference).getName().replace("android.permission", "... ");
        }
        if (this.reference instanceof Reference) {
            String app;
            this.lines = 4;
            String statement = Helper.cut(Helper.cut(((Reference)this.reference).getStatement().getStatementfull(), "<", ">"), " ", -1);
            if (Helper.cut(statement, "(", ")").length() > 22) {
                statement = Helper.cutFromStart(statement, "(") + "(..)";
            }
            if ((app = Helper.cut(Helper.cut(((Reference)this.reference).getApp().getFile(), "/", -1), "\\", -1)).length() >= 34) {
                app = app.substring(0, 28) + "...apk";
            }
            return statement + "\n" + Helper.cut(((Reference)this.reference).getMethod(), " ", ">", -1) + "\n" + Helper.cut(((Reference)this.reference).getClassname(), ".", -1) + "\n" + app;
        }
        return super.toString();
    }

    public String tooltip() {
        if (this.reference instanceof Intentsource) {
            Intentsource reference = (Intentsource)this.reference;
            String attrStr = "";
            if (reference.getAttributes() != null) {
                for (Attribute attr : reference.getAttributes().getAttribute()) {
                    if (attrStr.equals("")) {
                        attrStr = "\n\nAttributes:\n";
                    }
                    attrStr = attrStr + attr.getName() + ": " + attr.getValue() + "\n";
                }
            }
            return "IntentSource\n\n" + Helper.toString(reference.getTarget()) + attrStr;
        }
        if (this.reference instanceof Intentsink) {
            Intentsink reference = (Intentsink)this.reference;
            String attrStr = "";
            if (reference.getAttributes() != null) {
                for (Attribute attr : reference.getAttributes().getAttribute()) {
                    if (attrStr.equals("")) {
                        attrStr = "\n\nAttributes:\n";
                    }
                    attrStr = attrStr + attr.getName() + ": " + attr.getValue() + "\n";
                }
            }
            return "IntentSink\n\n" + Helper.toString(reference.getTarget()) + attrStr;
        }
        if (this.reference instanceof Permission) {
            Permission reference = (Permission)this.reference;
            String attrStr = "";
            if (reference.getAttributes() != null) {
                for (Attribute attr : reference.getAttributes().getAttribute()) {
                    if (attrStr.equals("")) {
                        attrStr = "\n\nAttributes:\n";
                    }
                    attrStr = attrStr + attr.getName() + ": " + attr.getValue() + "\n";
                }
            }
            return "Permission\n\nName: " + reference.getName() + attrStr;
        }
        if (this.reference instanceof Reference) {
            Reference reference = (Reference)this.reference;
            return "Reference\n\nStatement: " + reference.getStatement().getStatementfull() + "\nMethod: " + reference.getMethod() + "\nClass: " + reference.getClassname() + "\nApp: " + reference.getApp().getFile();
        }
        return super.toString();
    }

    public String tooltip2() {
        String tooltip = AnswerHandler.createXMLString(this.reference);
        Log.msg("XML:\n" + tooltip, 6);
        return tooltip;
    }

    public float getPosX() {
        return this.posX;
    }

    public float getPosY() {
        return this.posY;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public Object getReference() {
        return this.reference;
    }

    public void setPosX(int posX) {
        this.posX = posX;
    }

    public void setPosY(int posY) {
        this.posY = posY;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setReference(Object reference) {
        this.reference = reference;
    }
}

