/*
 * Decompiled with CFR 0.152.
 */
package de.foellix.aql.ui.gui.viewer.web;

import de.foellix.aql.datastructure.Answer;
import de.foellix.aql.datastructure.Flow;
import de.foellix.aql.datastructure.Flows;
import de.foellix.aql.datastructure.Intentsink;
import de.foellix.aql.datastructure.Intentsource;
import de.foellix.aql.datastructure.Permission;
import de.foellix.aql.datastructure.Reference;
import de.foellix.aql.datastructure.handler.AnswerHandler;
import de.foellix.aql.helper.EqualsHelper;
import de.foellix.aql.helper.EqualsOptions;
import de.foellix.aql.helper.Helper;
import java.util.ArrayList;
import java.util.List;

public class Node {
    private int id;
    private Object item;
    private List<Reference> refs;

    public Node(int id, Object item) {
        this.id = id;
        this.item = item;
        this.refs = new ArrayList<Reference>();
    }

    public int getId() {
        return this.id;
    }

    public Object getItem() {
        return this.item;
    }

    public void setId(int id) {
        this.id = id;
    }

    public void setItem(Object item) {
        this.item = item;
    }

    public String toElement() {
        String xml;
        String label;
        String color = "#ededed";
        if (this.item instanceof Intentsource) {
            color = "#f29c9c";
            label = ((Intentsource)this.item).getTarget().getAction() != null && !((Intentsource)this.item).getTarget().getAction().isEmpty() ? ((Intentsource)this.item).getTarget().getAction() + "\n" + (((Intentsource)this.item).getTarget().getCategory() == null ? "-" : ((Intentsource)this.item).getTarget().getCategory()) : (((Intentsource)this.item).getTarget().getReference() != null && ((Intentsource)this.item).getTarget().getReference().getClassname() != null ? ((Intentsource)this.item).getTarget().getReference().getClassname() : "No short info except:\nImplicit without action");
        } else if (this.item instanceof Intentsink) {
            color = "#c0d6a3";
            label = ((Intentsink)this.item).getTarget().getAction() != null && !((Intentsink)this.item).getTarget().getAction().isEmpty() ? ((Intentsink)this.item).getTarget().getAction() + "\n" + (((Intentsink)this.item).getTarget().getCategory() == null ? "-" : ((Intentsink)this.item).getTarget().getCategory()) : (((Intentsink)this.item).getTarget().getReference() != null && ((Intentsink)this.item).getTarget().getReference().getClassname() != null ? ((Intentsink)this.item).getTarget().getReference().getClassname() : "No short info except:\nImplicit without action");
        } else if (this.item instanceof Permission) {
            color = "#d6ace4";
            label = ((Permission)this.item).getName().replace("android.permission", "... ");
        } else if (this.item instanceof Reference) {
            String app;
            color = this.refs.isEmpty() ? "#a3c3d6" : "#a3d6d6";
            String statement = Helper.cut(Helper.cut(((Reference)this.item).getStatement().getStatementfull(), "<", ">"), " ", -1);
            if (Helper.cut(statement, "(", ")").length() > 22) {
                statement = Helper.cutFromStart(statement, "(") + "(..)";
            }
            if ((app = Helper.cut(Helper.cut(((Reference)this.item).getApp().getFile(), "/", -1), "\\", -1)).length() >= 34) {
                app = app.substring(0, 28) + "...apk";
            }
            label = statement + "\n" + Helper.cut(((Reference)this.item).getMethod(), " ", ">", -1) + "\n" + Helper.cut(((Reference)this.item).getClassname(), ".", -1) + "\n" + app;
        } else {
            label = super.toString();
        }
        label = this.escape(label);
        int counter = 1;
        StringBuilder verbose = new StringBuilder(counter + ") " + this.escape(Helper.toString(this.item)));
        if (!this.refs.isEmpty() && this.item instanceof Reference) {
            Flow flow = new Flow();
            flow.getReference().add((Reference)this.item);
            for (Reference ref : this.refs) {
                flow.getReference().add(ref);
                verbose.append(this.escape("\n\n" + ++counter + ") " + Helper.toString(ref)));
            }
            Answer answerXML = new Answer();
            answerXML.setFlows(new Flows());
            answerXML.getFlows().getFlow().add(flow);
            xml = this.escape(AnswerHandler.createXMLString(answerXML));
        } else {
            xml = this.escape(AnswerHandler.createXMLString(this.item));
        }
        return "{ \"data\": { \"id\": \"" + this.id + "\", \"label\": \"" + label + "\", \"color\": \"" + color + "\", \"verbose\": \"" + verbose + "\", \"xml\": \"" + xml + "\" }},";
    }

    private String escape(String input) {
        return input.replaceAll("\\\\", "\\\\\\\\").replaceAll("\"", "\\\\\"").replaceAll("\n", "\\\\n");
    }

    public void addReference(Reference ref1) {
        EqualsOptions options = new EqualsOptions();
        options.setOption(1, true);
        if (EqualsHelper.equals(ref1, (Reference)this.item, options)) {
            return;
        }
        for (Reference ref2 : this.refs) {
            if (!EqualsHelper.equals(ref1, ref2, options)) continue;
            return;
        }
        this.refs.add(ref1);
    }
}

